------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2010-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

--  This software was originally contributed by William A. Duff

package GNATCOLL.Paragraph_Filling.Tests is

   type Formatter is not null access function
     (Paragraph       : String;
      Max_Line_Length : Positive;
      Line_Prefix     : String)
     return Ada.Strings.Unbounded.Unbounded_String;

   type Formatting_Context is record
      Format          : Formatter := Knuth_Fill'Access;
      Max_Line_Length : Positive  := Default_Max_Line_Length;
      Input_Name      : access String;
      Output_Name     : access String;
      Line_Prefix     : access String;
   end record;
   --  Describes the task that needs to be done by the formatting subprograms
   --  below.
   --  Input_Name is the file to read and format.
   --  The formatter output will be saved in Output_Name (if the empty string,
   --  the output is done on stdout).

   function Process_Command_Line return Formatting_Context;
   --  Parse the command line switches to decide on which method to use for the
   --  filling.

   procedure Format_Ada_File (Context : Formatting_Context);
   --  Runs the filling routine on each block comment of an Ada file.
   --  Text that is not part of a comment, and comments appearing after other
   --  non-whitespace text on the same line, is sent to the output unchanged.

   procedure Format_Text_File (Context : Formatting_Context);
   --  Runs the filling routine on a text file.

end GNATCOLL.Paragraph_Filling.Tests;
