------------------------------------------------------------------------------
--                                  G P S                                   --
--                                                                          --
--                     Copyright (C) 2003-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Command_Line;      use Ada.Command_Line;
with Ada.Text_IO;           use Ada.Text_IO;
with GNATCOLL.Scripts;          use GNATCOLL.Scripts;
with GNATCOLL.Scripts.Python;   use GNATCOLL.Scripts.Python;
with GNATCOLL.Scripts.Shell;    use GNATCOLL.Scripts.Shell;
with GNATCOLL.Traces;       use GNATCOLL.Traces;
with Testsuite_Export;      use Testsuite_Export;
with TestConsole;           use TestConsole;

procedure Testsuite is
   Repo    : Scripts_Repository := new Scripts_Repository_Record;
   Errors  : Boolean;
   Console : aliased Test_Console;
   Lang    : constant String := Argument (1);
   File    : constant String := Argument (2);
begin
   Parse_Config_File;

   --  Register a single language, so that we can more easily detect
   --  memory leaks in each case

   if Lang = Shell_Name then
      Register_Shell_Scripting (Repo);
   elsif Lang = Python_Name then
      Register_Python_Scripting (Repo, "M");
   end if;
   Register_Standard_Classes (Repo, "Console");

   Testsuite_Export.Register_Functions (Repo);

   Set_Default_Console
     (Lookup_Scripting_Language (Repo, Lang), Console'Unchecked_Access);

   Execute_File
     (Script       => Lookup_Scripting_Language (Repo, Lang),
      Filename     => File,
      Show_Command => False,
      Errors       => Errors);
   if Errors then
      Put_Line ("Errors were reported by Execute_File");
   end if;

   Free (Console);
   Destroy (Repo);

end Testsuite;
