/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.web.jsf.wizards;


import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;

import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;


public class JSFConfigurationWizardPanelVisual extends JPanel implements HelpCtx.Provider, ChangeListener {
    private WebModuleExtender wme;
    private ExtenderController controller;
    private JSFConfigurationWizardPanel panel;

    /** Creates new form PanelInitProject
     * @param project the web project; if it is null, all available web extensions will be shown
     * @param filter one of the options <code>ALL_FRAMEWORKS</code>, <code>USED_FRAMEWORKS</code>, <code>UNUSED_FRAMEWORKS</code>
     * @param ignoredFrameworks the list of frameworks to be ignored when creating list; null is allowed
     */
    JSFConfigurationWizardPanelVisual(JSFConfigurationWizardPanel panel, ExtenderController controller, WebModuleExtender wme) {
        this.panel = panel;
        this.controller = controller;
        this.wme = wme;

        initComponents();
        setConfigPanel();

        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationWizardPanelVisual.class, "ACS_JSF_Config_CRUD_Panel_A11YDesc"));  // NOI18N        

        // Provide a name in the title bar.
        setName(NbBundle.getMessage(JSFConfigurationWizardPanelVisual.class, "LBL_JSF_Config_CRUD")); //NOI18N
        putClientProperty ("NewProjectWizard_Title", NbBundle.getMessage(JSFConfigurationWizardPanelVisual.class, "LBL_JSF_Config_CRUD")); //NOI18N
    }


    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelConfig = new javax.swing.JLabel();
        jPanelConfig = new javax.swing.JPanel();

        setPreferredSize(new java.awt.Dimension(500, 340));
        setRequestFocusEnabled(false);

        jLabelConfig.setLabelFor(jPanelConfig);
        jLabelConfig.setText(org.openide.util.NbBundle.getMessage(JSFConfigurationWizardPanelVisual.class, "LBL_JSF_Config_CRUD_instruction")); // NOI18N

        jPanelConfig.setLayout(new java.awt.GridBagLayout());

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelConfig, javax.swing.GroupLayout.DEFAULT_SIZE, 488, Short.MAX_VALUE)
                    .addComponent(jPanelConfig, javax.swing.GroupLayout.DEFAULT_SIZE, 488, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jLabelConfig, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanelConfig, javax.swing.GroupLayout.DEFAULT_SIZE, 170, Short.MAX_VALUE)
                .addGap(137, 137, 137))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelConfig;
    private javax.swing.JPanel jPanelConfig;
    // End of variables declaration//GEN-END:variables

    boolean valid(WizardDescriptor wizardDescriptor) {
        setErrorMessage(wizardDescriptor, null);
        if (wme != null && !wme.isValid()) {
            if (controller.getErrorMessage() != null) {
                setErrorMessage(wizardDescriptor, controller.getErrorMessage());
            } else {
                String message = (String) controller.getProperties().getProperty(WizardDescriptor.PROP_INFO_MESSAGE);
                setInfoMessage(wizardDescriptor, message);
            }
            return false;
        }

        return true;
    }

    private void setErrorMessage(WizardDescriptor wizardDescriptor, String errorMessage) {
        if (errorMessage == null || errorMessage.length() == 0) {
            errorMessage = " "; // NOI18N
        }
        wizardDescriptor.putProperty(WizardDescriptor.PROP_ERROR_MESSAGE, errorMessage); // NOI18N
    }

    private void setInfoMessage(WizardDescriptor wizardDescriptor, String infoMessage) {
        if (infoMessage == null || infoMessage.length() == 0) {
            infoMessage = " "; // NOI18N
        }
        wizardDescriptor.putProperty(WizardDescriptor.PROP_INFO_MESSAGE, infoMessage); // NOI18N
    }

    void read(WizardDescriptor settings) {
        if (wme != null) {
            wme.update();
        }
    }

    void store(WizardDescriptor settings) {
    }


    /** Help context where to find more about the paste type action.
     * @return the help context for this action
     */
    public HelpCtx getHelpCtx() {
        if (jPanelConfig.getComponentCount()>0){
            for (int i = 0; i < jPanelConfig.getComponentCount(); i++)
                if (jPanelConfig.getComponent(i) instanceof  HelpCtx.Provider)
                    return ((HelpCtx.Provider)jPanelConfig.getComponent(i)).getHelpCtx();
        }
        return null;
    }


    private void setConfigPanel() {
        if (wme != null) {
            jPanelConfig.removeAll();

            java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;

            JComponent panelComponent = wme.getComponent();
            // be notified about jsfPanel changes - #203296
            JSFConfigurationPanelVisual jsfPanel = (JSFConfigurationPanelVisual) panelComponent;
            jsfPanel.addChangeListener(this);
            jPanelConfig.add(panelComponent, gridBagConstraints);
            
//            jLabelConfig.setEnabled(item.isSelected().booleanValue());
//            enableComponents(panelComponent, item.isSelected().booleanValue());
            
            //invoke JSFConfigurationPanelVisual.initLibraries now (during
            //construction of the wizard) instead of when this JavaServer Faces Configuration
            //panel is reached by the user, so as to ensure that the settings
            //set by wme.update() take precedence rather than those set by 
            //JSFConfigurationPanelVisual.initLibraries.
            if (panelComponent instanceof JSFConfigurationPanelVisual) {
                ((JSFConfigurationPanelVisual)panelComponent).initLibraries();
            }
            
            wme.update();
            jPanelConfig.revalidate();
            jPanelConfig.repaint();
        } else {
            jLabelConfig.setText(""); //NOI18N
            jPanelConfig.removeAll();
            jPanelConfig.repaint();
            jPanelConfig.revalidate();
        }
        
        if (panel != null)
            panel.fireChangeEvent();
    }
    
    public void stateChanged(javax.swing.event.ChangeEvent e) {
        if (panel != null)
            panel.fireChangeEvent();
    }
}
