#
# @file    TestGetMultipleObjects.py
# @brief   GetMultipleObjects unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Sarah Keating
 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestGetMultipleObjects.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestGetMultipleObjects(unittest.TestCase):


  def test_GetMultipleObjects_allElements(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    list = d.getListOfAllElements()
    self.assert_( list.getSize() == 37 )
    d = None
    pass  

  def test_GetMultipleObjects_getId(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    obj = d.getElementBySId("no_id")
    self.assert_( obj == None )
    obj = d.getElementBySId("")
    self.assert_( obj == None )
    obj = d.getElementBySId("find_id")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_MODEL )
    obj = d.getElementBySId("func1")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_FUNCTION_DEFINITION )
    obj = d.getElementBySId("comp")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_COMPARTMENT )
    obj = d.getElementBySId("b")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_SPECIES )
    obj = d.getElementBySId("x")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_PARAMETER )
    obj = d.getElementBySId("J0")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_REACTION )
    obj = d.getElementBySId("E0")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_EVENT )
    d = None
    pass  

  def test_GetMultipleObjects_getMetaId(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    obj = d.getElementByMetaId("no_id")
    self.assert_( obj == None )
    obj = d.getElementByMetaId("")
    self.assert_( obj == None )
    obj = d.getElementByMetaId("meta1")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_DOCUMENT )
    obj = d.getElementByMetaId("meta2")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_MODEL )
    obj = d.getElementByMetaId("meta3")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_COMPARTMENT )
    obj = d.getElementByMetaId("meta4")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_COMPARTMENT )
    obj = d.getElementByMetaId("meta5")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_SPECIES )
    obj = d.getElementByMetaId("meta6")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_SPECIES )
    obj = d.getElementByMetaId("meta7")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_REACTION )
    obj = d.getElementByMetaId("meta8")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_REACTION )
    obj = d.getElementByMetaId("meta9")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_SPECIES_REFERENCE )
    obj = d.getElementByMetaId("meta10")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_SPECIES_REFERENCE )
    obj = d.getElementByMetaId("meta11")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_KINETIC_LAW )
    obj = d.getElementByMetaId("meta12")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_EVENT )
    obj = d.getElementByMetaId("meta13")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_EVENT )
    obj = d.getElementByMetaId("meta14")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_TRIGGER )
    obj = d.getElementByMetaId("meta15")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_EVENT_ASSIGNMENT )
    obj = d.getElementByMetaId("meta16")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_EVENT_ASSIGNMENT )
    obj = d.getElementByMetaId("meta17")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_DELAY )
    obj = d.getElementByMetaId("meta18")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_PARAMETER )
    obj = d.getElementByMetaId("meta19")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_PRIORITY )
    obj = d.getElementByMetaId("meta20")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_FUNCTION_DEFINITION )
    obj = d.getElementByMetaId("meta21")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_FUNCTION_DEFINITION )
    obj = d.getElementByMetaId("meta22")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_INITIAL_ASSIGNMENT )
    obj = d.getElementByMetaId("meta23")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_INITIAL_ASSIGNMENT )
    obj = d.getElementByMetaId("meta24")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_RULE )
    obj = d.getElementByMetaId("meta25")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_RATE_RULE )
    obj = d.getElementByMetaId("meta26")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_ASSIGNMENT_RULE )
    obj = d.getElementByMetaId("meta27")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_LOCAL_PARAMETER )
    obj = d.getElementByMetaId("meta28")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LOCAL_PARAMETER )
    obj = d.getElementByMetaId("meta29")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_UNIT_DEFINITION )
    obj = d.getElementByMetaId("meta30")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_UNIT_DEFINITION )
    obj = d.getElementByMetaId("meta31")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_UNIT )
    obj = d.getElementByMetaId("meta32")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_UNIT )
    obj = d.getElementByMetaId("meta33")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_PARAMETER )
    obj = d.getElementByMetaId("meta34")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LIST_OF )
    self.assert_( obj.getItemTypeCode() == libsbml.SBML_MODIFIER_SPECIES_REFERENCE )
    obj = d.getElementByMetaId("meta35")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_MODIFIER_SPECIES_REFERENCE )
    d = None
    pass  

  def test_GetMultipleObjects_noAssignments(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "assignments-invalid.xml"
    d = reader.readSBML(filename)
    if (d.getModel() == None):
      pass    
    obj = d.getElementBySId("ia")
    self.assert_( obj == None )
    obj = d.getElementByMetaId("ia_meta")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_INITIAL_ASSIGNMENT )
    obj = d.getElementBySId("ar")
    self.assert_( obj == None )
    obj = d.getElementByMetaId("ar_meta")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_ASSIGNMENT_RULE )
    obj = d.getElementBySId("rr")
    self.assert_( obj == None )
    obj = d.getElementByMetaId("rr_meta")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_RATE_RULE )
    obj = d.getElementBySId("ea")
    self.assert_( obj == None )
    obj = d.getElementByMetaId("ea_meta")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_EVENT_ASSIGNMENT )
    d = None
    pass  

  def test_GetMultipleObjects_noLocalParameters(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    rxn = d.getElementBySId("J0")
    self.assert_( rxn != None )
    obj = rxn.getElementBySId("x")
    self.assert_( obj == None )
    obj = rxn.getElementByMetaId("meta28")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_LOCAL_PARAMETER )
    d = None
    pass  

  def test_GetMultipleObjects_noUnits(self):
    reader = libsbml.SBMLReader()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == None):
      pass    
    obj = d.getElementBySId("volume")
    self.assert_( obj == None )
    obj = d.getElementByMetaId("meta30")
    self.assert_( obj != None )
    self.assert_( obj.getTypeCode() == libsbml.SBML_UNIT_DEFINITION )
    d = None
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestGetMultipleObjects))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
