/* Hey EMACS -*- linux-c -*- */
/* $Id: keys83p.h 1179 2005-06-06 14:42:32Z roms $ */

/*  libticalcs - Ti Calculator library, a part of the TiLP project
 *  Copyright (C) 1999-2005  Romain Livin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __TICALCS_KEYS83__
#define __TICALCS_KEYS83__

// Scan codes of the TI83 (thanks to B. Moody)

#define KEY83_Right            0x01
#define KEY83_Left             0x02
#define KEY83_Up               0x03
#define KEY83_Down             0x04
#define KEY83_Enter            0x05
#define KEY83_AlphaEnter       0x06
#define KEY83_AlphaUp          0x07
#define KEY83_AlphaDown        0x08
#define KEY83_Clear            0x09
#define KEY83_Del              0x0A
#define KEY83_Ins              0x0B
#define KEY83_Recall           0x0C
#define KEY83_LastEnt          0x0D
#define KEY83_BOL              0x0E
#define KEY83_EOL              0x0F
#define KEY83_SelAll           0x10
#define KEY83_UnselAll         0x11
#define KEY83_LtoTI82          0x12
#define KEY83_Backup           0x13
#define KEY83_Recieve          0x14
#define KEY83_LnkQuit          0x15
#define KEY83_Trans            0x16
#define KEY83_Rename           0x17
#define KEY83_Overw            0x18
#define KEY83_Omit             0x19
#define KEY83_Cont             0x1A
#define KEY83_SendID           0x1B
#define KEY83_SendSW           0x1C
#define KEY83_Yes              0x1D
#define KEY83_NoWay            0x1E
#define KEY83_vSendType        0x1F
#define KEY83_OverWAll         0x20
#define KEY83_No               0x25
#define KEY83_KReset           0x26
#define KEY83_App              0x27
#define KEY83_Doug             0x28
#define KEY83_Listflag         0x29
#define KEY83_AreYouSure       0x2B
#define KEY83_AppsMenu         0x2C
#define KEY83_Prgm             0x2D
#define KEY83_Zoom             0x2E
#define KEY83_Draw             0x2F
#define KEY83_SPlot            0x30
#define KEY83_Stat             0x31
#define KEY83_Math             0x32
#define KEY83_Test             0x33
#define KEY83_Char             0x34
#define KEY83_Vars             0x35
#define KEY83_Mem              0x36
#define KEY83_Matrix           0x37
#define KEY83_Dist             0x38
#define KEY83_Angle            0x39
#define KEY83_List             0x3A
#define KEY83_Calc             0x3B
#define KEY83_Fin              0x3C
#define KEY83_Catalog          0x3E
#define KEY83_Off              0x3F
#define KEY83_Quit             0x40
#define KEY83_LinkIO           0x41
#define KEY83_MatrixEd         0x42
#define KEY83_StatEd           0x43
#define KEY83_Graph            0x44
#define KEY83_Mode             0x45
#define KEY83_PrgmEd           0x46
#define KEY83_PrgmCr           0x47
#define KEY83_Window           0x48
#define KEY83_Yequ             0x49
#define KEY83_Table            0x4A
#define KEY83_TblSet           0x4B
#define KEY83_ChkRAM           0x4C
#define KEY83_DelMem           0x4D
#define KEY83_ResetMem         0x4E
#define KEY83_ResetDef         0x4F
#define KEY83_PrgmInput        0x50
#define KEY83_ZFactEd          0x51
#define KEY83_Error            0x52
#define KEY83_SolveTVM         0x53
#define KEY83_SolveRoot        0x54
#define KEY83_StatP            0x55
#define KEY83_InfStat          0x56
#define KEY83_Format           0x57
#define KEY83_ExtApps          0x58
#define KEY83_NewApps          0x59
#define KEY83_Trace            0x5A
#define KEY83_ZFit             0x5B
#define KEY83_ZIn              0x5C
#define KEY83_ZOut             0x5D
#define KEY83_ZPrev            0x5E
#define KEY83_Box              0x5F
#define KEY83_Decml            0x60
#define KEY83_SetZm            0x61
#define KEY83_Squar            0x62
#define KEY83_Std              0x63
#define KEY83_Trig             0x64
#define KEY83_UsrZm            0x65
#define KEY83_ZSto             0x66
#define KEY83_ZInt             0x67
#define KEY83_ZStat            0x68
#define KEY83_Select           0x69
#define KEY83_Circl            0x6A
#define KEY83_ClDrw            0x6B
#define KEY83_Line             0x6C
#define KEY83_Pen              0x6D
#define KEY83_PtChg            0x6E
#define KEY83_PtOff            0x6F
#define KEY83_PtOn             0x70
#define KEY83_Vert             0x71
#define KEY83_Horiz            0x72
#define KEY83_Text             0x73
#define KEY83_TanLn            0x74
#define KEY83_Eval             0x75
#define KEY83_Inters           0x76
#define KEY83_DYDX             0x77
#define KEY83_FnIntg           0x78
#define KEY83_RootG            0x79
#define KEY83_DYDT             0x7A
#define KEY83_DXDT             0x7B
#define KEY83_DRDo             0x7C
#define KEY83_GFMin            0x7D
#define KEY83_GFMax            0x7E
#define KEY83_ListName         0x7F
#define KEY83_Add              0x80
#define KEY83_Sub              0x81
#define KEY83_Mul              0x82
#define KEY83_Div              0x83
#define KEY83_Expon            0x84
#define KEY83_LParen           0x85
#define KEY83_RParen           0x86
#define KEY83_LBrack           0x87
#define KEY83_RBrack           0x88
#define KEY83_Shade            0x89
#define KEY83_Store            0x8A
#define KEY83_Comma            0x8B
#define KEY83_Chs              0x8C
#define KEY83_DecPnt           0x8D
#define KEY83_0                0x8E
#define KEY83_1                0x8F
#define KEY83_2                0x90
#define KEY83_3                0x91
#define KEY83_4                0x92
#define KEY83_5                0x93
#define KEY83_6                0x94
#define KEY83_7                0x95
#define KEY83_8                0x96
#define KEY83_9                0x97
#define KEY83_EE               0x98
#define KEY83_Space            0x99
#define KEY83_CapA             0x9A
#define KEY83_CapB             0x9B
#define KEY83_CapC             0x9C
#define KEY83_CapD             0x9D
#define KEY83_CapE             0x9E
#define KEY83_CapF             0x9F
#define KEY83_CapG             0xA0
#define KEY83_CapH             0xA1
#define KEY83_CapI             0xA2
#define KEY83_CapJ             0xA3
#define KEY83_CapK             0xA4
#define KEY83_CapL             0xA5
#define KEY83_CapM             0xA6
#define KEY83_CapN             0xA7
#define KEY83_CapO             0xA8
#define KEY83_CapP             0xA9
#define KEY83_CapQ             0xAA
#define KEY83_CapR             0xAB
#define KEY83_CapS             0xAC
#define KEY83_CapT             0xAD
#define KEY83_CapU             0xAE
#define KEY83_CapV             0xAF
#define KEY83_CapW             0xB0
#define KEY83_CapX             0xB1
#define KEY83_CapY             0xB2
#define KEY83_CapZ             0xB3
#define KEY83_Varx             0xB4
#define KEY83_Pi               0xB5
#define KEY83_Inv              0xB6
#define KEY83_Sin              0xB7
#define KEY83_ASin             0xB8
#define KEY83_Cos              0xB9
#define KEY83_ACos             0xBA
#define KEY83_Tan              0xBB
#define KEY83_ATan             0xBC
#define KEY83_Square           0xBD
#define KEY83_Sqrt             0xBE
#define KEY83_Ln               0xBF
#define KEY83_Exp              0xC0
#define KEY83_Log              0xC1
#define KEY83_ALog             0xC2
#define KEY83_ToABC            0xC3
#define KEY83_ClrTbl           0xC4
#define KEY83_Ans              0xC5
#define KEY83_Colon            0xC6
#define KEY83_NDeriv           0xC7
#define KEY83_FnInt            0xC8
#define KEY83_Root             0xC9
#define KEY83_Quest            0xCA
#define KEY83_Quote            0xCB
#define KEY83_Theta            0xCC
#define KEY83_If               0xCD
#define KEY83_Then             0xCE
#define KEY83_Else             0xCF
#define KEY83_For              0xD0
#define KEY83_While            0xD1
#define KEY83_Repeat           0xD2
#define KEY83_End              0xD3
#define KEY83_Pause            0xD4
#define KEY83_Lbl              0xD5
#define KEY83_Goto             0xD6
#define KEY83_ISG              0xD7
#define KEY83_DSL              0xD8
#define KEY83_Menu             0xD9
#define KEY83_Exec             0xDA
#define KEY83_Return           0xDB
#define KEY83_Stop             0xDC
#define KEY83_Input            0xDD
#define KEY83_Prompt           0xDE
#define KEY83_Disp             0xDF
#define KEY83_DispG            0xE0
#define KEY83_DispT            0xE1
#define KEY83_Output           0xE2
#define KEY83_GetKey           0xE3
#define KEY83_ClrHome          0xE4
#define KEY83_PrtScr           0xE5
#define KEY83_SinH             0xE6
#define KEY83_CosH             0xE7
#define KEY83_TanH             0xE8
#define KEY83_ASinH            0xE9
#define KEY83_ACosH            0xEA
#define KEY83_ATanH            0xEB
#define KEY83_LBrace           0xEC
#define KEY83_RBrace           0xED
#define KEY83_I                0xEE
#define KEY83_CONSTeA          0xEF
#define KEY83_Plot3            0xF0
#define KEY83_FMin             0xF1
#define KEY83_FMax             0xF2
#define KEY83_L1A              0xF3
#define KEY83_L2A              0xF4
#define KEY83_L3A              0xF5
#define KEY83_L4A              0xF6
#define KEY83_L5A              0xF7
#define KEY83_L6A              0xF8
#define KEY83_unA              0xF9
#define KEY83_vnA              0xFA
#define KEY83_wnA              0xFB

// FE (ExtendEcho) prefixed keys:

#define KE1BT					0xfe00

#define KEY83_DrawInv          0xfe00
#define KEY83_DrawF            0xfe01
#define KEY83_PixelOn          0xfe02
#define KEY83_PixelOff         0xfe03
#define KEY83_PxlTest          0xfe04
#define KEY83_RCGDB            0xfe05
#define KEY83_RCPic            0xfe06
#define KEY83_STGDB            0xfe07
#define KEY83_STPic            0xfe08
#define KEY83_Abs              0xfe09
#define KEY83_TEqu             0xfe0a
#define KEY83_TNoteQ           0xfe0b
#define KEY83_TGT              0xfe0c
#define KEY83_TGTE             0xfe0d
#define KEY83_TLT              0xfe0e
#define KEY83_TLTE             0xfe0f
#define KEY83_And              0xfe10
#define KEY83_Or               0xfe11
#define KEY83_Xor              0xfe12
#define KEY83_Not              0xfe13
#define KEY83_LR1              0xfe14
#define KEY83_XRoot            0xfe15
#define KEY83_Cube             0xfe16
#define KEY83_CbRt             0xfe17
#define KEY83_ToDec            0xfe18
#define KEY83_CubicR           0xfe19
#define KEY83_QuartR           0xfe1a
#define KEY83_Plot1            0xfe1b
#define KEY83_Plot2            0xfe1c
#define KEY83_Round            0xfe1d
#define KEY83_IPart            0xfe1e
#define KEY83_FPart            0xfe1f
#define KEY83_Int              0xfe20
#define KEY83_Rand             0xfe21
#define KEY83_NPR              0xfe22
#define KEY83_NCR              0xfe23
#define KEY83_XFactorial       0xfe24
#define KEY83_Rad              0xfe25
#define KEY83_Degr             0xfe26
#define KEY83_APost            0xfe27
#define KEY83_ToDMS            0xfe28
#define KEY83_RToPo            0xfe29
#define KEY83_RToPr            0xfe2a
#define KEY83_PToRx            0xfe2b
#define KEY83_PToRy            0xfe2c
#define KEY83_RowSwap          0xfe2d
#define KEY83_RowPlus          0xfe2e
#define KEY83_TimRow           0xfe2f
#define KEY83_TRowP            0xfe30
#define KEY83_SortA            0xfe31
#define KEY83_SortD            0xfe32
#define KEY83_Seq              0xfe33
#define KEY83_Min              0xfe34
#define KEY83_Max              0xfe35
#define KEY83_Mean             0xfe36
#define KEY83_Median           0xfe37
#define KEY83_Sum              0xfe38
#define KEY83_Prod             0xfe39
#define KEY83_Det              0xfe3a
#define KEY83_Transp           0xfe3b
#define KEY83_Dim              0xfe3c
#define KEY83_Fill             0xfe3d
#define KEY83_Ident            0xfe3e
#define KEY83_Randm            0xfe3f
#define KEY83_Aug              0xfe40
#define KEY83_OneVar           0xfe41
#define KEY83_TwoVar           0xfe42
#define KEY83_LR               0xfe43
#define KEY83_LRExp            0xfe44
#define KEY83_LRLn             0xfe45
#define KEY83_LRPwr            0xfe46
#define KEY83_MedMed           0xfe47
#define KEY83_Quad             0xfe48
#define KEY83_ClrLst           0xfe49
#define KEY83_Hist             0xfe4a
#define KEY83_xyLine           0xfe4b
#define KEY83_Scatter          0xfe4c
#define KEY83_mRad             0xfe4d
#define KEY83_mDeg             0xfe4e
#define KEY83_mNormF           0xfe4f
#define KEY83_mSci             0xfe50
#define KEY83_mEng             0xfe51
#define KEY83_mFloat           0xfe52
#define KEY83_Fix              0xfe53
#define KEY83_SplitOn          0xfe54
#define KEY83_FullScreen       0xfe55
#define KEY83_Stndrd           0xfe56
#define KEY83_Param            0xfe57
#define KEY83_Polar            0xfe58
#define KEY83_SeqG             0xfe59
#define KEY83_AFillOn          0xfe5a
#define KEY83_AFillOff         0xfe5b
#define KEY83_ACalcOn          0xfe5c
#define KEY83_ACalcOff         0xfe5d
#define KEY83_FNOn             0xfe5e
#define KEY83_FNOff            0xfe5f
#define KEY83_PlotsOn          0xfe60
#define KEY83_PlotsOff         0xfe61
#define KEY83_PixelChg         0xfe62
#define KEY83_SendMBL          0xfe63
#define KEY83_RecvMBL          0xfe64
#define KEY83_BoxPlot          0xfe65
#define KEY83_BoxIcon          0xfe66
#define KEY83_CrossIcon        0xfe67
#define KEY83_DotIcon          0xfe68
#define KEY83_Seqential        0xfe69
#define KEY83_SimulG           0xfe6a
#define KEY83_PolarG           0xfe6b
#define KEY83_RectG            0xfe6c
#define KEY83_CoordOn          0xfe6d
#define KEY83_CoordOff         0xfe6e
#define KEY83_DrawLine         0xfe6f
#define KEY83_DrawDot          0xfe70
#define KEY83_AxisOn           0xfe71
#define KEY83_AxisOff          0xfe72
#define KEY83_GridOn           0xfe73
#define KEY83_GridOff          0xfe74
#define KEY83_LblOn            0xfe75
#define KEY83_LblOff           0xfe76
#define KEY83_L1               0xfe77
#define KEY83_infData          0xfe77
#define KEY83_L2               0xfe78
#define KEY83_infStats         0xfe78
#define KEY83_L3               0xfe79
#define KEY83_infYes           0xfe79
#define KEY83_L4               0xfe7a
#define KEY83_infNo            0xfe7a
#define KEY83_L5               0xfe7b
#define KEY83_infCalc          0xfe7b
#define KEY83_L6               0xfe7c
#define KEY83_infDraw          0xfe7c
#define KEY83_MatA             0xfe7d
#define KEY83_infAlt1ne        0xfe7d
#define KEY83_MatB             0xfe7e
#define KEY83_infAlt1lt        0xfe7e
#define KEY83_MatC             0xfe7f
#define KEY83_infAlt1gt        0xfe7f
#define KEY83_MatD             0xfe80
#define KEY83_infAlt2ne        0xfe80
#define KEY83_MatE             0xfe81
#define KEY83_infAlt2lt        0xfe81
#define KEY83_Xmin             0xfe82
#define KEY83_infAlt2gt        0xfe82
#define KEY83_Xmax             0xfe83
#define KEY83_infAlt3ne        0xfe83
#define KEY83_Xscl             0xfe84
#define KEY83_infAlt3lt        0xfe84
#define KEY83_Ymin             0xfe85
#define KEY83_infAlt3gt        0xfe85
#define KEY83_Ymax             0xfe86
#define KEY83_infAlt4ne        0xfe86
#define KEY83_Yscl             0xfe87
#define KEY83_infAlt4lt        0xfe87
#define KEY83_Tmin             0xfe88
#define KEY83_infAlt4gt        0xfe88
#define KEY83_Tmax             0xfe89
#define KEY83_infAlt5ne        0xfe89
#define KEY83_TStep            0xfe8a
#define KEY83_infAlt5lt        0xfe8a
#define KEY83_Omin             0xfe8b
#define KEY83_infAlt5gt        0xfe8b
#define KEY83_Omax             0xfe8c
#define KEY83_infAlt6ne        0xfe8c
#define KEY83_OStep            0xfe8d
#define KEY83_infAlt6lt        0xfe8d
#define KEY83_infAlt6gt        0xfe8e
#define KEY83_u0               0xfe8e
#define KEY83_v0               0xfe8f
#define KEY83_nMin             0xfe90
#define KEY83_nMax             0xfe91
#define KEY83_DeltaY           0xfe92
#define KEY83_DeltaX           0xfe93
#define KEY83_ZXmin            0xfe94
#define KEY83_ZXmax            0xfe95
#define KEY83_ZXscl            0xfe96
#define KEY83_ZYmin            0xfe97
#define KEY83_ZYmax            0xfe98
#define KEY83_ZYscl            0xfe99
#define KEY83_ZTmin            0xfe9a
#define KEY83_ZTmax            0xfe9b
#define KEY83_ZTStep           0xfe9c
#define KEY83_ZOmin            0xfe9d
#define KEY83_ZOmax            0xfe9e
#define KEY83_ZOStep           0xfe9f
#define KEY83_Zu0              0xfea0
#define KEY83_Zv0              0xfea1
#define KEY83_ZnMin            0xfea2
#define KEY83_ZnMax            0xfea3
#define KEY83_DelLast          0xfea4
#define KEY83_SinReg           0xfea5
#define KEY83_ConstE           0xfea6
#define KEY83_Pic1             0xfea7
#define KEY83_Pic2             0xfea8
#define KEY83_Pic3             0xfea9
#define KEY83_DelVar           0xfeaa
#define KEY83_GetCalc          0xfeab
#define KEY83_RealM            0xfeac
#define KEY83_PolarM           0xfead
#define KEY83_RectM            0xfeae
#define KEY83_uv               0xfeaf
#define KEY83_vw               0xfeb0
#define KEY83_uw               0xfeb1
#define KEY83_FinPMTend        0xfeb2
#define KEY83_FinPMTbeg        0xfeb3
#define KEY83_GraphStyle       0xfeb4
#define KEY83_ExprOn           0xfeb5
#define KEY83_ExprOff          0xfeb6
#define KEY83_StatA            0xfeb7
#define KEY83_StatB            0xfeb8
#define KEY83_StatC            0xfeb9
#define KEY83_Corr             0xfeba
#define KEY83_StatD            0xfebb
#define KEY83_StatE            0xfebc
#define KEY83_RegEq            0xfebd
#define KEY83_MinX             0xfebe
#define KEY83_Q1               0xfebf
#define KEY83_MD               0xfec0
#define KEY83_Q3               0xfec1
#define KEY83_MaxX             0xfec2
#define KEY83_StatX1           0xfec3
#define KEY83_StatY1           0xfec4
#define KEY83_StatX2           0xfec5
#define KEY83_StatY2           0xfec6
#define KEY83_StatX3           0xfec7
#define KEY83_StatY3           0xfec8
#define KEY83_TblMin           0xfec9
#define KEY83_TblStep          0xfeca
#define KEY83_SetupLst         0xfecb
#define KEY83_ClrAllLst        0xfecc
#define KEY83_Logistic         0xfecd
#define KEY83_ZTest            0xfece
#define KEY83_TTest            0xfecf
#define KEY83_2SampZTest       0xfed0
#define KEY83_2SampTTest       0xfed1
#define KEY83_1PropZTest       0xfed2
#define KEY83_2PropZTest       0xfed3
#define KEY83_ChiTest          0xfed4
#define KEY83_2SampFTest       0xfed5
#define KEY83_ZIntVal          0xfed6
#define KEY83_TIntVal          0xfed7
#define KEY83_2SampTInt        0xfed8
#define KEY83_2SampZInt        0xfed9
#define KEY83_1PropZInt        0xfeda
#define KEY83_2PropZInt        0xfedb
#define KEY83_DNormal          0xfedc
#define KEY83_InvNorm          0xfedd
#define KEY83_DT               0xfede
#define KEY83_Chi              0xfedf
#define KEY83_DF               0xfee0
#define KEY83_BinPDF           0xfee1
#define KEY83_BinCDF           0xfee2
#define KEY83_PoiPDF           0xfee3
#define KEY83_PoiCDF           0xfee4
#define KEY83_un               0xfee5
#define KEY83_vn               0xfee6
#define KEY83_wn               0xfee7
#define KEY83_Recn             0xfee8
#define KEY83_PlotStart        0xfee9
#define KEY83_ZPlotStart       0xfeea
#define KEY83_XFact            0xfeeb
#define KEY83_YFact            0xfeec
#define KEY83_ANOVA            0xfeed
#define KEY83_MaxY             0xfeee
#define KEY83_WebOn            0xfeef
#define KEY83_WebOff           0xfef0
#define KEY83_TblInput         0xfef1
#define KEY83_GeoPDF           0xfef2
#define KEY83_GeoCDF           0xfef3
#define KEY83_ShadeNorm        0xfef4
#define KEY83_ShadeT           0xfef5
#define KEY83_ShadeChi         0xfef6
#define KEY83_ShadeF           0xfef7
#define KEY83_PlotStep         0xfef8
#define KEY83_ZPlotStep        0xfef9
#define KEY83_LinRegtTest      0xfefa
#define KEY83_MGT              0xfefb
#define KEY83_SelectA          0xfefc
#define KEY83_ZFitA            0xfefd

// FC (ExtendEcho2) prefixed keys:

#define KE2BT2					0xfc00

#define KEY83_GDB1             0xfc00
#define KEY83_GDB2             0xfc01
#define KEY83_GDB3             0xfc02
#define KEY83_Y1               0xfc03
#define KEY83_Y2               0xfc04
#define KEY83_Y3               0xfc05
#define KEY83_Y4               0xfc06
#define KEY83_Y5               0xfc07
#define KEY83_Y6               0xfc08
#define KEY83_Y7               0xfc09
#define KEY83_Y8               0xfc0a
#define KEY83_Y9               0xfc0b
#define KEY83_Y0               0xfc0c
#define KEY83_X1T              0xfc0d
#define KEY83_Y1T              0xfc0e
#define KEY83_X2T              0xfc0f
#define KEY83_Y2T              0xfc10
#define KEY83_X3T              0xfc11
#define KEY83_Y3T              0xfc12
#define KEY83_X4T              0xfc13
#define KEY83_Y4T              0xfc14
#define KEY83_X5T              0xfc15
#define KEY83_Y5T              0xfc16
#define KEY83_X6T              0xfc17
#define KEY83_Y6T              0xfc18
#define KEY83_R1               0xfc19
#define KEY83_R2               0xfc1a
#define KEY83_R3               0xfc1b
#define KEY83_R4               0xfc1c
#define KEY83_R5               0xfc1d
#define KEY83_R6               0xfc1e
#define KEY83_GDB4             0xfc1f
#define KEY83_GDB5             0xfc20
#define KEY83_GDB6             0xfc21
#define KEY83_Pic4             0xfc22
#define KEY83_Pic5             0xfc23
#define KEY83_Pic6             0xfc24
#define KEY83_GDB7             0xfc25
#define KEY83_GDB8             0xfc26
#define KEY83_GDB9             0xfc27
#define KEY83_GDB0             0xfc28
#define KEY83_Pic7             0xfc29
#define KEY83_Pic8             0xfc2a
#define KEY83_Pic9             0xfc2b
#define KEY83_Pic0             0xfc2c
#define KEY83_StatN            0xfc2d
#define KEY83_XMean            0xfc2e
#define KEY83_Conj             0xfc2f
#define KEY83_Real             0xfc30
#define KEY83_FAngle           0xfc31
#define KEY83_LCM              0xfc32
#define KEY83_GCD              0xfc33
#define KEY83_RandInt          0xfc34
#define KEY83_RandNorm         0xfc35
#define KEY83_ToPolar          0xfc36
#define KEY83_ToRect           0xfc37
#define KEY83_YMean            0xfc38
#define KEY83_StdX             0xfc39
#define KEY83_StdX1            0xfc3a
#define KEY83_w0               0xfc3b
#define KEY83_MatF             0xfc3c
#define KEY83_MatG             0xfc3d
#define KEY83_MatRH            0xfc3e
#define KEY83_MatI             0xfc3f
#define KEY83_MatJ             0xfc40
#define KEY83_YMean1           0xfc41
#define KEY83_StdY             0xfc42
#define KEY83_StdY1            0xfc43
#define KEY83_MatToLst         0xfc44
#define KEY83_LstToMat         0xfc45
#define KEY83_CumSum           0xfc46
#define KEY83_DeltaLst         0xfc47
#define KEY83_StdDev           0xfc48
#define KEY83_Variance         0xfc49
#define KEY83_Length           0xfc4a
#define KEY83_EquToStrng       0xfc4b
#define KEY83_StrngToEqu       0xfc4c
#define KEY83_Expr             0xfc4d
#define KEY83_SubStrng         0xfc4e
#define KEY83_InStrng          0xfc4f
#define KEY83_Str1             0xfc50
#define KEY83_Str2             0xfc51
#define KEY83_Str3             0xfc52
#define KEY83_Str4             0xfc53
#define KEY83_Str5             0xfc54
#define KEY83_Str6             0xfc55
#define KEY83_Str7             0xfc56
#define KEY83_Str8             0xfc57
#define KEY83_Str9             0xfc58
#define KEY83_Str0             0xfc59
#define KEY83_FinN             0xfc5a
#define KEY83_FinI             0xfc5b
#define KEY83_FinPV            0xfc5c
#define KEY83_FinPMT           0xfc5d
#define KEY83_FinFV            0xfc5e
#define KEY83_FinPY            0xfc5f
#define KEY83_FinCY            0xfc60
#define KEY83_FinFPMT          0xfc61
#define KEY83_FinFI            0xfc62
#define KEY83_FinFPV           0xfc63
#define KEY83_FinFN            0xfc64
#define KEY83_FinFFV           0xfc65
#define KEY83_FinNPV           0xfc66
#define KEY83_FinIRR           0xfc67
#define KEY83_FinBAL           0xfc68
#define KEY83_FinPRN           0xfc69
#define KEY83_FinINT           0xfc6a
#define KEY83_SumX             0xfc6b
#define KEY83_SumX2            0xfc6c
#define KEY83_FinToNom         0xfc6d
#define KEY83_FinToEff         0xfc6e
#define KEY83_FinDBD           0xfc6f
#define KEY83_StatVP           0xfc70
#define KEY83_StatZ            0xfc71
#define KEY83_StatT            0xfc72
#define KEY83_StatChi          0xfc73
#define KEY83_StatF            0xfc74
#define KEY83_StatDF           0xfc75
#define KEY83_StatPhat         0xfc76
#define KEY83_StatPhat1        0xfc77
#define KEY83_StatPhat2        0xfc78
#define KEY83_StatMeanX1       0xfc79
#define KEY83_StatMeanX2       0xfc7a
#define KEY83_StatStdX1        0xfc7b
#define KEY83_StatStdX2        0xfc7c
#define KEY83_StatStdXP        0xfc7d
#define KEY83_StatN1           0xfc7e
#define KEY83_StatN2           0xfc7f
#define KEY83_StatLower        0xfc80
#define KEY83_StatUpper        0xfc81
#define KEY83_uw0              0xfc82
#define KEY83_Imag             0xfc83
#define KEY83_SumY             0xfc84
#define KEY83_Xres             0xfc85
#define KEY83_Stat_s           0xfc86
#define KEY83_SumY2            0xfc87
#define KEY83_SumXY            0xfc88
#define KEY83_uXres            0xfc89
#define KEY83_ModBox           0xfc8a
#define KEY83_NormProb         0xfc8b
#define KEY83_NormalPDF        0xfc8c
#define KEY83_TPDF             0xfc8d
#define KEY83_ChiPDF           0xfc8e
#define KEY83_FPDF             0xfc8f
#define KEY83_MinY             0xfc90
#define KEY83_RandBin          0xfc91
#define KEY83_Ref              0xfc92
#define KEY83_RRef             0xfc93
#define KEY83_LRSqr            0xfc94
#define KEY83_BRSqr            0xfc95
#define KEY83_DiagOn           0xfc96
#define KEY83_DiagOff          0xfc97
#define KEY83_un1              0xfc98
#define KEY83_vn1              0xfc99

#endif
