# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.uniforms import Uniforms


class OpenGLUniforms(Uniforms):
    r"""
    OpenGLUniforms - helper class to set custom uniform variables in
    GLSL shaders.
    
    Superclass: Uniforms
    
    This class implements all set_uniform* functions supported by
    ShaderProgram but instead of directly calling the underlying
    open_gl functions, it caches the name and value of the variable and
    provides a mechanism for client mappers to set all cached variables
    at once in a generic way.
    
    The basic types of GLSL uniform variables supported by the class are
    the following: int, float, vec2i, vec3, vec4, mat3, mat4, int[],
    float[], vec2i[], vec3[], vec4[], mat4[]. All other types supported
    by Set* functions undergo the same type conversions implemented in
    ShaderProgram.
    
    @par Thanks: Developed by Simon Drouin (sdrouin2@bwh.harvard.edu) at
    Brigham and Women's Hospital.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLUniforms, obj, update, **traits)
    
    def _get_uniform(self):
        return self._vtk_obj.GetUniform()
    def _set_uniform(self, arg):
        old_val = self._get_uniform()
        self._wrap_call(self._vtk_obj.SetUniform,
                        arg)
        self.trait_property_changed('uniform', old_val, arg)
    uniform = traits.Property(_get_uniform, _set_uniform, desc=\
        r"""
        
        """
    )

    def get_uniform1fv(self, *args):
        """
        get_uniform1fv(self, name:str, f:[float, ...]) -> bool
        C++: bool get_uniform1fv(const char *name, std::vector<float> &f)
            override;"""
        ret = self._wrap_call(self._vtk_obj.GetUniform1fv, *args)
        return ret

    def set_uniform1fv(self, *args):
        """
        set_uniform1fv(self, name:str, count:int, f:(float, ...)) -> None
        C++: void set_uniform1fv(const char *name, const int count,
            const float *f) override;"""
        ret = self._wrap_call(self._vtk_obj.SetUniform1fv, *args)
        return ret

    def get_uniform1iv(self, *args):
        """
        get_uniform1iv(self, name:str, f:[int, ...]) -> bool
        C++: bool get_uniform1iv(const char *name, std::vector<int> &f)
            override;
        Get the name uniform vector to f with.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform1iv, *args)
        return ret

    def set_uniform1iv(self, *args):
        """
        set_uniform1iv(self, name:str, count:int, f:(int, ...)) -> None
        C++: void set_uniform1iv(const char *name, const int count,
            const int *f) override;
        Set the name uniform array to f with count elements
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform1iv, *args)
        return ret

    def get_uniform2f(self, *args):
        """
        get_uniform2f(self, name:str, v:[float, float]) -> bool
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform2f, *args)
        return ret

    def set_uniform2f(self, *args):
        """
        set_uniform2f(self, name:str, v:(float, float)) -> None
        C++: void set_uniform2f(const char *name, const float v[2])
            override;"""
        ret = self._wrap_call(self._vtk_obj.SetUniform2f, *args)
        return ret

    def get_uniform2i(self, *args):
        """
        get_uniform2i(self, name:str, v:[int, int]) -> bool
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform2i, *args)
        return ret

    def set_uniform2i(self, *args):
        """
        set_uniform2i(self, name:str, v:(int, int)) -> None
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform2i, *args)
        return ret

    def get_uniform3f(self, *args):
        """
        get_uniform3f(self, name:str, v:[float, float, float]) -> bool
        
        Get the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted from one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform3f, *args)
        return ret

    def set_uniform3f(self, *args):
        """
        set_uniform3f(self, name:str, v:(float, float, float)) -> None
        C++: void set_uniform3f(const char *name, const double v[3])
            override;
        Set the name uniform to v. The following are convenience
        functions and do not reflect the way the data is stored and sent
        to open_gl. Data is converted to match one of the basic supported
        types
        """
        ret = self._wrap_call(self._vtk_obj.SetUniform3f, *args)
        return ret

    def get_uniform3uc(self, *args):
        """
        get_uniform3uc(self, name:str, v:[int, int, int]) -> bool
        C++: bool get_uniform3uc(const char *name, unsigned char v[3])
            override;"""
        ret = self._wrap_call(self._vtk_obj.GetUniform3uc, *args)
        return ret

    def set_uniform3uc(self, *args):
        """
        set_uniform3uc(self, name:str, v:(int, int, int)) -> None
        C++: void set_uniform3uc(const char *name,
            const unsigned char v[3]) override;"""
        ret = self._wrap_call(self._vtk_obj.SetUniform3uc, *args)
        return ret

    def get_uniform4f(self, *args):
        """
        get_uniform4f(self, name:str, v:[float, float, float, float])
            -> bool
        """
        ret = self._wrap_call(self._vtk_obj.GetUniform4f, *args)
        return ret

    def set_uniform4f(self, *args):
        """
        set_uniform4f(self, name:str, v:(float, float, float, float))
            -> None
        C++: void set_uniform4f(const char *name, const float v[4])
            override;"""
        ret = self._wrap_call(self._vtk_obj.SetUniform4f, *args)
        return ret

    def get_uniform4uc(self, *args):
        """
        get_uniform4uc(self, name:str, v:[int, int, int, int]) -> bool
        C++: bool get_uniform4uc(const char *name, unsigned char v[4])
            override;"""
        ret = self._wrap_call(self._vtk_obj.GetUniform4uc, *args)
        return ret

    def set_uniform4uc(self, *args):
        """
        set_uniform4uc(self, name:str, v:(int, int, int, int)) -> None
        C++: void set_uniform4uc(const char *name,
            const unsigned char v[4]) override;"""
        ret = self._wrap_call(self._vtk_obj.SetUniform4uc, *args)
        return ret

    def get_uniform_matrix(self, *args):
        """
        get_uniform_matrix(self, name:str, v:Matrix3x3) -> bool
        C++: bool get_uniform_matrix(const char *name, Matrix3x3 *v)
            override;
        get_uniform_matrix(self, name:str, v:Matrix4x4) -> bool
        C++: bool get_uniform_matrix(const char *name, Matrix4x4 *v)
            override;"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix, *my_args)
        return ret

    def set_uniform_matrix(self, *args):
        """
        set_uniform_matrix(self, name:str, v:Matrix3x3) -> None
        C++: void set_uniform_matrix(const char *name, Matrix3x3 *v)
            override;
        set_uniform_matrix(self, name:str, v:Matrix4x4) -> None
        C++: void set_uniform_matrix(const char *name, Matrix4x4 *v)
            override;"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix, *my_args)
        return ret

    def get_uniform_matrix3x3(self, *args):
        """
        get_uniform_matrix3x3(self, name:str, v:[float, ...]) -> bool
        C++: bool get_uniform_matrix3x3(const char *name, float *v)
            override;"""
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix3x3, *args)
        return ret

    def set_uniform_matrix3x3(self, *args):
        """
        set_uniform_matrix3x3(self, name:str, v:[float, ...]) -> None
        C++: void set_uniform_matrix3x3(const char *name, float *v)
            override;"""
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix3x3, *args)
        return ret

    def get_uniform_matrix4x4(self, *args):
        """
        get_uniform_matrix4x4(self, name:str, v:[float, ...]) -> bool
        C++: bool get_uniform_matrix4x4(const char *name, float *v)
            override;"""
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix4x4, *args)
        return ret

    def set_uniform_matrix4x4(self, *args):
        """
        set_uniform_matrix4x4(self, name:str, v:[float, ...]) -> None
        C++: void set_uniform_matrix4x4(const char *name, float *v)
            override;"""
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix4x4, *args)
        return ret

    def get_uniform_matrix4x4v(self, *args):
        """
        get_uniform_matrix4x4v(self, name:str, f:[float, ...]) -> bool
        C++: bool get_uniform_matrix4x4v(const char *name,
            std::vector<float> &f) override;"""
        ret = self._wrap_call(self._vtk_obj.GetUniformMatrix4x4v, *args)
        return ret

    def set_uniform_matrix4x4v(self, *args):
        """
        set_uniform_matrix4x4v(self, name:str, count:int, v:[float, ...])
            -> None
        C++: void set_uniform_matrix4x4v(const char *name, const int count,
            float *v) override;"""
        ret = self._wrap_call(self._vtk_obj.SetUniformMatrix4x4v, *args)
        return ret

    def get_uniformf(self, *args):
        """
        get_uniformf(self, name:str, v:float) -> bool
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformf, *args)
        return ret

    def set_uniformf(self, *args):
        """
        set_uniformf(self, name:str, v:float) -> None
        """
        ret = self._wrap_call(self._vtk_obj.SetUniformf, *args)
        return ret

    def get_uniformi(self, *args):
        """
        get_uniformi(self, name:str, v:int) -> bool
        
        Get the name uniform value. Returns true on success.
        """
        ret = self._wrap_call(self._vtk_obj.GetUniformi, *args)
        return ret

    def set_uniformi(self, *args):
        """
        set_uniformi(self, name:str, v:int) -> None
        
        Set the name uniform value to v.
        """
        ret = self._wrap_call(self._vtk_obj.SetUniformi, *args)
        return ret

    def _get_declarations(self):
        return self._vtk_obj.GetDeclarations()
    declarations = traits.Property(_get_declarations, desc=\
        r"""
        Build a string containing the GLSL declaration of all stored
        uniform variables. This is typically called by mappers to compose
        the complete shader program.
        """
    )

    def set_uniforms(self, *args):
        """
        set_uniforms(self, p:ShaderProgram) -> bool
        C++: bool set_uniforms(ShaderProgram *p)
        Set all the stored uniform variables values in the shader program
        p. This is called when the shader is bound.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetUniforms, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLUniforms, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLUniforms properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit OpenGLUniforms properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLUniforms properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

