/* argument.c generated by valac 0.28.0, the Vala compiler
 * generated from argument.vala, do not modify */

/*
 * -- Mickey's DBus Utility V2 --
 *
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *                         Frederik 'playya' Sdun <frederik.sdun@googlemail.com>
 *                         Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>


#define TYPE_ARGUMENT (argument_get_type ())
#define ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARGUMENT, Argument))
#define ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARGUMENT, ArgumentClass))
#define IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARGUMENT))
#define IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARGUMENT))
#define ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARGUMENT, ArgumentClass))

typedef struct _Argument Argument;
typedef struct _ArgumentClass ArgumentClass;
typedef struct _ArgumentPrivate ArgumentPrivate;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Argument {
	GObject parent_instance;
	ArgumentPrivate * priv;
	gchar* name;
	gchar* type;
};

struct _ArgumentClass {
	GObjectClass parent_class;
};

struct _ArgumentPrivate {
	GVariantBuilder* _vbuilder;
};


static gpointer argument_parent_class = NULL;

GType argument_get_type (void) G_GNUC_CONST;
#define ARGUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ARGUMENT, ArgumentPrivate))
enum  {
	ARGUMENT_DUMMY_PROPERTY
};
#define ARGUMENT_arg_separator ','
Argument* argument_new (const gchar* name, const gchar* type, GVariantBuilder* vbuilder);
Argument* argument_construct (GType object_type, const gchar* name, const gchar* type, GVariantBuilder* vbuilder);
gboolean argument_append (Argument* self, const gchar* arg);
static gboolean argument_append_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder);
static gchar* argument_get_sub_signature (Argument* self, const gchar* signature);
static gboolean argument_append_array_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder);
static gboolean argument_append_struct_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder);
gboolean argument_append_dict_entry_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder);
static gchar** argument_get_sub_args (Argument* self, const gchar* arg, gchar separator, int* result_length1);
static gboolean _vala_char_array_contains (gchar* stack, int stack_length, gchar needle);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void argument_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar ARGUMENT_start_chars[3] = {'{', '[', '('};
static const gchar ARGUMENT_end_chars[3] = {'}', ']', ')'};

static gpointer _g_variant_builder_ref0 (gpointer self) {
	return self ? g_variant_builder_ref (self) : NULL;
}


Argument* argument_construct (GType object_type, const gchar* name, const gchar* type, GVariantBuilder* vbuilder) {
	Argument * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GVariantBuilder* _tmp4_ = NULL;
	GVariantBuilder* _tmp5_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (vbuilder != NULL, NULL);
	self = (Argument*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = type;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->type);
	self->type = _tmp3_;
	_tmp4_ = vbuilder;
	_tmp5_ = _g_variant_builder_ref0 (_tmp4_);
	_g_variant_builder_unref0 (self->priv->_vbuilder);
	self->priv->_vbuilder = _tmp5_;
	return self;
}


Argument* argument_new (const gchar* name, const gchar* type, GVariantBuilder* vbuilder) {
	return argument_construct (TYPE_ARGUMENT, name, type, vbuilder);
}


gboolean argument_append (Argument* self, const gchar* arg) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GVariantBuilder* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	_tmp0_ = arg;
	_tmp1_ = self->type;
	_tmp2_ = self->priv->_vbuilder;
	_tmp3_ = argument_append_type (self, _tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean argument_append_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	static GQuark _tmp3_label6 = 0;
	static GQuark _tmp3_label7 = 0;
	static GQuark _tmp3_label8 = 0;
	static GQuark _tmp3_label9 = 0;
	static GQuark _tmp3_label10 = 0;
	static GQuark _tmp3_label11 = 0;
	static GQuark _tmp3_label12 = 0;
	static GQuark _tmp3_label13 = 0;
	static GQuark _tmp3_label14 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (vbuilder != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = string_substring (_tmp0_, (glong) 0, (glong) 1);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	g_free (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("v")))) {
		switch (0) {
			default:
			{
				GVariantBuilder* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				GVariant* _tmp7_ = NULL;
				GVariant* _tmp8_ = NULL;
				GVariant* _tmp9_ = NULL;
				GVariant* _tmp10_ = NULL;
				_tmp5_ = vbuilder;
				_tmp6_ = arg;
				_tmp7_ = g_variant_new_parsed (_tmp6_, NULL);
				g_variant_ref_sink (_tmp7_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_variant_new_variant (_tmp8_);
				g_variant_ref_sink (_tmp9_);
				_tmp10_ = _tmp9_;
				g_variant_builder_add_value (_tmp5_, _tmp10_);
				_g_variant_unref0 (_tmp10_);
				_g_variant_unref0 (_tmp8_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("y")))) {
		switch (0) {
			default:
			{
				guint8 value = 0U;
				const gchar* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				GVariantBuilder* _tmp13_ = NULL;
				guint8 _tmp14_ = 0U;
				GVariant* _tmp15_ = NULL;
				GVariant* _tmp16_ = NULL;
				_tmp11_ = arg;
				_tmp12_ = atoi (_tmp11_);
				value = (guint8) _tmp12_;
				_tmp13_ = vbuilder;
				_tmp14_ = value;
				_tmp15_ = g_variant_new_byte ((guchar) _tmp14_);
				g_variant_ref_sink (_tmp15_);
				_tmp16_ = _tmp15_;
				g_variant_builder_add_value (_tmp13_, _tmp16_);
				_g_variant_unref0 (_tmp16_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("b")))) {
		switch (0) {
			default:
			{
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				const gchar* _tmp19_ = NULL;
				gboolean value = FALSE;
				GVariantBuilder* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				GVariant* _tmp24_ = NULL;
				GVariant* _tmp25_ = NULL;
				_tmp19_ = arg;
				if (g_strcmp0 (_tmp19_, "true") == 0) {
					_tmp18_ = TRUE;
				} else {
					const gchar* _tmp20_ = NULL;
					_tmp20_ = arg;
					_tmp18_ = g_strcmp0 (_tmp20_, "True") == 0;
				}
				if (_tmp18_) {
					_tmp17_ = TRUE;
				} else {
					const gchar* _tmp21_ = NULL;
					_tmp21_ = arg;
					_tmp17_ = g_strcmp0 (_tmp21_, "1") == 0;
				}
				value = _tmp17_;
				_tmp22_ = vbuilder;
				_tmp23_ = value;
				_tmp24_ = g_variant_new_boolean (_tmp23_);
				g_variant_ref_sink (_tmp24_);
				_tmp25_ = _tmp24_;
				g_variant_builder_add_value (_tmp22_, _tmp25_);
				_g_variant_unref0 (_tmp25_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("n")))) {
		switch (0) {
			default:
			{
				gint16 value = 0;
				const gchar* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				GVariantBuilder* _tmp28_ = NULL;
				gint16 _tmp29_ = 0;
				GVariant* _tmp30_ = NULL;
				GVariant* _tmp31_ = NULL;
				_tmp26_ = arg;
				_tmp27_ = atoi (_tmp26_);
				value = (gint16) _tmp27_;
				_tmp28_ = vbuilder;
				_tmp29_ = value;
				_tmp30_ = g_variant_new_int16 (_tmp29_);
				g_variant_ref_sink (_tmp30_);
				_tmp31_ = _tmp30_;
				g_variant_builder_add_value (_tmp28_, _tmp31_);
				_g_variant_unref0 (_tmp31_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("i")))) {
		switch (0) {
			default:
			{
				gint32 value = 0;
				const gchar* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				GVariantBuilder* _tmp34_ = NULL;
				gint32 _tmp35_ = 0;
				GVariant* _tmp36_ = NULL;
				GVariant* _tmp37_ = NULL;
				_tmp32_ = arg;
				_tmp33_ = atoi (_tmp32_);
				value = (gint32) _tmp33_;
				_tmp34_ = vbuilder;
				_tmp35_ = value;
				_tmp36_ = g_variant_new_int32 (_tmp35_);
				g_variant_ref_sink (_tmp36_);
				_tmp37_ = _tmp36_;
				g_variant_builder_add_value (_tmp34_, _tmp37_);
				_g_variant_unref0 (_tmp37_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("q")))) {
		switch (0) {
			default:
			{
				guint16 value = 0U;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				GVariantBuilder* _tmp40_ = NULL;
				guint16 _tmp41_ = 0U;
				GVariant* _tmp42_ = NULL;
				GVariant* _tmp43_ = NULL;
				_tmp38_ = arg;
				_tmp39_ = atoi (_tmp38_);
				value = (guint16) _tmp39_;
				_tmp40_ = vbuilder;
				_tmp41_ = value;
				_tmp42_ = g_variant_new_uint16 (_tmp41_);
				g_variant_ref_sink (_tmp42_);
				_tmp43_ = _tmp42_;
				g_variant_builder_add_value (_tmp40_, _tmp43_);
				_g_variant_unref0 (_tmp43_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("u")))) {
		switch (0) {
			default:
			{
				guint32 value = 0U;
				const gchar* _tmp44_ = NULL;
				glong _tmp45_ = 0L;
				GVariantBuilder* _tmp46_ = NULL;
				guint32 _tmp47_ = 0U;
				GVariant* _tmp48_ = NULL;
				GVariant* _tmp49_ = NULL;
				_tmp44_ = arg;
				_tmp45_ = atol (_tmp44_);
				value = (guint32) _tmp45_;
				_tmp46_ = vbuilder;
				_tmp47_ = value;
				_tmp48_ = g_variant_new_uint32 (_tmp47_);
				g_variant_ref_sink (_tmp48_);
				_tmp49_ = _tmp48_;
				g_variant_builder_add_value (_tmp46_, _tmp49_);
				_g_variant_unref0 (_tmp49_);
				break;
			}
		}
	} else if ((_tmp4_ == ((0 != _tmp3_label7) ? _tmp3_label7 : (_tmp3_label7 = g_quark_from_static_string ("t")))) || (_tmp4_ == ((0 != _tmp3_label8) ? _tmp3_label8 : (_tmp3_label8 = g_quark_from_static_string ("x"))))) {
		switch (0) {
			default:
			{
				guint64 value = 0ULL;
				const gchar* _tmp50_ = NULL;
				glong _tmp51_ = 0L;
				GVariantBuilder* _tmp52_ = NULL;
				guint64 _tmp53_ = 0ULL;
				GVariant* _tmp54_ = NULL;
				GVariant* _tmp55_ = NULL;
				_tmp50_ = arg;
				_tmp51_ = atol (_tmp50_);
				value = (guint64) _tmp51_;
				_tmp52_ = vbuilder;
				_tmp53_ = value;
				_tmp54_ = g_variant_new_uint64 (_tmp53_);
				g_variant_ref_sink (_tmp54_);
				_tmp55_ = _tmp54_;
				g_variant_builder_add_value (_tmp52_, _tmp55_);
				_g_variant_unref0 (_tmp55_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label9) ? _tmp3_label9 : (_tmp3_label9 = g_quark_from_static_string ("d")))) {
		switch (0) {
			default:
			{
				gdouble value = 0.0;
				const gchar* _tmp56_ = NULL;
				gdouble _tmp57_ = 0.0;
				GVariantBuilder* _tmp58_ = NULL;
				gdouble _tmp59_ = 0.0;
				GVariant* _tmp60_ = NULL;
				GVariant* _tmp61_ = NULL;
				_tmp56_ = arg;
				_tmp57_ = double_parse (_tmp56_);
				value = _tmp57_;
				_tmp58_ = vbuilder;
				_tmp59_ = value;
				_tmp60_ = g_variant_new_double (_tmp59_);
				g_variant_ref_sink (_tmp60_);
				_tmp61_ = _tmp60_;
				g_variant_builder_add_value (_tmp58_, _tmp61_);
				_g_variant_unref0 (_tmp61_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label10) ? _tmp3_label10 : (_tmp3_label10 = g_quark_from_static_string ("s")))) {
		switch (0) {
			default:
			{
				{
					GVariant* v = NULL;
					const GVariantType* _tmp62_ = NULL;
					const gchar* _tmp63_ = NULL;
					GVariant* _tmp64_ = NULL;
					GVariantBuilder* _tmp65_ = NULL;
					GVariant* _tmp66_ = NULL;
					_tmp62_ = G_VARIANT_TYPE_STRING;
					_tmp63_ = arg;
					_tmp64_ = g_variant_parse (_tmp62_, _tmp63_, NULL, NULL, &_inner_error_);
					v = _tmp64_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch9_g_error;
					}
					_tmp65_ = vbuilder;
					_tmp66_ = v;
					g_variant_builder_add_value (_tmp65_, _tmp66_);
					_g_variant_unref0 (v);
				}
				goto __finally9;
				__catch9_g_error:
				{
					GError* e = NULL;
					GVariantBuilder* _tmp67_ = NULL;
					const gchar* _tmp68_ = NULL;
					GVariant* _tmp69_ = NULL;
					GVariant* _tmp70_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp67_ = vbuilder;
					_tmp68_ = arg;
					_tmp69_ = g_variant_new_string (_tmp68_);
					g_variant_ref_sink (_tmp69_);
					_tmp70_ = _tmp69_;
					g_variant_builder_add_value (_tmp67_, _tmp70_);
					_g_variant_unref0 (_tmp70_);
					_g_error_free0 (e);
				}
				__finally9:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label11) ? _tmp3_label11 : (_tmp3_label11 = g_quark_from_static_string ("o")))) {
		switch (0) {
			default:
			{
				GVariantBuilder* _tmp71_ = NULL;
				const gchar* _tmp72_ = NULL;
				GVariant* _tmp73_ = NULL;
				GVariant* _tmp74_ = NULL;
				_tmp71_ = vbuilder;
				_tmp72_ = arg;
				_tmp73_ = g_variant_new_object_path (_tmp72_);
				g_variant_ref_sink (_tmp73_);
				_tmp74_ = _tmp73_;
				g_variant_builder_add_value (_tmp71_, _tmp74_);
				_g_variant_unref0 (_tmp74_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label12) ? _tmp3_label12 : (_tmp3_label12 = g_quark_from_static_string ("a")))) {
		switch (0) {
			default:
			{
				gchar* subsig = NULL;
				const gchar* _tmp75_ = NULL;
				const gchar* _tmp76_ = NULL;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gchar* _tmp79_ = NULL;
				gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_ = NULL;
				const gchar* _tmp83_ = NULL;
				const gchar* _tmp84_ = NULL;
				GVariantBuilder* _tmp85_ = NULL;
				gboolean _tmp86_ = FALSE;
				_tmp75_ = type;
				_tmp76_ = type;
				_tmp77_ = strlen (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = string_substring (_tmp75_, (glong) 1, (glong) (_tmp78_ - 1));
				_tmp80_ = _tmp79_;
				_tmp81_ = argument_get_sub_signature (self, _tmp80_);
				_tmp82_ = _tmp81_;
				_g_free0 (_tmp80_);
				subsig = _tmp82_;
				_tmp83_ = arg;
				_tmp84_ = subsig;
				_tmp85_ = vbuilder;
				_tmp86_ = argument_append_array_type (self, _tmp83_, _tmp84_, _tmp85_);
				result = _tmp86_;
				_g_free0 (subsig);
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label13) ? _tmp3_label13 : (_tmp3_label13 = g_quark_from_static_string ("(")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp87_ = NULL;
				const gchar* _tmp88_ = NULL;
				GVariantBuilder* _tmp89_ = NULL;
				gboolean _tmp90_ = FALSE;
				_tmp87_ = arg;
				_tmp88_ = type;
				_tmp89_ = vbuilder;
				_tmp90_ = argument_append_struct_type (self, _tmp87_, _tmp88_, _tmp89_);
				result = _tmp90_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label14) ? _tmp3_label14 : (_tmp3_label14 = g_quark_from_static_string ("{")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp91_ = NULL;
				const gchar* _tmp92_ = NULL;
				GVariantBuilder* _tmp93_ = NULL;
				gboolean _tmp94_ = FALSE;
				_tmp91_ = arg;
				_tmp92_ = type;
				_tmp93_ = vbuilder;
				_tmp94_ = argument_append_dict_entry_type (self, _tmp91_, _tmp92_, _tmp93_);
				result = _tmp94_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				FILE* _tmp95_ = NULL;
				const gchar* _tmp96_ = NULL;
				const gchar* _tmp97_ = NULL;
				gchar* _tmp98_ = NULL;
				gchar* _tmp99_ = NULL;
				_tmp95_ = stderr;
				_tmp96_ = type;
				_tmp97_ = string_to_string (_tmp96_);
				_tmp98_ = g_strconcat ("Unsupported type ", _tmp97_, "\n", NULL);
				_tmp99_ = _tmp98_;
				fprintf (_tmp95_, "%s", _tmp99_);
				_g_free0 (_tmp99_);
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean argument_append_array_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder) {
	gboolean result = FALSE;
	GVariantBuilder* va = NULL;
	const GVariantType* _tmp0_ = NULL;
	GVariantBuilder* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	GVariantBuilder* _tmp16_ = NULL;
	GVariantBuilder* _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (vbuilder != NULL, FALSE);
	_tmp0_ = G_VARIANT_TYPE_ARRAY;
	_tmp1_ = g_variant_builder_new (_tmp0_);
	va = _tmp1_;
	_tmp2_ = arg;
	_tmp3_ = arg;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_substring (_tmp2_, (glong) 1, (glong) (_tmp5_ - 2));
	_tmp7_ = _tmp6_;
	_tmp9_ = argument_get_sub_args (self, _tmp7_, ARGUMENT_arg_separator, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	_g_free0 (_tmp7_);
	{
		gchar** sub_arg_collection = NULL;
		gint sub_arg_collection_length1 = 0;
		gint _sub_arg_collection_size_ = 0;
		gint sub_arg_it = 0;
		sub_arg_collection = _tmp10_;
		sub_arg_collection_length1 = _tmp10__length1;
		for (sub_arg_it = 0; sub_arg_it < _tmp10__length1; sub_arg_it = sub_arg_it + 1) {
			gchar* _tmp11_ = NULL;
			gchar* sub_arg = NULL;
			_tmp11_ = g_strdup (sub_arg_collection[sub_arg_it]);
			sub_arg = _tmp11_;
			{
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				GVariantBuilder* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				_tmp12_ = sub_arg;
				_tmp13_ = type;
				_tmp14_ = va;
				_tmp15_ = argument_append_type (self, _tmp12_, _tmp13_, _tmp14_);
				if (_tmp15_ == FALSE) {
					result = FALSE;
					_g_free0 (sub_arg);
					sub_arg_collection = (_vala_array_free (sub_arg_collection, sub_arg_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_variant_builder_unref0 (va);
					return result;
				}
				_g_free0 (sub_arg);
			}
		}
		sub_arg_collection = (_vala_array_free (sub_arg_collection, sub_arg_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp16_ = vbuilder;
	_tmp17_ = va;
	_tmp18_ = g_variant_builder_end (_tmp17_);
	g_variant_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	g_variant_builder_add_value (_tmp16_, _tmp19_);
	_g_variant_unref0 (_tmp19_);
	result = TRUE;
	_g_variant_builder_unref0 (va);
	return result;
}


static gboolean argument_append_struct_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder) {
	gboolean result = FALSE;
	gint sigpos = 0;
	gchar* subtype = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar** _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (vbuilder != NULL, FALSE);
	sigpos = 0;
	_tmp0_ = type;
	_tmp1_ = type;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_substring (_tmp0_, (glong) 1, (glong) (_tmp3_ - 2));
	subtype = _tmp4_;
	_tmp5_ = arg;
	_tmp6_ = arg;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = string_substring (_tmp5_, (glong) 1, (glong) (_tmp8_ - 2));
	_tmp10_ = _tmp9_;
	_tmp12_ = argument_get_sub_args (self, _tmp10_, ARGUMENT_arg_separator, &_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp11_;
	_g_free0 (_tmp10_);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp13_;
		s_collection_length1 = _tmp13__length1;
		for (s_it = 0; s_it < _tmp13__length1; s_it = s_it + 1) {
			gchar* _tmp14_ = NULL;
			gchar* s = NULL;
			_tmp14_ = g_strdup (s_collection[s_it]);
			s = _tmp14_;
			{
				gchar* sig = NULL;
				const gchar* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				const gchar* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				const gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				GVariantBuilder* _tmp27_ = NULL;
				gboolean _tmp28_ = FALSE;
				_tmp15_ = subtype;
				_tmp16_ = sigpos;
				_tmp17_ = string_substring (_tmp15_, (glong) _tmp16_, (glong) (-1));
				_tmp18_ = _tmp17_;
				_tmp19_ = argument_get_sub_signature (self, _tmp18_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				sig = _tmp20_;
				_tmp21_ = sigpos;
				_tmp22_ = sig;
				_tmp23_ = strlen (_tmp22_);
				_tmp24_ = _tmp23_;
				sigpos = _tmp21_ + ((gint) _tmp24_);
				_tmp25_ = s;
				_tmp26_ = sig;
				_tmp27_ = vbuilder;
				_tmp28_ = argument_append_type (self, _tmp25_, _tmp26_, _tmp27_);
				if (_tmp28_ == FALSE) {
					result = FALSE;
					_g_free0 (sig);
					_g_free0 (s);
					s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (subtype);
					return result;
				}
				_g_free0 (sig);
				_g_free0 (s);
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = TRUE;
	_g_free0 (subtype);
	return result;
}


gboolean argument_append_dict_entry_type (Argument* self, const gchar* arg, const gchar* type, GVariantBuilder* vbuilder) {
	gboolean result = FALSE;
	gchar* subtype = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* keytype = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* valuetype = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	gchar** values = NULL;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gchar* key = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* value = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GVariantBuilder* vde = NULL;
	const GVariantType* _tmp21_ = NULL;
	GVariantBuilder* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GVariantBuilder* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GVariantBuilder* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	GVariantBuilder* _tmp31_ = NULL;
	GVariantBuilder* _tmp32_ = NULL;
	GVariant* _tmp33_ = NULL;
	GVariant* _tmp34_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	g_return_val_if_fail (vbuilder != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = type;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_substring (_tmp0_, (glong) 1, (glong) (_tmp3_ - 2));
	subtype = _tmp4_;
	_tmp5_ = subtype;
	_tmp6_ = argument_get_sub_signature (self, _tmp5_);
	keytype = _tmp6_;
	_tmp7_ = subtype;
	_tmp8_ = keytype;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_substring (_tmp7_, (glong) _tmp10_, (glong) (-1));
	valuetype = _tmp11_;
	_tmp12_ = arg;
	_tmp14_ = argument_get_sub_args (self, _tmp12_, ':', &_tmp13_);
	values = _tmp14_;
	values_length1 = _tmp13_;
	_values_size_ = values_length1;
	_tmp15_ = values;
	_tmp15__length1 = values_length1;
	_tmp16_ = _tmp15_[0];
	_tmp17_ = g_strdup (_tmp16_);
	key = _tmp17_;
	_tmp18_ = values;
	_tmp18__length1 = values_length1;
	_tmp19_ = _tmp18_[1];
	_tmp20_ = g_strdup (_tmp19_);
	value = _tmp20_;
	_tmp21_ = G_VARIANT_TYPE_DICT_ENTRY;
	_tmp22_ = g_variant_builder_new (_tmp21_);
	vde = _tmp22_;
	_tmp23_ = key;
	_tmp24_ = keytype;
	_tmp25_ = vde;
	_tmp26_ = argument_append_type (self, _tmp23_, _tmp24_, _tmp25_);
	if (_tmp26_ == FALSE) {
		result = FALSE;
		_g_variant_builder_unref0 (vde);
		_g_free0 (value);
		_g_free0 (key);
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (valuetype);
		_g_free0 (keytype);
		_g_free0 (subtype);
		return result;
	}
	_tmp27_ = value;
	_tmp28_ = valuetype;
	_tmp29_ = vde;
	_tmp30_ = argument_append_type (self, _tmp27_, _tmp28_, _tmp29_);
	if (_tmp30_ == FALSE) {
		result = FALSE;
		_g_variant_builder_unref0 (vde);
		_g_free0 (value);
		_g_free0 (key);
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (valuetype);
		_g_free0 (keytype);
		_g_free0 (subtype);
		return result;
	}
	_tmp31_ = vbuilder;
	_tmp32_ = vde;
	_tmp33_ = g_variant_builder_end (_tmp32_);
	g_variant_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	g_variant_builder_add_value (_tmp31_, _tmp34_);
	_g_variant_unref0 (_tmp34_);
	result = TRUE;
	_g_variant_builder_unref0 (vde);
	_g_free0 (value);
	_g_free0 (key);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (valuetype);
	_g_free0 (keytype);
	_g_free0 (subtype);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean _vala_char_array_contains (gchar* stack, int stack_length, gchar needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gchar* argument_get_sub_signature (Argument* self, const gchar* signature) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	gint depth = 0;
	gint _tmp26_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_result_ = _tmp0_;
	depth = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gchar c = '\0';
				const gchar* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gchar _tmp9_ = '\0';
				gchar _tmp10_ = '\0';
				const gchar* _tmp20_ = NULL;
				gchar _tmp21_ = '\0';
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = signature;
				_tmp5_ = strlen (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = signature;
				_tmp8_ = i;
				_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
				c = (gchar) _tmp9_;
				_tmp10_ = c;
				if (_tmp10_ == 'a') {
					const gchar* _tmp11_ = NULL;
					gchar _tmp12_ = '\0';
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					_tmp11_ = _result_;
					_tmp12_ = c;
					_tmp13_ = g_strdup_printf ("%c", _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
					_g_free0 (_result_);
					_result_ = _tmp15_;
					_g_free0 (_tmp14_);
					continue;
				} else {
					gchar _tmp16_ = '\0';
					_tmp16_ = c;
					if (_vala_char_array_contains (ARGUMENT_start_chars, G_N_ELEMENTS (ARGUMENT_start_chars), _tmp16_)) {
						gint _tmp17_ = 0;
						_tmp17_ = depth;
						depth = _tmp17_ + 1;
					} else {
						gchar _tmp18_ = '\0';
						_tmp18_ = c;
						if (_vala_char_array_contains (ARGUMENT_end_chars, G_N_ELEMENTS (ARGUMENT_end_chars), _tmp18_)) {
							gint _tmp19_ = 0;
							_tmp19_ = depth;
							depth = _tmp19_ - 1;
						}
					}
				}
				_tmp20_ = _result_;
				_tmp21_ = c;
				_tmp22_ = g_strdup_printf ("%c", _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat (_tmp20_, _tmp23_, NULL);
				_g_free0 (_result_);
				_result_ = _tmp24_;
				_g_free0 (_tmp23_);
				_tmp25_ = depth;
				if (_tmp25_ == 0) {
					break;
				}
			}
		}
	}
	_tmp26_ = depth;
	_vala_assert (_tmp26_ == 0, "depth == 0");
	result = _result_;
	return result;
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** argument_get_sub_args (Argument* self, const gchar* arg, gchar separator, int* result_length1) {
	gchar** result = NULL;
	gchar** _result_ = NULL;
	gchar** _tmp0_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gchar* part = NULL;
	gchar* _tmp1_ = NULL;
	gint depth = 0;
	gint _tmp31_ = 0;
	const gchar* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gchar** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (arg != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = g_strdup ("");
	part = _tmp1_;
	depth = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				const gchar* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gchar c = '\0';
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gchar _tmp10_ = '\0';
				gchar _tmp11_ = '\0';
				const gchar* _tmp15_ = NULL;
				gchar _tmp16_ = '\0';
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				gint _tmp21_ = 0;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = arg;
				_tmp6_ = strlen (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = arg;
				_tmp9_ = i;
				_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
				c = (gchar) _tmp10_;
				_tmp11_ = c;
				if (_vala_char_array_contains (ARGUMENT_start_chars, G_N_ELEMENTS (ARGUMENT_start_chars), _tmp11_)) {
					gint _tmp12_ = 0;
					_tmp12_ = depth;
					depth = _tmp12_ + 1;
				} else {
					gchar _tmp13_ = '\0';
					_tmp13_ = c;
					if (_vala_char_array_contains (ARGUMENT_end_chars, G_N_ELEMENTS (ARGUMENT_end_chars), _tmp13_)) {
						gint _tmp14_ = 0;
						_tmp14_ = depth;
						depth = _tmp14_ - 1;
					}
				}
				_tmp15_ = part;
				_tmp16_ = c;
				_tmp17_ = g_strdup_printf ("%c", _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
				_g_free0 (part);
				part = _tmp19_;
				_g_free0 (_tmp18_);
				_tmp21_ = depth;
				if (_tmp21_ == 0) {
					gchar _tmp22_ = '\0';
					gchar _tmp23_ = '\0';
					_tmp22_ = c;
					_tmp23_ = separator;
					_tmp20_ = _tmp22_ == _tmp23_;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					gchar** _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					const gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					_tmp24_ = _result_;
					_tmp24__length1 = _result__length1;
					_tmp25_ = part;
					_tmp26_ = part;
					_tmp27_ = strlen (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = string_substring (_tmp25_, (glong) 0, (glong) (_tmp28_ - 1));
					_vala_array_add8 (&_result_, &_result__length1, &__result__size_, _tmp29_);
					_tmp30_ = g_strdup ("");
					_g_free0 (part);
					part = _tmp30_;
				}
			}
		}
	}
	_tmp31_ = depth;
	_vala_assert (_tmp31_ == 0, "depth == 0");
	_tmp32_ = part;
	_tmp33_ = strlen (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != 0) {
		gchar** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		_tmp35_ = _result_;
		_tmp35__length1 = _result__length1;
		_tmp36_ = part;
		_tmp37_ = g_strdup (_tmp36_);
		_vala_array_add9 (&_result_, &_result__length1, &__result__size_, _tmp37_);
	}
	_tmp38_ = _result_;
	_tmp38__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp38__length1;
	}
	result = _tmp38_;
	_g_free0 (part);
	return result;
}


static void argument_class_init (ArgumentClass * klass) {
	argument_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ArgumentPrivate));
	G_OBJECT_CLASS (klass)->finalize = argument_finalize;
}


static void argument_instance_init (Argument * self) {
	self->priv = ARGUMENT_GET_PRIVATE (self);
}


static void argument_finalize (GObject* obj) {
	Argument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ARGUMENT, Argument);
	_g_variant_builder_unref0 (self->priv->_vbuilder);
	_g_free0 (self->name);
	_g_free0 (self->type);
	G_OBJECT_CLASS (argument_parent_class)->finalize (obj);
}


GType argument_get_type (void) {
	static volatile gsize argument_type_id__volatile = 0;
	if (g_once_init_enter (&argument_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Argument), 0, (GInstanceInitFunc) argument_instance_init, NULL };
		GType argument_type_id;
		argument_type_id = g_type_register_static (G_TYPE_OBJECT, "Argument", &g_define_type_info, 0);
		g_once_init_leave (&argument_type_id__volatile, argument_type_id);
	}
	return argument_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



