# Check for Google Tests
#
# These lines for google test are from Unity's CMakeList.txt:
# http://bazaar.launchpad.net/~unity-team/unity/trunk/view/head:/CMakeLists.txt
#
# It seems to be a way to use the gtest source code directly, instead of
# via a library. This is possible because gtest has a CMakeList.txt too.

MACRO(FIND_GOOGLE_TESTS)
  SET(GTEST_ROOT_DIR "/usr/src/gtest"
      CACHE PATH "Path to Google Tests sources")

  MESSAGE(STATUS "Checking for Google Tests at \"${GTEST_ROOT_DIR}\"")

  IF(NOT EXISTS ${GTEST_ROOT_DIR}/CMakeLists.txt)
    MESSAGE(FATAL_ERROR "Cannot find Google Tests in \"${GTEST_ROOT_DIR}\". "
                        "Please install Google Tests and set the "
                        "GTEST_ROOT_DIR option accordingly")
  ENDIF(NOT EXISTS ${GTEST_ROOT_DIR}/CMakeLists.txt)

  FIND_PATH(GTEST_INCLUDE_DIR gtest/gtest.h)

  IF(NOT GTEST_INCLUDE_DIR)
    MESSAGE(FATAL_ERROR "Cannot find Google Tests headers. "
                        "Please install Google Tests and set the "
                        "GTEST_INCLUDE_DIR option accordingly")
  ENDIF(NOT GTEST_INCLUDE_DIR)
ENDMACRO(FIND_GOOGLE_TESTS)
