/*
 * (C) Copyright 1996- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation
 * nor does it submit to any jurisdiction.
 */

/// @file   LinearAlgebraEigen.h
/// @author Florian Rathgeber
/// @date   June 2015

#ifndef eckit_la_LinearAlgebraEigen_h
#define eckit_la_LinearAlgebraEigen_h

#include "eckit/eckit.h"

#ifdef eckit_HAVE_EIGEN

#include "eckit/linalg/LinearAlgebra.h"

namespace eckit {
namespace linalg {

//-----------------------------------------------------------------------------

class LinearAlgebraEigen : public LinearAlgebra {

public:
    LinearAlgebraEigen();

private:
    // Overridden methods

    virtual Scalar dot(const Vector&, const Vector&) const override;
    virtual void gemv(const Matrix&, const Vector&, Vector&) const override;
    virtual void gemm(const Matrix&, const Matrix&, Matrix&) const override;
    virtual void spmv(const SparseMatrix&, const Vector&, Vector&) const override;
    virtual void spmm(const SparseMatrix&, const Matrix&, Matrix&) const override;
    virtual void dsptd(const Vector&, const SparseMatrix&, const Vector&, SparseMatrix&) const override;

    virtual void print(std::ostream&) const override;
};

//-----------------------------------------------------------------------------

}  // namespace linalg
}  // namespace eckit

#endif  // eckit_HAVE_EIGEN

#endif
