# Contributing

Material for MkDocs is an actively maintained and constantly improved project
that serves a diverse user base with varying backgrounds and needs. In order to
effectively address the needs of all our users, evaluate change requests, and
fix bugs, we maintainers need to put in a lot of work. We have devoted
significant effort to creating better templates for our issue tracker,
optimizing the processes for our users to report bugs, request features or
changes, contribute to the project, or exchange with our community.

Given the wealth of valuable knowledge contained in numerous issues and
discussions, we consider our [issue tracker] and [discussion board] to serve as
a crucial __knowledge base__ that is an important addition to our [documentation]
and brings value to both new and experienced users of Material for MkDocs.

  [discussion board]: https://github.com/squidfunk/mkdocs-material/discussions
  [issue tracker]: https://github.com/squidfunk/mkdocs-material/issues
  [documentation]: https://squidfunk.github.io/mkdocs-material/

## How to contribute

### Creating an issue

-   #### [Report a bug]

    __Something is not working?__ Report a bug in Material for MkDocs by
    creating an issue with a reproduction

-   #### [Report a docs issue]

    __Missing information in our docs?__ Report missing information or
    potential inconsistencies in our documentation

-   #### [Request a change]

    __Want to submit an idea?__ Propose a change, feature request, or
    suggest an improvement

-   #### [Ask a question]

    __Have a question or need help?__ Ask a question on our [discussion board]
    and get in touch with our community

### Contributing

-   #### [Add a translation]

    __Missing support for your language?__ Add missing translations for a new
    or already supported language

-   #### [Create a pull request]

    __Want to create a pull request?__ Learn how to create a comprehensive
    and useful pull request (PR)s

  [Report a bug]: docs/contributing/reporting-a-bug.md
  [Report a docs issue]: docs/contributing/reporting-a-docs-issue.md
  [Request a change]: docs/contributing/requesting-a-change.md
  [Ask a question]: https://github.com/squidfunk/mkdocs-material/discussions
  [Add a translation]: docs/contributing/adding-translations
  [Create a pull request]: docs/contributing/making-a-pull-request.md
  
