"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Thule"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Thule", { offset: true, expect: "America/Halifax" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Thule", { abbr: true, expect: "America/Halifax" }),

	"1916" : helpers.makeTestYear("America/Thule", [
		["1916-07-28T04:35:07+00:00", "23:59:59", "LMT", 16508 / 60],
		["1916-07-28T04:35:08+00:00", "00:35:08", "AST", 240]
	]),

	"1991" : helpers.makeTestYear("America/Thule", [
		["1991-03-31T05:59:59+00:00", "01:59:59", "AST", 240],
		["1991-03-31T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1991-09-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1991-09-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1992" : helpers.makeTestYear("America/Thule", [
		["1992-03-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1992-03-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1992-09-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1992-09-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1993" : helpers.makeTestYear("America/Thule", [
		["1993-04-04T05:59:59+00:00", "01:59:59", "AST", 240],
		["1993-04-04T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1993-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1993-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1994" : helpers.makeTestYear("America/Thule", [
		["1994-04-03T05:59:59+00:00", "01:59:59", "AST", 240],
		["1994-04-03T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1994-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1994-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1995" : helpers.makeTestYear("America/Thule", [
		["1995-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["1995-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1995-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1995-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1996" : helpers.makeTestYear("America/Thule", [
		["1996-04-07T05:59:59+00:00", "01:59:59", "AST", 240],
		["1996-04-07T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1996-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1996-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1997" : helpers.makeTestYear("America/Thule", [
		["1997-04-06T05:59:59+00:00", "01:59:59", "AST", 240],
		["1997-04-06T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1997-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1997-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1998" : helpers.makeTestYear("America/Thule", [
		["1998-04-05T05:59:59+00:00", "01:59:59", "AST", 240],
		["1998-04-05T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1998-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1998-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1999" : helpers.makeTestYear("America/Thule", [
		["1999-04-04T05:59:59+00:00", "01:59:59", "AST", 240],
		["1999-04-04T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1999-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1999-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2000" : helpers.makeTestYear("America/Thule", [
		["2000-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["2000-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2000-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2000-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2001" : helpers.makeTestYear("America/Thule", [
		["2001-04-01T05:59:59+00:00", "01:59:59", "AST", 240],
		["2001-04-01T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2001-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2001-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2002" : helpers.makeTestYear("America/Thule", [
		["2002-04-07T05:59:59+00:00", "01:59:59", "AST", 240],
		["2002-04-07T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2002-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2002-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2003" : helpers.makeTestYear("America/Thule", [
		["2003-04-06T05:59:59+00:00", "01:59:59", "AST", 240],
		["2003-04-06T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2003-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2003-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2004" : helpers.makeTestYear("America/Thule", [
		["2004-04-04T05:59:59+00:00", "01:59:59", "AST", 240],
		["2004-04-04T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2004-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2004-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2005" : helpers.makeTestYear("America/Thule", [
		["2005-04-03T05:59:59+00:00", "01:59:59", "AST", 240],
		["2005-04-03T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2005-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2005-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2006" : helpers.makeTestYear("America/Thule", [
		["2006-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["2006-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2006-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2006-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2007" : helpers.makeTestYear("America/Thule", [
		["2007-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2007-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2007-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2007-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2008" : helpers.makeTestYear("America/Thule", [
		["2008-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2008-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2008-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2008-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2009" : helpers.makeTestYear("America/Thule", [
		["2009-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2009-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2009-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2009-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2010" : helpers.makeTestYear("America/Thule", [
		["2010-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2010-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2010-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2010-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2011" : helpers.makeTestYear("America/Thule", [
		["2011-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2011-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2011-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2011-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2012" : helpers.makeTestYear("America/Thule", [
		["2012-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2012-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2012-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2012-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2013" : helpers.makeTestYear("America/Thule", [
		["2013-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2013-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2013-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2013-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2014" : helpers.makeTestYear("America/Thule", [
		["2014-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2014-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2014-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2014-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2015" : helpers.makeTestYear("America/Thule", [
		["2015-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2015-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2015-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2015-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2016" : helpers.makeTestYear("America/Thule", [
		["2016-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2016-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2016-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2016-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2017" : helpers.makeTestYear("America/Thule", [
		["2017-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2017-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2017-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2017-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2018" : helpers.makeTestYear("America/Thule", [
		["2018-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2018-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2018-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2018-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2019" : helpers.makeTestYear("America/Thule", [
		["2019-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2019-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2019-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2019-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2020" : helpers.makeTestYear("America/Thule", [
		["2020-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2020-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2020-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2020-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2021" : helpers.makeTestYear("America/Thule", [
		["2021-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2021-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2021-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2021-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2022" : helpers.makeTestYear("America/Thule", [
		["2022-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2022-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2022-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2022-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2023" : helpers.makeTestYear("America/Thule", [
		["2023-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2023-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2023-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2023-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2024" : helpers.makeTestYear("America/Thule", [
		["2024-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2024-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2024-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2024-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2025" : helpers.makeTestYear("America/Thule", [
		["2025-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2025-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2025-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2025-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2026" : helpers.makeTestYear("America/Thule", [
		["2026-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2026-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2026-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2026-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2027" : helpers.makeTestYear("America/Thule", [
		["2027-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2027-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2027-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2027-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2028" : helpers.makeTestYear("America/Thule", [
		["2028-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2028-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2028-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2028-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2029" : helpers.makeTestYear("America/Thule", [
		["2029-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2029-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2029-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2029-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2030" : helpers.makeTestYear("America/Thule", [
		["2030-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2030-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2030-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2030-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2031" : helpers.makeTestYear("America/Thule", [
		["2031-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2031-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2031-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2031-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2032" : helpers.makeTestYear("America/Thule", [
		["2032-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2032-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2032-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2032-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2033" : helpers.makeTestYear("America/Thule", [
		["2033-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2033-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2033-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2033-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2034" : helpers.makeTestYear("America/Thule", [
		["2034-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2034-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2034-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2034-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2035" : helpers.makeTestYear("America/Thule", [
		["2035-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2035-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2035-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2035-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2036" : helpers.makeTestYear("America/Thule", [
		["2036-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2036-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2036-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2036-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2037" : helpers.makeTestYear("America/Thule", [
		["2037-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2037-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2037-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2037-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	])
};