//
// ccsdpr12_t1.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modifd2
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//
  
// This is a C++ code generated by SMITH
  
#include <algorithm>
#include <chemistry/qc/ccr12/ccsdpr12_t1.h>
#include <chemistry/qc/ccr12/tensor.h>
using namespace sc;
  
  
CCSDPR12_T1::CCSDPR12_T1(CCR12_Info* info):z(info){};
CCSDPR12_T1::~CCSDPR12_T1(){};
  
  
  
void CCSDPR12_T1::compute_amp(Ref<Tensor>& out){ //k_i0_offset,z->gt2(),z->f1(),z->in.at(0),z->qy(),z->t1(),z->t2(),z->v2()=>z->vr2()
  
in.resize(8);
  
in.at(1)=new Tensor("ccsdpr12_t1_1_0",z->mem());
offset_smith_0_1();
smith_0_1_0(); //z->f1()=>in.at(1)
smith_1_4(); //z->t1(),z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdpr12_t1_2_10",z->mem());
offset_smith_1_10();
smith_2_10(); //z->t1(),z->v2()=>in.at(2)
smith_1_10(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_13(); //z->t2(),z->v2()=>in.at(1)
smith_1_16(); //z->gt2(),z->vr2()=>in.at(1)
smith_0_1(out); //z->t1(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdpr12_t1_1_1",z->mem());
offset_smith_0_2();
smith_0_2_0(); //z->f1()=>in.at(1)
smith_1_5(); //z->t1(),z->v2()=>in.at(1)
smith_0_2(out); //z->t1(),in.at(1)=>out
delete in.at(1);
smith_0_3(out); //z->t1(),z->v2()=>out
in.at(1)=new Tensor("ccsdpr12_t1_1_2",z->mem());
offset_smith_0_6();
smith_0_6_0(); //z->v2()=>in.at(1)
smith_1_12(); //z->t1(),z->v2()=>in.at(1)
smith_0_6(out); //z->t2(),in.at(1)=>out
delete in.at(1);
smith_0_7(out); //z->t2(),z->v2()=>out
in.at(1)=new Tensor("ccsdpr12_t1_1_3",z->mem());
offset_smith_0_8();
smith_0_8_0(); //z->v2()=>in.at(1)
smith_1_15(); //z->t1(),z->v2()=>in.at(1)
smith_0_8(out); //z->qy(),in.at(1)=>out
delete in.at(1);
smith_0_9(out); //z->gt2(),z->vr2()=>out
in.at(1)=new Tensor("ccsdpr12_t1_1_11",z->mem());
offset_smith_0_11();
smith_1_11(); //z->t1(),z->v2()=>in.at(1)
smith_0_11(out); //z->t2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdpr12_t1_1_14",z->mem());
offset_smith_0_14();
smith_1_14(); //z->t1(),z->v2()=>in.at(1)
smith_0_14(out); //z->qy(),in.at(1)=>out
delete in.at(1);
  
}
  
void CCSDPR12_T1::smith_0_1(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(p2b-z->noab())); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(h1b)) { 
     if ((z->get_sym(p2b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_f())) { 
      long dimc=z->get_range(p2b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       if (z->get_spin(p2b)==z->get_spin(h3b)) { 
        if ((z->get_sym(p2b)^z->get_sym(h3b))==z->irrep_t()) { 
         long p2b_0,h3b_0; 
         z->restricted_2(p2b,h3b,p2b_0,h3b_0); 
         long h3b_1,h1b_1; 
         z->restricted_2(h3b,h1b,h3b_1,h1b_1); 
         long dim_common=z->get_range(h3b); 
         long dima0_sort=z->get_range(p2b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h1b); 
         long dima1=dim_common*dima1_sort; 
         z->t1()->get_block(h3b_0+z->noab()*(p2b_0-z->noab()),k_a0); 
         z->sort_indices2(k_a0,k_a0_sort,z->get_range(p2b),z->get_range(h3b),0,1,+1.0); 
         in[1]->get_block(h1b_1+z->noab()*(h3b_1),k_a1); 
         z->sort_indices2(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h1b),1,0,+1.0); 
         double factor=1.0; 
         z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h1b),z->get_range(p2b),1,0,+1.0); 
      out->add_block(h1b+z->noab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_11(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(p2b-z->noab())); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(h1b)) { 
     if ((z->get_sym(p2b)^z->get_sym(h1b))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
      long dimc=z->get_range(p2b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h4b=0L;h4b<z->noab();++h4b) { 
       for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
        if (z->get_spin(p2b)+z->get_spin(p3b)==z->get_spin(h1b)+z->get_spin(h4b)) { 
         if ((z->get_sym(p2b)^(z->get_sym(p3b)^(z->get_sym(h1b)^z->get_sym(h4b))))==z->irrep_t()) { 
          long p2b_0,p3b_0,h1b_0,h4b_0; 
          z->restricted_4(p2b,p3b,h1b,h4b,p2b_0,p3b_0,h1b_0,h4b_0); 
          long h4b_1,p3b_1; 
          z->restricted_2(h4b,p3b,h4b_1,p3b_1); 
          long dim_common=z->get_range(h4b)*z->get_range(p3b); 
          long dima0_sort=z->get_range(p2b)*z->get_range(h1b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=1L; 
          long dima1=dim_common*dima1_sort; 
          if (p2b<p3b && h1b<h4b) { 
           z->t2()->get_block(h4b_0+z->noab()*(h1b_0+z->noab()*(p3b_0-z->noab()+z->nvab()*(p2b_0-z->noab()))),k_a0); 
           z->sort_indices4(k_a0,k_a0_sort,z->get_range(p2b),z->get_range(p3b),z->get_range(h1b),z->get_range(h4b),2,0,1,3,+1.0); 
          } 
          else if (p2b<p3b && h4b<=h1b) { 
           z->t2()->get_block(h1b_0+z->noab()*(h4b_0+z->noab()*(p3b_0-z->noab()+z->nvab()*(p2b_0-z->noab()))),k_a0); 
           z->sort_indices4(k_a0,k_a0_sort,z->get_range(p2b),z->get_range(p3b),z->get_range(h4b),z->get_range(h1b),3,0,1,2,-1.0); 
          } 
          else if (p3b<=p2b && h1b<h4b) { 
           z->t2()->get_block(h4b_0+z->noab()*(h1b_0+z->noab()*(p2b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
           z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p2b),z->get_range(h1b),z->get_range(h4b),2,1,0,3,-1.0); 
          } 
          else if (p3b<=p2b && h4b<=h1b) { 
           z->t2()->get_block(h1b_0+z->noab()*(h4b_0+z->noab()*(p2b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
           z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p2b),z->get_range(h4b),z->get_range(h1b),3,1,0,2,+1.0); 
          } 
          in[1]->get_block(p3b_1-z->noab()+z->nvab()*(h4b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p3b),1,0,+1.0); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h1b),z->get_range(p2b),1,0,+1.0); 
      out->add_block(h1b+z->noab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::offset_smith_0_11(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  if (z->get_spin(h4b)==z->get_spin(p3b)) { 
   if ((z->get_sym(h4b)^z->get_sym(p3b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p3b)!=4L) { 
     in[1]->input_offset(p3b-z->noab()+z->nvab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(p3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_14(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(p2b-z->noab())); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(h1b)) { 
     if ((z->get_sym(p2b)^z->get_sym(h1b))==(z->irrep_e()^(z->irrep_t()^z->irrep_v()))) { 
      long dimc=z->get_range(p2b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h4b=0L;h4b<z->noab();++h4b) { 
       for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
        if (z->get_spin(p2b)+z->get_spin(q3b)==z->get_spin(h1b)+z->get_spin(h4b)) { 
         if ((z->get_sym(p2b)^(z->get_sym(q3b)^(z->get_sym(h1b)^z->get_sym(h4b))))==z->irrep_e()) { 
          long p2b_0,q3b_0,h1b_0,h4b_0; 
          z->restricted_4(p2b,q3b,h1b,h4b,p2b_0,q3b_0,h1b_0,h4b_0); 
          long h4b_1,q3b_1; 
          z->restricted_2(h4b,q3b,h4b_1,q3b_1); 
          long dim_common=z->get_range(h4b)*z->get_range(q3b); 
          long dima0_sort=z->get_range(p2b)*z->get_range(h1b); 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=1L; 
          long dima1=dim_common*dima1_sort; 
          if (h1b<h4b) { 
           z->qy()->get_block(h4b_0+z->noab()*(h1b_0+z->noab()*(q3b_0-z->noab()-z->nvab()+z->ncab()*(p2b_0-z->noab()))),k_a0); 
           z->sort_indices4(k_a0,k_a0_sort,z->get_range(p2b),z->get_range(q3b),z->get_range(h1b),z->get_range(h4b),2,0,1,3,+1.0); 
          } 
          else if (h4b<=h1b) { 
           z->qy()->get_block(h1b_0+z->noab()*(h4b_0+z->noab()*(q3b_0-z->noab()-z->nvab()+z->ncab()*(p2b_0-z->noab()))),k_a0); 
           z->sort_indices4(k_a0,k_a0_sort,z->get_range(p2b),z->get_range(q3b),z->get_range(h4b),z->get_range(h1b),3,0,1,2,-1.0); 
          } 
          in[1]->get_block(q3b_1-z->noab()-z->nvab()+z->ncab()*(h4b_1),k_a1); 
          z->sort_indices2(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(q3b),1,0,+1.0); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h1b),z->get_range(p2b),1,0,+1.0); 
      out->add_block(h1b+z->noab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::offset_smith_0_14(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
  if (z->get_spin(h4b)==z->get_spin(q3b)) { 
   if ((z->get_sym(h4b)^z->get_sym(q3b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h4b)+z->get_spin(q3b)!=4L) { 
     in[1]->input_offset(q3b-z->noab()-z->nvab()+z->ncab()*(h4b),size); 
     size+=z->get_range(h4b)*z->get_range(q3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_1_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(h3b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(h3b)==z->get_spin(h1b)) { 
     if ((z->get_sym(h3b)^z->get_sym(h1b))==z->irrep_f()) { 
      long dimc=z->get_range(h3b)*z->get_range(h1b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h3b_0,h1b_0; 
      z->restricted_2(h3b,h1b,h3b_0,h1b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h3b)*z->get_range(h1b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(h1b_0+(z->nab())*(h3b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h1b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h3b),z->get_range(h1b),0,1,-1.0); 
      in[1]->add_block(h1b+z->noab()*(h3b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::offset_smith_0_1(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  if (z->get_spin(h3b)==z->get_spin(h1b)) { 
   if ((z->get_sym(h3b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h1b)!=4L) { 
     in[1]->input_offset(h1b+z->noab()*(h3b),size); 
     size+=z->get_range(h3b)*z->get_range(h1b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_2(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(p2b-z->noab())); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(h1b)) { 
     if ((z->get_sym(p2b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_f())) { 
      long dimc=z->get_range(p2b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
       if (z->get_spin(p3b)==z->get_spin(h1b)) { 
        if ((z->get_sym(p3b)^z->get_sym(h1b))==z->irrep_t()) { 
         long p3b_0,h1b_0; 
         z->restricted_2(p3b,h1b,p3b_0,h1b_0); 
         long p2b_1,p3b_1; 
         z->restricted_2(p2b,p3b,p2b_1,p3b_1); 
         long dim_common=z->get_range(p3b); 
         long dima0_sort=z->get_range(h1b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(p2b); 
         long dima1=dim_common*dima1_sort; 
         z->t1()->get_block(h1b_0+z->noab()*(p3b_0-z->noab()),k_a0); 
         z->sort_indices2(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(h1b),1,0,+1.0); 
         in[1]->get_block(p3b_1-z->noab()+z->nvab()*(p2b_1-z->noab()),k_a1); 
         z->sort_indices2(k_a1,k_a1_sort,z->get_range(p2b),z->get_range(p3b),0,1,+1.0); 
         double factor=1.0; 
         z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(h1b),0,1,+1.0); 
      out->add_block(h1b+z->noab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_2_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  long tileoffset; 
  tileoffset=(p3b-z->noab()+z->nvab()*(p2b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(p3b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(p3b)) { 
     if ((z->get_sym(p2b)^z->get_sym(p3b))==z->irrep_f()) { 
      long dimc=z->get_range(p2b)*z->get_range(p3b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long p2b_0,p3b_0; 
      z->restricted_2(p2b,p3b,p2b_0,p3b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(p2b)*z->get_range(p3b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p3b_0+(z->nab())*(p2b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(p2b),z->get_range(p3b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(p2b),z->get_range(p3b),0,1,+1.0); 
      in[1]->add_block(p3b-z->noab()+z->nvab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::offset_smith_0_2(){ 
 
long size=0L; 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  if (z->get_spin(p2b)==z->get_spin(p3b)) { 
   if ((z->get_sym(p2b)^z->get_sym(p3b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(p2b)+z->get_spin(p3b)!=4L) { 
     in[1]->input_offset(p3b-z->noab()+z->nvab()*(p2b-z->noab()),size); 
     size+=z->get_range(p2b)*z->get_range(p3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_3(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(p2b-z->noab())); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(h1b)) { 
     if ((z->get_sym(p2b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p2b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h4b=0L;h4b<z->noab();++h4b) { 
       for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
        if (z->get_spin(p3b)==z->get_spin(h4b)) { 
         if ((z->get_sym(p3b)^z->get_sym(h4b))==z->irrep_t()) { 
          long p3b_0,h4b_0; 
          z->restricted_2(p3b,h4b,p3b_0,h4b_0); 
          long h4b_1,p2b_1,h1b_1,p3b_1; 
          z->restricted_4(h4b,p2b,h1b,p3b,h4b_1,p2b_1,h1b_1,p3b_1); 
          long dim_common=z->get_range(h4b)*z->get_range(p3b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(p2b)*z->get_range(h1b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h4b_0+z->noab()*(p3b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(h4b),0,1,+1.0); 
          z->v2()->get_block(p3b_1+(z->nab())*(h1b_1+(z->nab())*(p2b_1+(z->nab())*(h4b_1))),k_a1); 
          z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(p2b),z->get_range(h1b),z->get_range(p3b),2,1,3,0,+1.0); 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h1b),z->get_range(p2b),1,0,-1.0); 
      out->add_block(h1b+z->noab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_6(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(p2b-z->noab())); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(h1b)) { 
     if ((z->get_sym(p2b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p2b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h4b=0L;h4b<z->noab();++h4b) { 
       for (long h5b=h4b;h5b<z->noab();++h5b) { 
        for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
         if (z->get_spin(p2b)+z->get_spin(p3b)==z->get_spin(h4b)+z->get_spin(h5b)) { 
          if ((z->get_sym(p2b)^(z->get_sym(p3b)^(z->get_sym(h4b)^z->get_sym(h5b))))==z->irrep_t()) { 
           long p2b_0,p3b_0,h4b_0,h5b_0; 
           z->restricted_4(p2b,p3b,h4b,h5b,p2b_0,p3b_0,h4b_0,h5b_0); 
           long h4b_1,h5b_1,h1b_1,p3b_1; 
           z->restricted_4(h4b,h5b,h1b,p3b,h4b_1,h5b_1,h1b_1,p3b_1); 
           long dim_common=z->get_range(h4b)*z->get_range(h5b)*z->get_range(p3b); 
           long dima0_sort=z->get_range(p2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h1b); 
           long dima1=dim_common*dima1_sort; 
           if (p2b<p3b) { 
            z->t2()->get_block(h5b_0+z->noab()*(h4b_0+z->noab()*(p3b_0-z->noab()+z->nvab()*(p2b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p2b),z->get_range(p3b),z->get_range(h4b),z->get_range(h5b),0,1,3,2,+1.0); 
           } 
           else if (p3b<=p2b) { 
            z->t2()->get_block(h5b_0+z->noab()*(h4b_0+z->noab()*(p2b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p2b),z->get_range(h4b),z->get_range(h5b),1,0,3,2,-1.0); 
           } 
           in[1]->get_block(p3b_1-z->noab()+z->nvab()*(h1b_1+z->noab()*(h5b_1+z->noab()*(h4b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h1b),z->get_range(p3b),2,3,1,0,+1.0); 
           double factor=1.0; 
           if (h4b==h5b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h1b),z->get_range(p2b),1,0,+0.5/0.5); 
      out->add_block(h1b+z->noab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_6_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=h4b;h5b<z->noab();++h5b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
    long tileoffset; 
    tileoffset=(p3b-z->noab()+z->nvab()*(h1b+z->noab()*(h5b+z->noab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h1b)+z->get_spin(p3b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h1b)+z->get_spin(p3b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h1b)^z->get_sym(p3b))))==z->irrep_v()) { 
        long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h1b)*z->get_range(p3b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h4b_0,h5b_0,h1b_0,p3b_0; 
        z->restricted_4(h4b,h5b,h1b,p3b,h4b_0,h5b_0,h1b_0,p3b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h1b)*z->get_range(p3b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p3b_0+(z->nab())*(h1b_0+(z->nab())*(h5b_0+(z->nab())*(h4b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h1b),z->get_range(p3b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h4b),z->get_range(h5b),z->get_range(h1b),z->get_range(p3b),0,1,2,3,-1.0); 
        in[1]->add_block(p3b-z->noab()+z->nvab()*(h1b+z->noab()*(h5b+z->noab()*(h4b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::offset_smith_0_6(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=h4b;h5b<z->noab();++h5b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
    if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h1b)+z->get_spin(p3b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h1b)^z->get_sym(p3b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h1b)+z->get_spin(p3b)!=8L) { 
       in[1]->input_offset(p3b-z->noab()+z->nvab()*(h1b+z->noab()*(h5b+z->noab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h1b)*z->get_range(p3b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_7(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(p2b-z->noab())); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(h1b)) { 
     if ((z->get_sym(p2b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p2b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h5b=0L;h5b<z->noab();++h5b) { 
       for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
        for (long p4b=p3b;p4b<z->noab()+z->nvab();++p4b) { 
         if (z->get_spin(p3b)+z->get_spin(p4b)==z->get_spin(h1b)+z->get_spin(h5b)) { 
          if ((z->get_sym(p3b)^(z->get_sym(p4b)^(z->get_sym(h1b)^z->get_sym(h5b))))==z->irrep_t()) { 
           long p3b_0,p4b_0,h1b_0,h5b_0; 
           z->restricted_4(p3b,p4b,h1b,h5b,p3b_0,p4b_0,h1b_0,h5b_0); 
           long h5b_1,p2b_1,p3b_1,p4b_1; 
           z->restricted_4(h5b,p2b,p3b,p4b,h5b_1,p2b_1,p3b_1,p4b_1); 
           long dim_common=z->get_range(h5b)*z->get_range(p3b)*z->get_range(p4b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (h1b<h5b) { 
            z->t2()->get_block(h5b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(h1b),z->get_range(h5b),2,1,0,3,+1.0); 
           } 
           else if (h5b<=h1b) { 
            z->t2()->get_block(h1b_0+z->noab()*(h5b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p3b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p3b),z->get_range(p4b),z->get_range(h5b),z->get_range(h1b),3,1,0,2,-1.0); 
           } 
           z->v2()->get_block(p4b_1+(z->nab())*(p3b_1+(z->nab())*(p2b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p2b),z->get_range(p3b),z->get_range(p4b),1,3,2,0,+1.0); 
           double factor=1.0; 
           if (p3b==p4b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(h1b),0,1,-0.5/0.5); 
      out->add_block(h1b+z->noab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_8(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(p2b-z->noab())); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(h1b)) { 
     if ((z->get_sym(p2b)^z->get_sym(h1b))==(z->irrep_e()^z->irrep_v())) { 
      long dimc=z->get_range(p2b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h4b=0L;h4b<z->noab();++h4b) { 
       for (long h5b=h4b;h5b<z->noab();++h5b) { 
        for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
         if (z->get_spin(p2b)+z->get_spin(q3b)==z->get_spin(h4b)+z->get_spin(h5b)) { 
          if ((z->get_sym(p2b)^(z->get_sym(q3b)^(z->get_sym(h4b)^z->get_sym(h5b))))==z->irrep_e()) { 
           long p2b_0,q3b_0,h4b_0,h5b_0; 
           z->restricted_4(p2b,q3b,h4b,h5b,p2b_0,q3b_0,h4b_0,h5b_0); 
           long h4b_1,h5b_1,h1b_1,q3b_1; 
           z->restricted_4(h4b,h5b,h1b,q3b,h4b_1,h5b_1,h1b_1,q3b_1); 
           long dim_common=z->get_range(h4b)*z->get_range(h5b)*z->get_range(q3b); 
           long dima0_sort=z->get_range(p2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h1b); 
           long dima1=dim_common*dima1_sort; 
           z->qy()->get_block(h5b_0+z->noab()*(h4b_0+z->noab()*(q3b_0-z->noab()-z->nvab()+z->ncab()*(p2b_0-z->noab()))),k_a0); 
           z->sort_indices4(k_a0,k_a0_sort,z->get_range(p2b),z->get_range(q3b),z->get_range(h4b),z->get_range(h5b),0,1,3,2,+1.0); 
           in[1]->get_block(q3b_1-z->noab()-z->nvab()+z->ncab()*(h1b_1+z->noab()*(h5b_1+z->noab()*(h4b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h1b),z->get_range(q3b),2,3,1,0,+1.0); 
           double factor=1.0; 
           if (h4b==h5b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h1b),z->get_range(p2b),1,0,+0.5/0.5); 
      out->add_block(h1b+z->noab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_8_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=h4b;h5b<z->noab();++h5b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
    long tileoffset; 
    tileoffset=(q3b-z->noab()-z->nvab()+z->ncab()*(h1b+z->noab()*(h5b+z->noab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h1b)+z->get_spin(q3b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h1b)+z->get_spin(q3b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h1b)^z->get_sym(q3b))))==z->irrep_v()) { 
        long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h1b)*z->get_range(q3b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h4b_0,h5b_0,h1b_0,q3b_0; 
        z->restricted_4(h4b,h5b,h1b,q3b,h4b_0,h5b_0,h1b_0,q3b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h1b)*z->get_range(q3b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(q3b_0+(z->nab())*(h1b_0+(z->nab())*(h5b_0+(z->nab())*(h4b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h1b),z->get_range(q3b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h4b),z->get_range(h5b),z->get_range(h1b),z->get_range(q3b),0,1,2,3,-1.0); 
        in[1]->add_block(q3b-z->noab()-z->nvab()+z->ncab()*(h1b+z->noab()*(h5b+z->noab()*(h4b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::offset_smith_0_8(){ 
 
long size=0L; 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=h4b;h5b<z->noab();++h5b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
    if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h1b)+z->get_spin(q3b)) { 
     if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h1b)^z->get_sym(q3b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h1b)+z->get_spin(q3b)!=8L) { 
       in[1]->input_offset(q3b-z->noab()-z->nvab()+z->ncab()*(h1b+z->noab()*(h5b+z->noab()*(h4b))),size); 
       size+=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h1b)*z->get_range(q3b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_0_9(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(p2b-z->noab())); 
  if (out->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(h1b)) { 
     if ((z->get_sym(p2b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_e())) { 
      long dimc=z->get_range(p2b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h3b=0L;h3b<z->noab();++h3b) { 
       for (long h4b=h3b;h4b<z->noab();++h4b) { 
        for (long h5b=0L;h5b<z->noab();++h5b) { 
         if (z->get_spin(h3b)+z->get_spin(h4b)==z->get_spin(h1b)+z->get_spin(h5b)) { 
          if ((z->get_sym(h3b)^(z->get_sym(h4b)^(z->get_sym(h1b)^z->get_sym(h5b))))==z->irrep_t()) { 
           long h3b_0,h4b_0,h1b_0,h5b_0; 
           z->restricted_4(h3b,h4b,h1b,h5b,h3b_0,h4b_0,h1b_0,h5b_0); 
           long h5b_1,p2b_1,h3b_1,h4b_1; 
           z->restricted_4(h5b,p2b,h3b,h4b,h5b_1,p2b_1,h3b_1,h4b_1); 
           long dim_common=z->get_range(h3b)*z->get_range(h4b)*z->get_range(h5b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p2b); 
           long dima1=dim_common*dima1_sort; 
           if (h1b<h5b) { 
            z->gt2()->get_block(h5b_0+z->noab()*(h1b_0+z->noab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h1b),z->get_range(h5b),2,3,1,0,+1.0); 
           } 
           else if (h5b<=h1b) { 
            z->gt2()->get_block(h1b_0+z->noab()*(h5b_0+z->noab()*(h4b_0+z->noab()*(h3b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),z->get_range(h1b),3,2,1,0,-1.0); 
           } 
           z->vr2()->get_block(h4b_1+z->noab()*(h3b_1+z->noab()*(p2b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p2b),z->get_range(h3b),z->get_range(h4b),1,0,3,2,+1.0); 
           double factor=1.0; 
           if (h3b==h4b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p2b),z->get_range(h1b),0,1,-0.5/0.5); 
      out->add_block(h1b+z->noab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_1_10(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(h3b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(h3b)==z->get_spin(h1b)) { 
     if ((z->get_sym(h3b)^z->get_sym(h1b))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
      long dimc=z->get_range(h3b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
       if (z->get_spin(p4b)==z->get_spin(h1b)) { 
        if ((z->get_sym(p4b)^z->get_sym(h1b))==z->irrep_t()) { 
         long p4b_0,h1b_0; 
         z->restricted_2(p4b,h1b,p4b_0,h1b_0); 
         long h3b_1,p4b_1; 
         z->restricted_2(h3b,p4b,h3b_1,p4b_1); 
         long dim_common=z->get_range(p4b); 
         long dima0_sort=z->get_range(h1b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h3b); 
         long dima1=dim_common*dima1_sort; 
         z->t1()->get_block(h1b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
         z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h1b),1,0,+1.0); 
         in[2]->get_block(p4b_1-z->noab()+z->nvab()*(h3b_1),k_a1); 
         z->sort_indices2(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(p4b),0,1,+1.0); 
         double factor=1.0; 
         z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(h1b),0,1,+1.0); 
      in[1]->add_block(h1b+z->noab()*(h3b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::offset_smith_1_10(){ 
 
long size=0L; 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  if (z->get_spin(h3b)==z->get_spin(p4b)) { 
   if ((z->get_sym(h3b)^z->get_sym(p4b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h3b)+z->get_spin(p4b)!=4L) { 
     in[2]->input_offset(p4b-z->noab()+z->nvab()*(h3b),size); 
     size+=z->get_range(h3b)*z->get_range(p4b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_1_11(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  long tileoffset; 
  tileoffset=(p3b-z->noab()+z->nvab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(p3b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(p3b)) { 
     if ((z->get_sym(h4b)^z->get_sym(p3b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h4b)*z->get_range(p3b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
        if (z->get_spin(p5b)==z->get_spin(h6b)) { 
         if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
          long p5b_0,h6b_0; 
          z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
          long h4b_1,h6b_1,p3b_1,p5b_1; 
          z->restricted_4(h4b,h6b,p3b,p5b,h4b_1,h6b_1,p3b_1,p5b_1); 
          long dim_common=z->get_range(h6b)*z->get_range(p5b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h4b)*z->get_range(p3b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
          if (h4b<h6b && p3b<p5b) { 
           z->v2()->get_block(p5b_1+(z->nab())*(p3b_1+(z->nab())*(h6b_1+(z->nab())*(h4b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(p3b),z->get_range(p5b),2,0,3,1,+1.0); 
          } 
          else if (h4b<h6b && p5b<=p3b) { 
           z->v2()->get_block(p3b_1+(z->nab())*(p5b_1+(z->nab())*(h6b_1+(z->nab())*(h4b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(p5b),z->get_range(p3b),3,0,2,1,-1.0); 
          } 
          else if (h6b<=h4b && p3b<p5b) { 
           z->v2()->get_block(p5b_1+(z->nab())*(p3b_1+(z->nab())*(h4b_1+(z->nab())*(h6b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h4b),z->get_range(p3b),z->get_range(p5b),2,1,3,0,-1.0); 
          } 
          else if (h6b<=h4b && p5b<=p3b) { 
           z->v2()->get_block(p3b_1+(z->nab())*(p5b_1+(z->nab())*(h4b_1+(z->nab())*(h6b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h4b),z->get_range(p5b),z->get_range(p3b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p3b),z->get_range(h4b),1,0,+1.0); 
      in[1]->add_block(p3b-z->noab()+z->nvab()*(h4b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_1_12(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=h4b;h5b<z->noab();++h5b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
    long tileoffset; 
    tileoffset=(p3b-z->noab()+z->nvab()*(h1b+z->noab()*(h5b+z->noab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h1b)+z->get_spin(p3b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h1b)+z->get_spin(p3b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h1b)^z->get_sym(p3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h1b)*z->get_range(p3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h1b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h1b))==z->irrep_t()) { 
           long p6b_0,h1b_0; 
           z->restricted_2(p6b,h1b,p6b_0,h1b_0); 
           long h4b_1,h5b_1,p3b_1,p6b_1; 
           z->restricted_4(h4b,h5b,p3b,p6b,h4b_1,h5b_1,p3b_1,p6b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h5b)*z->get_range(p3b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h1b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h1b),1,0,+1.0); 
           if (p3b<p6b) { 
            z->v2()->get_block(p6b_1+(z->nab())*(p3b_1+(z->nab())*(h5b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(p3b),z->get_range(p6b),2,1,0,3,+1.0); 
           } 
           else if (p6b<=p3b) { 
            z->v2()->get_block(p3b_1+(z->nab())*(p6b_1+(z->nab())*(h5b_1+(z->nab())*(h4b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(p6b),z->get_range(p3b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p3b),z->get_range(h5b),z->get_range(h4b),z->get_range(h1b),2,1,3,0,+1.0); 
        in[1]->add_block(p3b-z->noab()+z->nvab()*(h1b+z->noab()*(h5b+z->noab()*(h4b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_1_13(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(h3b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(h3b)==z->get_spin(h1b)) { 
     if ((z->get_sym(h3b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h3b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
         if (z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h6b)) { 
          if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h1b)^z->get_sym(h6b))))==z->irrep_t()) { 
           long p4b_0,p5b_0,h1b_0,h6b_0; 
           z->restricted_4(p4b,p5b,h1b,h6b,p4b_0,p5b_0,h1b_0,h6b_0); 
           long h3b_1,h6b_1,p4b_1,p5b_1; 
           z->restricted_4(h3b,h6b,p4b,p5b,h3b_1,h6b_1,p4b_1,p5b_1); 
           long dim_common=z->get_range(h6b)*z->get_range(p4b)*z->get_range(p5b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           if (h1b<h6b) { 
            z->t2()->get_block(h6b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h6b),2,1,0,3,+1.0); 
           } 
           else if (h6b<=h1b) { 
            z->t2()->get_block(h1b_0+z->noab()*(h6b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h6b),z->get_range(h1b),3,1,0,2,-1.0); 
           } 
           if (h3b<h6b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h6b_1+(z->nab())*(h3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h6b),z->get_range(p4b),z->get_range(p5b),0,3,2,1,+1.0); 
           } 
           else if (h6b<=h3b) { 
            z->v2()->get_block(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h3b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h3b),z->get_range(p4b),z->get_range(p5b),1,3,2,0,-1.0); 
           } 
           double factor=1.0; 
           if (p4b==p5b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(h1b),0,1,-0.5/0.5); 
      in[1]->add_block(h1b+z->noab()*(h3b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_1_14(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
  long tileoffset; 
  tileoffset=(q3b-z->noab()-z->nvab()+z->ncab()*(h4b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h4b)+z->get_spin(q3b)!=4L) { 
    if (z->get_spin(h4b)==z->get_spin(q3b)) { 
     if ((z->get_sym(h4b)^z->get_sym(q3b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h4b)*z->get_range(q3b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
        if (z->get_spin(p5b)==z->get_spin(h6b)) { 
         if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
          long p5b_0,h6b_0; 
          z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
          long h4b_1,h6b_1,p5b_1,q3b_1; 
          z->restricted_4(h4b,h6b,p5b,q3b,h4b_1,h6b_1,p5b_1,q3b_1); 
          long dim_common=z->get_range(h6b)*z->get_range(p5b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h4b)*z->get_range(q3b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
          if (h4b<h6b) { 
           z->v2()->get_block(q3b_1+(z->nab())*(p5b_1+(z->nab())*(h6b_1+(z->nab())*(h4b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h6b),z->get_range(p5b),z->get_range(q3b),3,0,2,1,+1.0); 
          } 
          else if (h6b<=h4b) { 
           z->v2()->get_block(q3b_1+(z->nab())*(p5b_1+(z->nab())*(h4b_1+(z->nab())*(h6b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h4b),z->get_range(p5b),z->get_range(q3b),3,1,2,0,-1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(q3b),z->get_range(h4b),1,0,-1.0); 
      in[1]->add_block(q3b-z->noab()-z->nvab()+z->ncab()*(h4b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_1_15(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h4b=0L;h4b<z->noab();++h4b) { 
 for (long h5b=h4b;h5b<z->noab();++h5b) { 
  for (long h1b=0L;h1b<z->noab();++h1b) { 
   for (long q3b=z->noab()+z->nvab();q3b<z->nab();++q3b) { 
    long tileoffset; 
    tileoffset=(q3b-z->noab()-z->nvab()+z->ncab()*(h1b+z->noab()*(h5b+z->noab()*(h4b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h4b)+z->get_spin(h5b)+z->get_spin(h1b)+z->get_spin(q3b)!=8L) { 
      if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h1b)+z->get_spin(q3b)) { 
       if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h1b)^z->get_sym(q3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h1b)*z->get_range(q3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
         if (z->get_spin(p6b)==z->get_spin(h1b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h1b))==z->irrep_t()) { 
           long p6b_0,h1b_0; 
           z->restricted_2(p6b,h1b,p6b_0,h1b_0); 
           long h4b_1,h5b_1,p6b_1,q3b_1; 
           z->restricted_4(h4b,h5b,p6b,q3b,h4b_1,h5b_1,p6b_1,q3b_1); 
           long dim_common=z->get_range(p6b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h4b)*z->get_range(h5b)*z->get_range(q3b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h1b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h1b),1,0,+1.0); 
           z->v2()->get_block(q3b_1+(z->nab())*(p6b_1+(z->nab())*(h5b_1+(z->nab())*(h4b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(p6b),z->get_range(q3b),3,1,0,2,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(q3b),z->get_range(h5b),z->get_range(h4b),z->get_range(h1b),2,1,3,0,-1.0); 
        in[1]->add_block(q3b-z->noab()-z->nvab()+z->ncab()*(h1b+z->noab()*(h5b+z->noab()*(h4b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_1_16(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(h3b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(h3b)==z->get_spin(h1b)) { 
     if ((z->get_sym(h3b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_e())) { 
      long dimc=z->get_range(h3b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h4b=0L;h4b<z->noab();++h4b) { 
       for (long h5b=h4b;h5b<z->noab();++h5b) { 
        for (long h6b=0L;h6b<z->noab();++h6b) { 
         if (z->get_spin(h4b)+z->get_spin(h5b)==z->get_spin(h1b)+z->get_spin(h6b)) { 
          if ((z->get_sym(h4b)^(z->get_sym(h5b)^(z->get_sym(h1b)^z->get_sym(h6b))))==z->irrep_t()) { 
           long h4b_0,h5b_0,h1b_0,h6b_0; 
           z->restricted_4(h4b,h5b,h1b,h6b,h4b_0,h5b_0,h1b_0,h6b_0); 
           long h3b_1,h6b_1,h4b_1,h5b_1; 
           z->restricted_4(h3b,h6b,h4b,h5b,h3b_1,h6b_1,h4b_1,h5b_1); 
           long dim_common=z->get_range(h4b)*z->get_range(h5b)*z->get_range(h6b); 
           long dima0_sort=z->get_range(h1b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           if (h1b<h6b) { 
            z->gt2()->get_block(h6b_0+z->noab()*(h1b_0+z->noab()*(h5b_0+z->noab()*(h4b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h1b),z->get_range(h6b),2,3,1,0,+1.0); 
           } 
           else if (h6b<=h1b) { 
            z->gt2()->get_block(h1b_0+z->noab()*(h6b_0+z->noab()*(h5b_0+z->noab()*(h4b_0))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(h4b),z->get_range(h5b),z->get_range(h6b),z->get_range(h1b),3,2,1,0,-1.0); 
           } 
           if (h3b<h6b) { 
            z->vr2()->get_block(h5b_1+z->noab()*(h4b_1+z->noab()*(h6b_1+(z->nab())*(h3b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h6b),z->get_range(h4b),z->get_range(h5b),0,1,3,2,+1.0); 
           } 
           else if (h6b<=h3b) { 
            z->vr2()->get_block(h5b_1+z->noab()*(h4b_1+z->noab()*(h3b_1+(z->nab())*(h6b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h3b),z->get_range(h4b),z->get_range(h5b),1,0,3,2,-1.0); 
           } 
           double factor=1.0; 
           if (h4b==h5b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(h1b),0,1,-0.5/0.5); 
      in[1]->add_block(h1b+z->noab()*(h3b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_1_4(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long h1b=0L;h1b<z->noab();++h1b) { 
  long tileoffset; 
  tileoffset=(h1b+z->noab()*(h3b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h3b)+z->get_spin(h1b)!=4L) { 
    if (z->get_spin(h3b)==z->get_spin(h1b)) { 
     if ((z->get_sym(h3b)^z->get_sym(h1b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h3b)*z->get_range(h1b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h5b=0L;h5b<z->noab();++h5b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        if (z->get_spin(p4b)==z->get_spin(h5b)) { 
         if ((z->get_sym(p4b)^z->get_sym(h5b))==z->irrep_t()) { 
          long p4b_0,h5b_0; 
          z->restricted_2(p4b,h5b,p4b_0,h5b_0); 
          long h3b_1,h5b_1,h1b_1,p4b_1; 
          z->restricted_4(h3b,h5b,h1b,p4b,h3b_1,h5b_1,h1b_1,p4b_1); 
          long dim_common=z->get_range(h5b)*z->get_range(p4b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h3b)*z->get_range(h1b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h5b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h5b),0,1,+1.0); 
          if (h3b<h5b) { 
           z->v2()->get_block(p4b_1+(z->nab())*(h1b_1+(z->nab())*(h5b_1+(z->nab())*(h3b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h5b),z->get_range(h1b),z->get_range(p4b),2,0,3,1,+1.0); 
          } 
          else if (h5b<=h3b) { 
           z->v2()->get_block(p4b_1+(z->nab())*(h1b_1+(z->nab())*(h3b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(h3b),z->get_range(h1b),z->get_range(p4b),2,1,3,0,-1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h1b),z->get_range(h3b),1,0,-1.0); 
      in[1]->add_block(h1b+z->noab()*(h3b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_1_5(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p2b=z->noab();p2b<z->noab()+z->nvab();++p2b) { 
 for (long p3b=z->noab();p3b<z->noab()+z->nvab();++p3b) { 
  long tileoffset; 
  tileoffset=(p3b-z->noab()+z->nvab()*(p2b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p2b)+z->get_spin(p3b)!=4L) { 
    if (z->get_spin(p2b)==z->get_spin(p3b)) { 
     if ((z->get_sym(p2b)^z->get_sym(p3b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p2b)*z->get_range(p3b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h5b=0L;h5b<z->noab();++h5b) { 
       for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
        if (z->get_spin(p4b)==z->get_spin(h5b)) { 
         if ((z->get_sym(p4b)^z->get_sym(h5b))==z->irrep_t()) { 
          long p4b_0,h5b_0; 
          z->restricted_2(p4b,h5b,p4b_0,h5b_0); 
          long h5b_1,p2b_1,p3b_1,p4b_1; 
          z->restricted_4(h5b,p2b,p3b,p4b,h5b_1,p2b_1,p3b_1,p4b_1); 
          long dim_common=z->get_range(h5b)*z->get_range(p4b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(p2b)*z->get_range(p3b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h5b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h5b),0,1,+1.0); 
          if (p3b<p4b) { 
           z->v2()->get_block(p4b_1+(z->nab())*(p3b_1+(z->nab())*(p2b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p2b),z->get_range(p3b),z->get_range(p4b),2,1,3,0,+1.0); 
          } 
          else if (p4b<=p3b) { 
           z->v2()->get_block(p3b_1+(z->nab())*(p4b_1+(z->nab())*(p2b_1+(z->nab())*(h5b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h5b),z->get_range(p2b),z->get_range(p4b),z->get_range(p3b),3,1,2,0,-1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p3b),z->get_range(p2b),1,0,-1.0); 
      in[1]->add_block(p3b-z->noab()+z->nvab()*(p2b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDPR12_T1::smith_2_10(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h3b=0L;h3b<z->noab();++h3b) { 
 for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
  long tileoffset; 
  tileoffset=(p4b-z->noab()+z->nvab()*(h3b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h3b)+z->get_spin(p4b)!=4L) { 
    if (z->get_spin(h3b)==z->get_spin(p4b)) { 
     if ((z->get_sym(h3b)^z->get_sym(p4b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h3b)*z->get_range(p4b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h6b=0L;h6b<z->noab();++h6b) { 
       for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
        if (z->get_spin(p5b)==z->get_spin(h6b)) { 
         if ((z->get_sym(p5b)^z->get_sym(h6b))==z->irrep_t()) { 
          long p5b_0,h6b_0; 
          z->restricted_2(p5b,h6b,p5b_0,h6b_0); 
          long h3b_1,h6b_1,p4b_1,p5b_1; 
          z->restricted_4(h3b,h6b,p4b,p5b,h3b_1,h6b_1,p4b_1,p5b_1); 
          long dim_common=z->get_range(h6b)*z->get_range(p5b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h3b)*z->get_range(p4b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h6b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h6b),0,1,+1.0); 
          if (h3b<h6b && p4b<p5b) { 
           z->v2()->get_block(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h6b_1+(z->nab())*(h3b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h6b),z->get_range(p4b),z->get_range(p5b),2,0,3,1,+1.0); 
          } 
          else if (h3b<h6b && p5b<=p4b) { 
           z->v2()->get_block(p4b_1+(z->nab())*(p5b_1+(z->nab())*(h6b_1+(z->nab())*(h3b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h3b),z->get_range(h6b),z->get_range(p5b),z->get_range(p4b),3,0,2,1,-1.0); 
          } 
          else if (h6b<=h3b && p4b<p5b) { 
           z->v2()->get_block(p5b_1+(z->nab())*(p4b_1+(z->nab())*(h3b_1+(z->nab())*(h6b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h3b),z->get_range(p4b),z->get_range(p5b),2,1,3,0,-1.0); 
          } 
          else if (h6b<=h3b && p5b<=p4b) { 
           z->v2()->get_block(p4b_1+(z->nab())*(p5b_1+(z->nab())*(h3b_1+(z->nab())*(h6b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h6b),z->get_range(h3b),z->get_range(p5b),z->get_range(p4b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p4b),z->get_range(h3b),1,0,-1.0); 
      in[2]->add_block(p4b-z->noab()+z->nvab()*(h3b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
