---
name: Cutadapt
url: https://cutadapt.readthedocs.io/
description: >
  Cutadapt is a tool to find and remove adapter sequences, primers, poly-A
  tails and other types of unwanted sequence from your high-throughput
  sequencing reads.
---

The Cutadapt module parses results generated by
[Cutadapt](https://cutadapt.readthedocs.io/),
a tool to find and remove adapter sequences, primers, poly-A
tails and other types of unwanted sequence from your high-throughput
sequencing reads.

This module should be able to parse logs from a wide range of versions of Cutadapt.
It works with both the regular Cutadapt report output and also with
[JSON reports (`--json`)](https://cutadapt.readthedocs.io/en/latest/guide.html#json-report).

Although the module parsing code works with very old log files, if you are working with
ancient versions (such as v1.2) you may need to change the search pattern to the following:

```yaml
sp:
  cutadapt:
    contents: "cutadapt version"
```

See the [module search patterns](http://multiqc.info/docs/#module-search-patterns)
section of the MultiQC documentation for more information.
