#ifndef __SQLIDE_UTILS_FE_H__
#define __SQLIDE_UTILS_FE_H__


#include "linux_utilities/image_cache.h"
#include "grt/icon_manager.h"
#include <gtkmm.h>

/*
#define WIDGET2(xml, name, var)\
(xml).get(#name, &var);

#define WIDGET_(xml, name)\
(xml).get(#name, &_ ## name);

#define WIDGET(xml, name)\
WIDGET2 (xml, name, name);

#define WIDGET_DEF2(xml, type, name, var)\
Gtk::type *var(NULL);\
WIDGET2 (xml, name, var)

#define WIDGET_DEF(xml, type, name)\
WIDGET_DEF2 (xml, type, name, name)

#define WIDGET_SIGNAL2(widget, signal, callback_member)\
  widget->signal_ ## signal().connect(sigc::mem_fun(this, &CLASS_NAME::callback_member));\

#define WIDGET_SIGNAL(widget, name, signal)\
  WIDGET_SIGNAL2 (widget, signal, on_ ## name ## _ ## signal)

#define WIDGET_SIGNAL_DEF(xml, type, name, signal)\
{\
  WIDGET_DEF2 (xml, type, name, w)\
  WIDGET_SIGNAL (w, name, signal)\
}
*/

static void set_tool_button_icon(Glib::RefPtr<Gtk::Builder> &xml, const std::string &button_name, const std::string &icon_filename);
static void set_tool_button_icon(Gtk::ToolButton *button, const std::string &icon_filename);

static void set_tool_button_icon(Glib::RefPtr<Gtk::Builder> &xml, const std::string &button_name, const std::string &icon_filename)
{
  Gtk::ToolButton *button;
  xml->get_widget(button_name, button);
  set_tool_button_icon(button, icon_filename);
}

static void set_tool_button_icon(Gtk::ToolButton *button, const std::string &icon_filename)
{
  bec::IconManager *icon_man= bec::IconManager::get_instance();
  bec::IconId btn_icon= icon_man->get_icon_id(icon_filename);
  ImageCache *image_cache= ImageCache::get_instance();
  Glib::RefPtr<Gdk::Pixbuf> pixbuf= image_cache->image(btn_icon);
  Gtk::Image *image= Gtk::manage(new Gtk::Image(pixbuf));
  image->show();
#if GTK_VERSION_GT(2,10)
  std::string tooltip_text= button->get_tooltip_text();
  if (tooltip_text.empty())
    button->set_tooltip_text(button->get_label());
#endif
  button->set_homogeneous(false);
  button->set_icon_widget(*image);
}

static void set_button_icon(Gtk::Button *button, const std::string &icon_filename)
{
  bec::IconManager *icon_man= bec::IconManager::get_instance();
  bec::IconId btn_icon= icon_man->get_icon_id(icon_filename);
  ImageCache *image_cache= ImageCache::get_instance();
  Gtk::Image *image= Gtk::manage(new Gtk::Image(image_cache->image(btn_icon)));
  button->set_image(*image);
  button->show_all();
}

#endif // __SQLIDE_UTILS_FE_H__
