/* 
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#pragma once

/**
 * Declaration of the Windows wrapper for the mforms TextEntry class.
 */
using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class TextEntryImpl : public ViewImpl
    {
    private:
      String ^_placeholder;
      Color _placeholder_color;
      Color _text_color; // Normal text color.
      bool _has_real_text;
      bool _changing_text;

    protected:
      static bool create(mforms::TextEntry *self, mforms::TextEntryType type);
      static void set_text(mforms::TextEntry *self, const std::string &text);
      static void set_placeholder_text(mforms::TextEntry *self, const std::string &text);
      static void set_placeholder_color(mforms::TextEntry *self, const std::string &color);
      static std::string get_text(mforms::TextEntry *self);
      static void set_max_length(mforms::TextEntry *self, int length);
      static void set_read_only(mforms::TextEntry *self, bool flag);
      static void set_bordered(mforms::TextEntry *self, bool flag);

      virtual void set_front_color(String ^color) override;

      void TextChanged(Object^ sender, EventArgs^ args);
      void KeyDown(Object^ sender, KeyEventArgs^ args);
      void GotFocus(Object^ sender, EventArgs^ args);
      void LostFocus(Object^ sender, EventArgs^ args);
    public:
      TextEntryImpl(mforms::TextEntry *text);

      static void init(Manager ^mgr)
      {
        mforms::ControlFactory *f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, mforms::TextEntry*, mforms::TextEntryType, mgr, f->_textentry_impl, TextEntryImpl, create);
        DEF_CALLBACK2(void, mforms::TextEntry*, const std::string&, mgr, f->_textentry_impl, TextEntryImpl, set_text);
        DEF_CALLBACK2(void, mforms::TextEntry*, const std::string&, mgr, f->_textentry_impl, TextEntryImpl, set_placeholder_text);
        DEF_CALLBACK2(void, mforms::TextEntry*, const std::string&, mgr, f->_textentry_impl, TextEntryImpl, set_placeholder_color);
        DEF_CALLBACK1(std::string, mforms::TextEntry*, mgr, f->_textentry_impl, TextEntryImpl, get_text);
        DEF_CALLBACK2(void, mforms::TextEntry*, int, mgr, f->_textentry_impl, TextEntryImpl, set_max_length);
        DEF_CALLBACK2(void, mforms::TextEntry*, bool, mgr, f->_textentry_impl, TextEntryImpl, set_read_only);
        DEF_CALLBACK2(void, mforms::TextEntry*, bool, mgr, f->_textentry_impl, TextEntryImpl, set_bordered);
      }
    };

  };
};
