/* ScummVM - Graphic Adventure Engine
*
* ScummVM is the legal property of its developers, whose names
* are too numerous to list here. Please refer to the COPYRIGHT
* file distributed with this source distribution.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#ifndef DARKSEED_USECODE_TOS_TABLES_H
#define DARKSEED_USECODE_TOS_TABLES_H

namespace Darkseed {
static constexpr uint16 handDescriptionsTbl[] = {
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	791, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 652, 0,
	729, 0, 0, 0,
	0, 0, 0, 852,
	0, 0, 0, 772,
	0, 0, 846, 0,
	0, 453, 0, 0,
	484, 0, 0, 0,
	0, 0, 0, 706,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 609,
	611, 607, 605, 603,
	601, 599, 597, 595,
	593, 591, 589, 0,
	0, 0, 0, 355,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 827,
	839, 0, 798, 807,
	803, 441, 449, 118,
	260, 272, 306, 91,
	162, 137, 377, 399,
	415, 475, 478, 481,
	0, 0, 999, 253,
	0, 0, 171, 183,
	213, 220, 285, 316,
	329, 338, 338, 357,
	516, 527, 534, 0,
	548, 562, 571, 576,
	614, 616, 621, 625,
	637, 0, 642, 644,
	646, 0, 674, 678,
	681, 684, 689, 0,
	726, 747, 0, 760,
	766, 781, 788, 819,
	823, 825, 0, 0,
	863, 0, 881, 888,
	892, 901, 0, 0,
	672, 322, 164
};

static constexpr int16 glovesTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 525,
	999, 999, 999, 999,
	999, 84, 999, 745,
	999, 999, 84, 999,
	999, 84, 84, 999,
	999, 999, 999, 999,
	999, 999, 999, 84,
	999, 999, 999, 999,
	999, 999, 84, 999,
	84, 999, 84, 49,
	999, 84, 999, 999,
	198, 487, 999, 773,
	999, 0, 999, 84,
	999, 84, 84, 999,
	999, 999, 84, 84,
	84, 999, 999, 84,
	999, 999, 999, 999,
	999, 999, 35, 999,
	84, 999, 999, 999,
	84, 84, 84, 84,
	84, 84, 84, 84,
	84, 84, 84, 84,
	84, 84, 84, 999,
	84, 84, 999, 999,
	999, 999, 999, 999,
	386, 84, 392, 84,
	996, 84, 999, 981,
	999, 796, 999, 808,
	804, 84, 84, 84,
	999, 84, 84, 84,
	999, 998, 991, 84,
	84, 999, 84, 84,
	999, 84, 999, 84,
	999, 999, 84, 185,
	84, 84, 84, 84,
	84, 84, 84, 999,
	999, 84, 84, 999,
	84, 999, 84, 84,
	84, 84, 999, 999,
	999, 999, 999, 999,
	999, 999, 84, 84,
	84, 84, 84, 84,
	84, 84, 999, 999,
	768, 999, 999, 820,
	84, 84, 999, 999,
	999, 999, 999, 84,
	84, 999, 84, 84,
	84, 84, 999
};

static constexpr int16 moneyTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 169,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	961, 961, 961, 961,
	961, 999, 999, 999,
	999, 999, 543, 58,
	872, 999, 999, 999,
	206, 999, 999, 999,
	999, 999, 999, 999,
	999, 461, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 999, 999,
	560, 999, 999, 999,
	999, 436, 999, 586,
	586, 586, 586, 586,
	586, 586, 586, 586,
	586, 586, 586, 999,
	156, 986, 999, 999,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 0, 999, 999,
	999, 999, 999, 999,
	804, 990, 999, 132,
	999, 281, 86, 111,
	999, 998, 991, 402,
	417, 999, 999, 999,
	999, 303, 0, 999,
	999, 999, 999, 190,
	217, 227, 290, 999,
	999, 999, 999, 999,
	906, 531, 999, 999,
	550, 999, 573, 577,
	999, 999, 999, 633,
	633, 633, 633, 633,
	633, 999, 999, 999,
	988, 687, 999, 999,
	999, 999, 999, 999,
	999, 785, 999, 999,
	980, 982, 999, 999,
	865, 999, 885, 999,
	999, 999, 989, 999,
	999, 326, 999
};

static constexpr int16 crowBarTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 518,
	999, 999, 999, 524,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	518, 518, 518, 518,
	518, 757, 0, 999,
	999, 999, 999, 51,
	999, 249, 999, 999,
	999, 485, 999, 999,
	999, 999, 979, 411,
	999, 456, 999, 999,
	999, 999, 470, 470,
	470, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 36, 832,
	999, 999, 999, 999,
	999, 433, 999, 583,
	583, 583, 583, 583,
	583, 583, 583, 583,
	583, 583, 583, 999,
	999, 986, 999, 360,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 753, 984, 981,
	999, 999, 999, 808,
	804, 990, 999, 999,
	22, 67, 85, 100,
	999, 998, 379, 999,
	999, 999, 479, 479,
	999, 995, 999, 999,
	999, 999, 173, 999,
	215, 224, 286, 999,
	330, 342, 349, 360,
	999, 999, 999, 999,
	550, 999, 999, 579,
	999, 999, 999, 628,
	628, 628, 628, 628,
	628, 999, 999, 999,
	988, 686, 999, 999,
	999, 999, 999, 762,
	999, 782, 999, 983,
	980, 982, 999, 999,
	999, 999, 999, 999,
	999, 999, 989, 999,
	999, 324, 999
};

static constexpr int16 journalTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 486, 999,
	868, 999, 999, 999,
	196, 486, 999, 999,
	999, 999, 999, 999,
	999, 455, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 986, 999, 999,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 999, 999, 981,
	999, 999, 999, 999,
	804, 999, 999, 999,
	999, 999, 82, 93,
	999, 998, 991, 999,
	999, 999, 999, 999,
	999, 299, 999, 999,
	999, 999, 999, 999,
	999, 222, 146, 309,
	999, 999, 999, 999,
	486, 999, 999, 999,
	550, 999, 999, 577,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	988, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	980, 982, 999, 864,
	999, 999, 999, 999,
	999, 999, 989, 999,
	999, 994, 999
};

static constexpr int16 libraryCardTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 0, 56,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	559, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	154, 999, 999, 999,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 0, 999, 981,
	999, 999, 999, 999,
	804, 443, 999, 999,
	999, 999, 999, 999,
	999, 998, 991, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 177, 999,
	999, 222, 288, 309,
	999, 999, 999, 999,
	519, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 499, 999,
	999, 993, 999
};

static constexpr int16 bobbyPinTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 50,
	0, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 457, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 999, 999,
	555, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 986, 999, 999,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 0, 999, 981,
	999, 999, 999, 808,
	804, 990, 999, 125,
	999, 66, 999, 99,
	999, 998, 991, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 223, 999, 999,
	332, 999, 999, 999,
	999, 999, 999, 999,
	550, 999, 999, 577,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 676, 999,
	988, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	980, 982, 999, 999,
	999, 999, 0, 999,
	999, 999, 989, 999,
	999, 993, 999
};

static constexpr int16 keysTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	871, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 413,
	999, 999, 999, 999,
	999, 999, 472, 472,
	472, 999, 999, 0,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 435, 716, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 986, 999, 365,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 999, 999, 981,
	999, 999, 999, 808,
	804, 990, 999, 999,
	25, 999, 999, 108,
	999, 998, 381, 999,
	416, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	336, 999, 999, 365,
	999, 999, 999, 999,
	550, 999, 999, 577,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	988, 999, 999, 999,
	999, 999, 999, 999,
	999, 784, 784, 999,
	980, 982, 999, 999,
	999, 999, 884, 999,
	999, 999, 989, 999,
	999, 993, 999
};

static constexpr int16 binocularsTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 53,
	999, 999, 999, 999,
	200, 999, 999, 999,
	999, 999, 999, 999,
	999, 459, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 38, 999,
	556, 999, 999, 999,
	999, 999, 999, 584,
	584, 584, 584, 584,
	584, 584, 584, 584,
	584, 584, 584, 999,
	150, 986, 999, 361,
	999, 999, 999, 999,
	386, 192, 392, 999,
	996, 753, 999, 999,
	999, 999, 799, 999,
	804, 990, 999, 127,
	23, 69, 999, 103,
	127, 998, 991, 401,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 174, 187,
	999, 225, 287, 999,
	334, 343, 343, 999,
	999, 530, 999, 999,
	550, 999, 999, 577,
	999, 999, 623, 630,
	630, 630, 630, 630,
	630, 999, 999, 999,
	988, 999, 999, 999,
	999, 999, 999, 763,
	999, 999, 999, 999,
	980, 982, 999, 999,
	999, 999, 999, 999,
	999, 999, 498, 999,
	999, 993, 998
};

static constexpr int16 shovelTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 524,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 48,
	999, 999, 627, 999,
	999, 485, 999, 999,
	999, 999, 979, 411,
	999, 456, 999, 999,
	999, 999, 470, 470,
	470, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 34, 832,
	999, 999, 999, 999,
	999, 999, 999, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 999,
	147, 986, 999, 359,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 753, 999, 981,
	841, 999, 999, 808,
	804, 990, 999, 123,
	21, 65, 310, 97,
	999, 998, 991, 999,
	999, 999, 999, 999,
	999, 995, 999, 999,
	999, 999, 999, 999,
	999, 999, 286, 999,
	330, 341, 348, 359,
	999, 999, 999, 999,
	550, 999, 572, 578,
	999, 999, 999, 627,
	627, 627, 627, 627,
	627, 999, 999, 999,
	988, 686, 999, 999,
	999, 999, 999, 762,
	999, 999, 999, 983,
	980, 982, 999, 999,
	999, 999, 999, 999,
	999, 999, 498, 999,
	999, 323, 999
};

static constexpr int16 delbertsCardTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 168,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 541, 52,
	999, 999, 999, 999,
	999, 0, 999, 999,
	999, 999, 999, 999,
	999, 455, 999, 999,
	0, 999, 999, 999,
	999, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 37, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	149, 986, 999, 999,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 754, 999, 981,
	999, 999, 999, 999,
	805, 990, 999, 999,
	999, 999, 999, 101,
	999, 998, 991, 999,
	999, 999, 999, 482,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 222, 999, 309,
	999, 999, 999, 999,
	999, 999, 999, 999,
	550, 999, 999, 577,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	988, 999, 999, 999,
	999, 999, 999, 999,
	999, 783, 999, 999,
	980, 982, 999, 999,
	999, 999, 999, 999,
	999, 999, 989, 999,
	999, 993, 999
};

static constexpr int16 stickTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 524,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 0, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	201, 489, 999, 999,
	999, 999, 979, 411,
	999, 456, 999, 999,
	999, 999, 470, 470,
	470, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 39, 832,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	147, 986, 999, 999,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 753, 984, 981,
	843, 999, 999, 808,
	804, 990, 999, 128,
	999, 70, 999, 104,
	999, 998, 991, 999,
	999, 999, 479, 479,
	999, 999, 999, 995,
	999, 999, 175, 188,
	216, 999, 999, 999,
	330, 999, 999, 999,
	999, 999, 999, 999,
	550, 999, 999, 577,
	999, 999, 999, 631,
	631, 631, 631, 631,
	631, 999, 999, 999,
	988, 686, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 983,
	980, 982, 999, 999,
	999, 999, 999, 999,
	999, 999, 989, 999,
	999, 325, 999
};

static constexpr int16 axeHandleTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 984, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	199, 489, 999, 999,
	999, 999, 979, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 999, 832,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 986, 999, 999,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 753, 999, 981,
	832, 999, 999, 808,
	804, 990, 999, 126,
	999, 68, 999, 102,
	999, 998, 380, 999,
	999, 999, 479, 999,
	999, 999, 999, 999,
	999, 999, 999, 186,
	999, 999, 999, 999,
	333, 999, 999, 999,
	999, 529, 999, 999,
	550, 999, 999, 577,
	999, 999, 999, 629,
	629, 629, 629, 629,
	629, 999, 999, 999,
	988, 686, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 983,
	980, 982, 999, 999,
	999, 999, 999, 999,
	999, 999, 989, 999,
	999, 993, 999
};

static constexpr int16 ropeTextTbl[199] = {
	0, 0, 0, 0,
	0, 0, 0, 999,
	0, 999, 0, 523,
	0, 0, 999, 0,
	793, 999, 0, 999,
	0, 0, 999, 0,
	0, 999, 699, 0,
	0, 0, 0, 0,
	0, 0, 999, 999,
	999, 999, 999, 999,
	999, 0, 0, 0,
	999, 0, 999, 45,
	0, 0, 0, 0,
	195, 485, 0, 999,
	0, 999, 847, 410,
	0, 454, 999, 0,
	0, 0, 469, 469,
	469, 0, 0, 987,
	0, 0, 0, 0,
	0, 0, 999, 831,
	999, 0, 0, 0,
	0, 0, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 0,
	144, 986, 0, 358,
	999, 999, 999, 999,
	386, 992, 392, 990,
	996, 753, 999, 981,
	840, 999, 0, 808,
	804, 990, 450, 121,
	261, 63, 81, 92,
	121, 998, 378, 400,
	999, 999, 999, 999,
	0, 297, 0, 999,
	999, 0, 999, 184,
	214, 221, 999, 999,
	999, 339, 339, 358,
	999, 528, 999, 0,
	549, 0, 999, 577,
	999, 617, 999, 626,
	0, 0, 0, 0,
	0, 0, 675, 999,
	988, 999, 999, 999,
	999, 999, 0, 761,
	767, 999, 999, 999,
	980, 982, 0, 0,
	0, 0, 0, 999,
	999, 0, 989, 999,
	999, 999, 0
};

static constexpr int16 microFilmTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	870, 999, 999, 999,
	999, 999, 999, 774,
	999, 999, 999, 999,
	999, 455, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 999, 999,
	0, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	152, 986, 999, 999,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 0, 999, 981,
	999, 999, 999, 999,
	804, 990, 999, 999,
	999, 71, 999, 999,
	105, 998, 991, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	335, 999, 999, 999,
	999, 999, 999, 999,
	550, 999, 999, 577,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	988, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	980, 982, 999, 999,
	864, 999, 999, 999,
	999, 999, 989, 999,
	999, 993, 999
};

static constexpr int16 specialHammerTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 757, 999, 999,
	999, 999, 999, 55,
	999, 999, 999, 999,
	203, 489, 999, 999,
	999, 999, 979, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 987,
	999, 999, 999, 999,
	999, 999, 999, 832,
	558, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 986, 999, 363,
	999, 999, 999, 999,
	387, 992, 392, 999,
	996, 753, 984, 904,
	999, 999, 999, 808,
	805, 990, 999, 130,
	999, 72, 999, 107,
	999, 998, 991, 999,
	999, 999, 999, 999,
	999, 0, 999, 999,
	999, 999, 176, 999,
	216, 999, 999, 999,
	330, 344, 351, 999,
	999, 999, 999, 999,
	550, 999, 999, 577,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	988, 999, 999, 999,
	999, 999, 999, 762,
	999, 999, 999, 983,
	980, 982, 999, 999,
	999, 999, 999, 889,
	999, 999, 989, 999,
	999, 324, 999
};

static constexpr int16 gunTextTbl[199] = {
	19, 19, 19, 19,
	19, 19, 19, 19,
	19, 19, 19, 19,
	19, 19, 19, 19,
	999, 999, 19, 999,
	19, 19, 999, 19,
	19, 999, 19, 19,
	19, 19, 19, 19,
	19, 19, 19, 999,
	19, 19, 19, 19,
	19, 757, 19, 19,
	999, 19, 19, 19,
	19, 19, 19, 19,
	19, 485, 19, 999,
	540, 999, 848, 19,
	19, 19, 999, 19,
	19, 19, 19, 19,
	19, 19, 19, 987,
	19, 19, 19, 19,
	19, 19, 19, 19,
	19, 19, 19, 19,
	19, 19, 999, 19,
	19, 19, 19, 19,
	19, 19, 19, 19,
	19, 19, 19, 19,
	19, 986, 19, 19,
	19, 19, 19, 19,
	350, 992, 392, 999,
	996, 753, 19, 19,
	19, 999, 999, 19,
	19, 990, 19, 19,
	19, 19, 19, 19,
	19, 998, 991, 19,
	19, 999, 999, 19,
	19, 19, 19, 999,
	19, 19, 19, 19,
	19, 999, 19, 19,
	19, 19, 19, 19,
	19, 19, 19, 19,
	19, 19, 19, 577,
	19, 618, 622, 19,
	19, 19, 19, 19,
	19, 19, 19, 999,
	19, 685, 999, 999,
	999, 999, 19, 19,
	19, 19, 999, 19,
	19, 19, 19, 19,
	19, 19, 19, 999,
	999, 19, 497, 999,
	999, 19, 19
};

static constexpr int16 watchTextTbl[199] = {
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 59,
	873, 999, 999, 999,
	210, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	160, 986, 999, 999,
	999, 999, 999, 999,
	386, 992, 392, 999,
	996, 999, 999, 981,
	999, 999, 999, 999,
	804, 990, 999, 134,
	27, 75, 87, 115,
	134, 998, 991, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 191,
	999, 228, 932, 318,
	999, 999, 999, 368,
	999, 999, 999, 999,
	999, 999, 999, 577,
	999, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	988, 999, 999, 999,
	999, 999, 999, 999,
	999, 999, 999, 999,
	980, 982, 999, 999,
	866, 999, 999, 999,
	999, 999, 999, 999,
	999, 993, 998
};

} // namespace Darkseed

#endif // DARKSEED_USECODE_TOS_TABLES_H
