/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * strtab.c - string table
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 *  $Header: strtab.c[4.0] Thu Jun 24 17:43:13 1993 andy@cs.tu-berlin.de frozen $
 */

#include "config.h"
#include "sttk.h"

/*=====================================
 * definition of hashtable for symbols
 *=====================================*/

typedef struct StrTabX StrTabEntry;

struct StrTabX {
  char     *symbol;
  StrTabEntry *next;
};

LOCAL StrTabEntry *strTabHash;
LOCAL int         strTabSize;

/*===========================
 * determine hash value
 *===========================*/

LOCAL int hashVal (symbol, size) /* from Aho/Ullman */
     char *symbol;
     int  size;
{
  register char *p;
  register unsigned long hval, g;

  hval = 0;
  for (p = symbol; *p != '\0'; p++) {
    hval = (hval << 4) ^ (*p);
    if ((g = hval & 0xf0000000)) {
      hval = hval ^ (g >> 24);
      hval = hval ^ g;
    }
  }
  return (hval % size);
}

/*=============================
 * add string to string table
 *=============================*/

EXPORT char *stStrEnter (symbol)
     char *symbol;
{
  static bool hinit = FALSE; /* indicate if hashtable is yet initialized */
  int         symLen, where;
  StrTabEntry *new, *entry = (StrTabEntry *)0;

  if ((symbol == (char *)0) || (symbol[0] == '\0'))
    return ((char *)0);

  if (!hinit) {
    strTabSize = ST_HASHSIZE * sizeof (StrTabEntry);
    if ((strTabHash = (StrTabEntry *)malloc ((unsigned) strTabSize)) == (StrTabEntry *)0)
      return (NULL);

    /* initialize hashlist */
    memset ((char *)strTabHash, 0, strTabSize);
    hinit = TRUE;
  }

  /* lookup symbol */
  where = hashVal (symbol, ST_HASHSIZE);
  if (strTabHash[where].symbol) { /* found something */
    if (!strcmp (strTabHash[where].symbol, symbol))
      return (strTabHash[where].symbol);
    else {
      entry = &strTabHash[where];
      while (entry->next) {
	entry = entry->next;
	if (!strcmp (entry->symbol, symbol))
	  return (entry->symbol);
      }
    }
  }

  /* symbol is new */
  symLen = strlen (symbol) + sizeof (char);
  if (!strTabHash[where].symbol) { /* entry is not used yet */
    if ((strTabHash[where].symbol = malloc ((unsigned) (symLen)))==(char *)0)
      return (NULL);
    strTabSize += symLen;
    strcpy (strTabHash[where].symbol, symbol);
    return (strTabHash[where].symbol);
  }
  else { /* hash collision */
    if ((new = (StrTabEntry *)malloc ((unsigned) sizeof (StrTabEntry))) == (StrTabEntry *)0)
      return (NULL);
    strTabSize += sizeof (StrTabEntry);
    if ((new->symbol = malloc ((unsigned) (symLen))) == (char *)0)
      return (NULL);
    strTabSize += symLen;
    strcpy (new->symbol, symbol);
    new->next = NULL;
    entry->next = new;
    return (new->symbol);
  }
}
