---
title: Changes in the 2011 releases (versions 0.12.3, 0.13.0 and 0.13.1)
---

## Version 0.13.1 (01.11.2011)

### Bugfixes

- switched-off traffic lights are now put into the correct state
- vehicles with gui shape can now be used as router input
- updated tutorial networks
- fixed bug in duarouter which prevented use of multiple inline routes
- object-chooser no longer centers on unwanted objects

### Enhancements

- TraCI
  - Added the possibility to retrieve an induction loop's position
    (offset/lane) as suggested by Xiao-Feng Xie; thanks\!
  - Added the possibility to [remove a vehicle via TraCI](../TraCI/Change_Vehicle_State.md)
  - Added the description about how to [add a vehicle via TraCI](../TraCI/Change_Vehicle_State.md)
  - Retrieve the number of still expected vehicles
- netconvert
  - added more control over joining junctions. You can declare nodes
    to be joined as well as exclude nodes from joining (see
    [Networks/PlainXML\#Joining_Nodes](../Networks/PlainXML.md#joining_nodes))
  - added option **--osm.discard-tls** (do not use tls definitions when importing OSM)
  - added option **--junctions.join-exclude** ** *<STRING\>\[,<STRING\>\]\** ** (junctions in this list are not joined)
  - added option **--no-left-connections** (do not build connections to left)
  - added optional attributes 'toLane' and 'fromLane' to
    connection-file element 'reset' (see
    [Networks/PlainXML\#Connection_Descriptions](../Networks/PlainXML.md#connection_descriptions))
  - added importer for openDRIVE files, see
    [Networks/Import/OpenDRIVE](../Networks/Import/OpenDRIVE.md);
    many thanks go to Marius Dupuis from
    [VIRES](https://vires.mscsoftware.com/) for allowing to use the example
    files for tests
  - added importer for matSIM files, see
    [Networks/Import/MATsim](../Networks/Import/MATsim.md)
    (actually already in 0.13.0)
  - added new plain xml input/output format **plain.tll.xml** which
    holds information about traffic lights.
  - added option **--geometry.max-segment-length** {{DT_FLOAT}} to restrict segment length by inserting additional
    geometry points
  - debugged brakedown on VISUM import
  - ignore connections for explicitly removed edges (instead of
    throwing an error)
- Simulation
  - Added [Simulation/Output/Instantaneous Induction Loops Detectors](../Simulation/Output/Instantaneous_Induction_Loops_Detectors.md)
  - [Simulation/Output/Induction Loops Detectors (E1)](../Simulation/Output/Induction_Loops_Detectors_(E1).md)
    now also allow to generate values on per-vehicle type base
- jtrrouter
  - added Karol Stosiek's patch for reading more than one turn-definitions file; changes **--turn-ratio-file** {{DT_FILE}} to **--turn-ratio-files** ** *<FILE\>\[,<FILE\>\]\** **
- sumo-gui
  - can now switch traffic lights back on
- Tutorials
  - moved tutorials from {{SUMO}}/docs to {{SUMO}}/tests/complex for assuring their
    compliance with the current version; they should though appear
    in the release under {{SUMO}}/docs
  - added a [tutorial on car-following parameter calibration](../Tutorials/Calibration/San_Pablo_Dam.md)
- Tools
  - added script tools/net/netdiff.py `<net1.net.xml> <net2.net.xml> <diff_prefix>` which creates the plain-xml
    differences of two sumo networks. The set of difference files
    can be loaded together with `<net1.net.xml>` to recreate `<net2.net.xml>`. This allows for advanced scenario
    management.
  - added tools for dealing with turn-ratios
- Documentation
  - restructured wiki-pages
  - new static HTML docs generated from the wiki

### Other

- updated gl2ps to version 1.3.6
- removed MSMsgInductLoop; the functionality was almost the same as
for a plain MSInductLoop just that an additional string was given;
the functionality can be easily obtained by using proper ids and
mapping them to "messages"


## Version 0.13.0 (13.07.2011)

We are using the change of the minor release number as an opportunity to
clean up some things. The network format, option names, and XML
element/attribute names were changed.

### Network Format

For the **network**, we try to rework it the way it happened the last
times, too:

Networks generated by SUMO 0.12.x can still be loaded and you may find a
script {{SUMO}}/tools/net/0123to0130.py which converts a network into the new
format. All things marked as deprecated in version 0.12.x are now not
functioning anymore. This means, you can not load networks generated by
versions before 0.12.0. Networks generated by the current version can
not be loaded into old SUMO versions.

- Tags
  - removed `<lanes>` and `<logic>` elements
  - replaced `<succ>` and `<succlane>` elements by `<connection>`. Dummy connections (*SUMO_NO_DESTINATION*) are no longer written.
  - replaced `<row-logic>` and `<logicitem>` elements by `<request>` (within `<junction>` elements)
  - renamed element `tl-logic` to `tlLogic`
  - renamed element `district` to `taz`
  - renamed element `dsource` to `tazSource`
  - renamed element `dsink` to `tazSink`
- Attributes
  - renamed attribute `min_dur` to `minDur`
  - renamed attribute `max_dur` to `maxDur`
  - renamed attribute `maxspeed` to `speed`
  - renamed attribute `linkno` to `linkIndex`
  - removed attribute `<depart>`
  - added attribute `<index>` to lanes
  - added optional attribute `<name>` to edges
  - added optional attribute `spreadType` to edges
  - added optional attribute `shape` to edges
- Values
  - junctions with traffic light now have type `traffic_light` (as in plain-xml)
  - renamed junction type `DEAD_END` to `dead_end`
  - edge attribute `function` will no longer be written in the default case (`=normal`)
  - edge attribute `type` will only be written if set
  - junction attribute `shape` will only be written if set

### Further Input Format Changes

- dfrouter
  - renamed element `detector_definition` to `detectorDefinition`
- ROUTES
  - attribute `length` in element
    `vType` was used to declare the length
    from one vehicles front bumper to the next vehicles front
    bumper. NOW it declares the actual physical length of the
    vehicle. Attribute `minGap` is used to
    declare the distance between front bumper of a vehicle and the
    back bumper of its leader in a traffic jam.
- netconvert
  - added optional attribute `name` to
    plain edge input. This is used for visualisation (Street name)
  - added optional attribute `endOffset`
    to plain edge input. This can be used to shorten the usable
    edge/lane length when stopping (i.e. in case of pedestrian
    crossings)
  - added optional attribute `width` to
    plain edge input. This will be used for visualisation in future
    patches
  - plain edge input now supports lane specific speeds
  - plain edge input now supports edge-specific vehicle class
    restrictions (`allow`,
    `disallow`)
  - replaced element `forceLength` by
    element `split` with altered
    functionality

### Option Names

Many options have been renamed to increase consistency and to hopefully
make them easier to understand and remember. All changes apply to
options given via the command line as well as options declared via
configuration files. The old options still work although some are now
marked as deprecated.

Call `<APPLICATION> --save-template <filename> --save-commented`
to get a list of supported options including synonyms.

### Application-Specific Changes

- Simulation
  - removed emitters, now only normal route files are allowed
  - renamed **--emissions-output** to **--summary**
  - renamed **--sloppy-emit** to **--sloppy-insert**
- netconvert
  - now fully supports import of SUMO networks
- TraCI
  - removed the possibility to set and retrieve traffic lights by
    phase/brake/yellow-tuples (both, state 0x21 and program 0x25)
  - completely removed old API
  - solved tickets [ticket\#273 (consolidate speed and acceleration manipulation methods)](https://sourceforge.net/apps/trac/sumo/ticket/273) and
    [ticket\#330 (Speed adaptation after receiving SLOWDOWN command not working.)](https://sourceforge.net/apps/trac/sumo/ticket/330)
  - introduced a way to decide whether safe velocity, maximum
    deceleration and maximum acceleration shall be considered when
    changing a vehicle's speed, see:
    [TraCI/Change_Vehicle_State](../TraCI/Change_Vehicle_State.md),
    speed mode (0xb3)
  - added default "error" return values for
    teleported/not-yet-inserted vehicles
  - All lengths are encoded as written in the specification. The
    correct code for reading length is:

```
int length = readByte()
if length==0:
length = readInt()
```

- added [Contributed/SUMO Traffic Modeler](../Contributed/SUMO_Traffic_Modeler.md)


## Version 0.12.3 (10.02.2011)

- all
  - License update to GPL v3+
  - verbose "--version" option concerning license
  - fixing a lot of compiler warnings
- dfrouter
  - generate plain vehicles instead of emitters
- duarouter
  - c-Logit Model implementation
- Simulation
  - tweaks to gap computation to avoid collisions
  - Added two further departpos-values, "`pwagSimple`" and "`pwagGeneric`" which try to achieve a higher flow. See:
    [Definition_of_Vehicles,_Vehicle_Types,_and_Routes\#departpos](../Definition_of_Vehicles,_Vehicle_Types,_and_Routes.md#departpos)
  - removing person-related deadlocks
  - improving vehicle routes output
- TraCI
  - please note that the encoding of a vehicle's angle has changed
- sumo-gui
  - corrected vehicle's angle (was
    [ticket\#430](https://sourceforge.net/apps/trac/sumo/ticket/430))
  - Clipboard works under Linux
