C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE SMBRAY
C                       *****************
C
C     --------------------------------------------------
     * (NUMBS,NELRAY,SUFRAY,TEMRAY,EMISSI,EPROPR,FDFNP1)
C     --------------------------------------------------
C 
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C
C          TRAITEMENT DU RAYONNEMENT TRANSPARENT
C          CALCUL DU SECOND MEMBRE
C
C          Cas d'une seule bande spectrale = sigma.epsilon.T^4.surf
C          Cas de plusieurs bandes spectrales = calcul par serie
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NUMBS    !  E ! D  ! NUMERO DE LA BANDE SPECTRALE                 !
C !  NELRAY   !  E ! D  ! NOMBRE D'ELEMENTS (maillage rayt)            !
C !  SUFRAY   ! TR ! D  ! SURFACE DES ELEMENTS (maillage rayt)         !
C !  TEMRAY   ! TR ! D  ! TEMPERATURE (maillage rayt)                  !
C !  EMISSI   ! TR ! D  ! EMISSIVITE (maillage rayt)                   !
C !  EPROPR   ! TR ! R  ! EMISSION PROPRE (maillage rayt)              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     : 
C
C     SOUS PROGRAMME(S) APPELE(S) :
C
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "rayonn.h"
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NELRAY,NUMBS
      DOUBLE PRECISION TEMRAY(NELRAY),SUFRAY(NELRAY)
      DOUBLE PRECISION EMISSI(NELRAY,2,NBANDE),EPROPR(NELRAY,NBANDE)
      DOUBLE PRECISION FDFNP1(NELRAY)
C
C..Variables Internes
      INTEGER N
      DOUBLE PRECISION C2,X1,X2,V,W1,W2,XJ
C
C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      C2 = 1.4388E-2
C
C
C     1- CAS D'UNE SEULE BANDE SPECTRALE
C     ==================================
C
      IF (NBANDE.EQ.1) THEN
C
        DO 100 N=1,NELRAY
          EPROPR(N,1) = SIGMA * EMISSI(N,1,1) * TEMRAY(N)**4 * SUFRAY(N)
  100   CONTINUE
C
        IF (LROUVR) THEN
          XJ = SIGMA * (TEMINF+TKEL)**4 
          DO 110 N=1,NELRAY
            EPROPR(N,1) = EPROPR(N,1)+
     *                   (1.-EMISSI(N,1,1)) *FDFNP1(N)*XJ
  110     CONTINUE
        ENDIF
C
C     2- CAS DE BANDES SPECTRALES MULTIPLES
C     =====================================
      ELSE
C
        X1 = C2/SPECTL(NUMBS,1)
        X2 = C2/SPECTL(NUMBS,2)
C
        DO 200 N=1,NELRAY
C
          V = X1/TEMRAY(N)
          CALL WIEBEL(V,W1)
C
          V = X2/TEMRAY(N)
          CALL WIEBEL(V,W2)
C
          EPROPR(N,NUMBS) = SIGMA * EMISSI(N,1,NUMBS) 
     *                    * TEMRAY(N)**4 * (W2-W1) * SUFRAY(N)
C
  200   CONTINUE
C
C
        IF (LROUVR) THEN
C
          V = X1/(TEMINF+TKEL)
          CALL WIEBEL(V,W1)
C
          V = X2/(TEMINF+TKEL)
          CALL WIEBEL(V,W2)
C
          DO 250 N=1,NELRAY
            EPROPR(N,NUMBS) =   EPROPR(N,NUMBS) +
     *                          (1.-EMISSI(N,1,NUMBS)) * FDFNP1(N)
     *                        * SIGMA
     *                        * (TEMINF+TKEL)**4 * (W2-W1)
  250     CONTINUE
        ENDIF
C
      ENDIF
C
C--------
C FORMATS
C--------
C
C
C----
C FIN
C----
C
      END
