from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


algorithms = _Mock()

base64 = _Mock()

base_flags = _Mock()

cast_bytes = _Mock()

contextmanager = _Mock()

hashlib = _Mock()

io = _Mock()

os = _Mock()

read = _Mock()

signature_removed = _Mock()

string_types = _Mock()

trust_flags = _Mock()

write = _Mock()

yield_everything = _Mock()



class Any(_Mock):
  pass
  info_text = 'any value'

class BaseIPythonApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Bytes(_Mock):
  pass
  default_value = ''
  info_text = 'a bytes object'

class Enum(_Mock):
  pass
  info_text = 'any value'

class HMAC(_Mock):
  pass
  blocksize = 64

class Instance(_Mock):
  pass
  info_text = 'any value'

class LoggingConfigurable(_Mock):
  pass


class MultipleInstanceError(_Mock):
  pass


class NotebookNotary(_Mock):
  pass


class TrustNotebookApp(_Mock):
  pass
  _in_init_profile_dir = False
  description = 'Sign one or more IPython notebooks with your key,\n    to trust their dynamic (HTML, Javascript) output.\n    \n    Otherwise, you will have to re-execute the notebook to see output.\n    '
  examples = 'ipython trust mynotebook.ipynb and_this_one.ipynb'

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class unicode_type(_Mock):
  pass


