[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::chan::zero n 1]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {Zero channel}]
[require Tcl 8.5]
[require TclOO]
[require tcl::chan::events [opt 1]]
[require tcl::chan::zero [opt 1]]
[description]
[para]

The [package tcl::chan::zero] package provides a command creating zero
channels, i.e. read-only channels which return an infinite stream of null
characters upon reading. This is equivalent to the zero channels
provided by the package [package Memchan], except that this is written
in pure Tcl, not C. On the other hand, [package Memchan] is usable with
Tcl 8.4 and before, whereas this package requires Tcl 8.5 or higher,
and TclOO.

[para] Packages related to this are [package tcl::chan::null] and
[package tcl::chan::nullzero].

[para] The internal [package TclOO] class implementing the channel
handler is a sub-class of the [package tcl::chan::events] framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::chan::zero]]

This command creates a new zero channel and returns its handle.

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph virtchannel] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords {virtual channel} {reflected channel} zero /dev/zero {tip 219}]
[manpage_end]
