'\"
'\" Generated from file 'generator\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "generator" n 0\&.2 tcllib "Tcl Generator Commands"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
generator \- Procedures for creating and using generators\&.
.SH SYNOPSIS
package require \fBTcl  8\&.6\fR
.sp
package require \fBgenerator  ?0\&.2?\fR
.sp
\fBgenerator\fR \fBdefine\fR \fIname\fR \fIparams\fR \fIbody\fR
.sp
\fBgenerator\fR \fByield\fR \fIarg\fR ?\fIargs\&.\&.\fR?
.sp
\fBgenerator\fR \fBforeach\fR \fIvarList\fR \fIgenerator\fR \fIvarList\fR \fIgenerator\fR ?\&.\&.\&.? \fIbody\fR
.sp
\fBgenerator\fR \fBnext\fR \fIgenerator\fR ?\fIvarName\&.\&.\fR?
.sp
\fBgenerator\fR \fBexists\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBnames\fR
.sp
\fBgenerator\fR \fBdestroy\fR ?\fIgenerator\&.\&.\fR?
.sp
\fBgenerator\fR \fBfinally\fR \fIcmd\fR ?\fIarg\&.\&.\fR?
.sp
\fBgenerator\fR \fBfrom\fR \fIformat\fR \fIvalue\fR
.sp
\fBgenerator\fR \fBto\fR \fIformat\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBmap\fR \fIfunction\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBfilter\fR \fIpredicate\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBreduce\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBfoldl\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBfoldr\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBall\fR \fIpredicate\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBand\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBany\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBconcat\fR \fIgenerator\fR ?\fIgenerator\&.\&.\fR?
.sp
\fBgenerator\fR \fBconcatMap\fR \fIfunction\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBdrop\fR \fIn\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBdropWhile\fR \fIpredicate\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBcontains\fR \fIelement\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBfoldl1\fR \fIfunction\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBfoldli\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBfoldri\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBhead\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBtail\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBinit\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBtakeList\fR \fIn\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBtake\fR \fIn\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBiterate\fR \fIfunction\fR \fIinit\fR
.sp
\fBgenerator\fR \fBlast\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBlength\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBor\fR \fIpredicate\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBproduct\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBrepeat\fR \fIn\fR \fIvalue\&.\&.\fR
.sp
\fBgenerator\fR \fBsum\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBtakeWhile\fR \fIpredicate\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBsplitWhen\fR \fIpredicate\fR \fIgenerator\fR
.sp
\fBgenerator\fR \fBscanl\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBgenerator\fR package provides commands to define and iterate over
generator expressions\&. A \fIgenerator\fR is a command that returns a sequence
of values\&. However, unlike an ordinary command that returns a list, a
generator \fIyields\fR each value and then suspends, allowing subsequent
values to be fetched on-demand\&. As such, generators can be used to efficiently
iterate over a set of values, without having to generate all answers in-memory\&.
Generators can be used to iterate over elements of a data structure, or rows
in the result set of a database query, or to decouple producer/consumer software
designs such as parsers and tokenizers, or to implement sophisticated custom
control strategies such as backtracking search\&. Generators reduce the need to
implement custom control structures, as many such structures can be recast as
generators, leading to both a simpler implementation and a more standardised
interface\&. The generator mechanism is built on top of the Tcl 8\&.6 coroutine
mechanism\&.
.PP
The package exports a single ensemble command, \fBgenerator\fR\&. All
functionality is provided as subcommands of this command\&. The core subcommands
of the package are \fBdefine\fR, \fByield\fR, and \fBforeach\fR\&. The
\fBdefine\fR command works like Tcl's \fBproc\fR command, but creates a
generator procedure; that is, a procedure that returns a generator when called\&.
The generator itself is a command that can be called multiple times: each time
it returns the next value in the generated series\&. When the
series has been exhausted, the generator command returns an empty list and then
destroys itself\&. Rather than manually call a generator, however, the package
also provides a flexible \fBforeach\fR command that loops through the values of
one or more generators\&. This loop construct mimicks the functionality of the
built-in Tcl \fBforeach\fR command, including handling multiple return values
and looping over multiple generators at once\&. Writing a generator is also a
simple task, much like writing a normal procedure: simply use the \fBdefine\fR
command to define the generator, and then call \fByield\fR instead of \fBreturn\fR\&.
For example, we can define a generator for looping through the integers
in a particular range:
.PP
.CS


    generator define range {n m} {
        for {set i $n} {$i <= $m} {incr i} { generator yield $i }
    }
    generator foreach x [range 1 10] {
        puts "x = $x"
    }

.CE
.PP
The above example will print the numbers from 1 to 10 in sequence, as you would
expect\&. The difference from a normal loop over a list is that the numbers are
only generated as they are needed\&. If we insert a break into the loop then any
remaining numbers in the sequence would never be generated\&. To illustrate, we
can define a generator that produces the sequence of natural numbers: an
infinite series\&. A normal procedure would never return trying to produce this
series as a list\&. By using a generator we only have to generate those values
which are actually used:
.PP
.CS


    generator define nats {} {
        while 1 { generator yield [incr nat] }
    }
    generator foreach n [nats] {
        if {$n > 100} { break }
    }

.CE
.SH COMMANDS
.TP
\fBgenerator\fR \fBdefine\fR \fIname\fR \fIparams\fR \fIbody\fR
Creates a new generator procedure\&. The arguments to the command are identical to
those for \fBproc\fR: a \fIname\fR, a list of parameters, and a body\&. The
parameter list format is identical to a procedure\&. In particular, default values
and the ?args? syntax can be used as usual\&. Each time the resulting
generator procedure is called it creates a new generator command (coroutine)
that will yield a list of values on each call\&. Each result from a generator is
guaranteed to be a non-empty list of values\&. When a generator is exhausted it
returns an empty list and then destroys itself to free up resources\&. It is an
error to attempt to call an exhausted generator as the command no longer exists\&.
.TP
\fBgenerator\fR \fByield\fR \fIarg\fR ?\fIargs\&.\&.\fR?
Used in the definition of a generator, this command returns the next set of
values to the consumer\&. Once the \fByield\fR command has been called the
generator will suspend to allow the consumer to process that value\&. When the
next value is requested, the generator will resume as if the yield command had
just returned, and can continue processing to yield the next result\&. The
\fByield\fR command must be called with at least one argument, but can be called with
multiple arguments, in which case this is equivalent to calling \fByield\fR
once for each argument\&.
.TP
\fBgenerator\fR \fBforeach\fR \fIvarList\fR \fIgenerator\fR \fIvarList\fR \fIgenerator\fR ?\&.\&.\&.? \fIbody\fR
Loops through one or more generators, assigning the next values to variables and
then executing the loop body\&. Works much like the built-in \fBforeach\fR
command, but working with generators rather than lists\&. Multiple generators can
be iterated over in parallel, and multiple results can be retrieved from a
single generator at once\&.  Like the built-in \fBforeach\fR, the loop will
continue until all of the generators have been exhausted: variables for
generators that are exhausted early will be set to the empty string\&.
.sp
The \fBforeach\fR command will automatically clean-up all of the generators
at the end of the loop, regardless of whether the loop terminated early or not\&.
This behaviour is provided as a convenience to avoid having to explicitly
clean up a generator in the usual cases\&. Generators can however be destroyed
before the end of the loop, in which case the loop will continue as normal until
all the other generators have been destroyed or exhausted\&.
.sp
The \fBforeach\fR command does not take a snapshot of the generator\&. Any
changes in the state of the generator made inside the loop or by other code will
affect the state of the loop\&. In particular, if the code in the loop invokes the
generator to manually retrieve the next element, this element will then be
excluded from the loop, and the next iteration will continue from the element
after that one\&. Care should be taken to avoid concurrent updates to generators
unless this behaviour is required (e\&.g\&., in argument processing)\&.
.TP
\fBgenerator\fR \fBnext\fR \fIgenerator\fR ?\fIvarName\&.\&.\fR?
Manually retrieves the next values from a generator\&. One value is retrieved for
each variable supplied and assigned to the corresponding variable\&. If the
generator becomes exhausted at any time then any remaining variables are set to
the empty string\&.
.TP
\fBgenerator\fR \fBexists\fR \fIgenerator\fR
Returns 1 if the generator (still) exists, or 0 otherwise\&.
.TP
\fBgenerator\fR \fBnames\fR
Returns a list of all currently existing generator commands\&.
.TP
\fBgenerator\fR \fBdestroy\fR ?\fIgenerator\&.\&.\fR?
Destroys one or more generators, freeing any associated resources\&.
.TP
\fBgenerator\fR \fBfinally\fR \fIcmd\fR ?\fIarg\&.\&.\fR?
Used in the definition of a generator procedure, this command arranges for a
resource to be cleaned up whenever the generator is destroyed, either explicitly
or implicitly when the generator is exhausted\&. This command can be used like a
\fBfinally\fR block in the \fBtry\fR command, except that it is tied to the
life-cycle of the generator rather than to a particular scope\&. For example, if
we create a generator to iterate over the lines in a text file, we can use
\fBfinally\fR to ensure that the file is closed whenever the generator is
destroyed:
.sp
.CS


    generator define lines file {
        set in [open $file]
        # Ensure file is always closed
        generator finally close $in
        while {[gets $in line] >= 0} {
            generator yield $line
        }
    }
    generator foreach line [lines /etc/passwd] {
        puts "[incr count]: $line"
        if {$count > 10} { break }
    }
    # File will be closed even on early exit

.CE
.sp
If you create a generator that consumes another generator (such as the standard
\fBmap\fR and \fBfilter\fR generators defined later), then you should use
a \fBfinally\fR command to ensure that this generator is destroyed when its
parent is\&. For example, the \fBmap\fR generator is defined as follows:
.sp
.CS


    generator define map {f xs} {
        generator finally generator destroy $xs
        generator foreach x $xs { generator yield [{*}$f $x] }
    }

.CE
.TP
\fBgenerator\fR \fBfrom\fR \fIformat\fR \fIvalue\fR
Creates a generator from a data structure\&. Currently, supported formats are
\fBlist\fR, \fBdict\fR, or \fBstring\fR\&. The list format yields each
element in turn\&. For dictionaries, each key and value are yielded separately\&.
Finally, strings are yielded a character at a time\&.
.TP
\fBgenerator\fR \fBto\fR \fIformat\fR \fIgenerator\fR
Converts a generator into a data structure\&. This is the reverse operation of the
\fBfrom\fR command, and supports the same data structures\&. The two operations
obey the following identity laws (where \fB=\fR is interpreted
appropriately):
.sp
.CS


    [generator to $fmt [generator from $fmt $value]] = $value
    [generator from $fmt [generator to $fmt $gen]]   = $gen


.CE
.PP
.SH PRELUDE
.PP
The following commands are provided as a standard library of generator
combinators and functions that perform convenience operations on generators\&. The
functions in this section are loosely modelled on the equivalent functions from
the Haskell Prelude\&. \fIWarning:\fR most of the functions in this prelude
destroy any generator arguments they are passed as a side-effect\&. If you want to
have persistent generators, see the streams library\&.
.TP
\fBgenerator\fR \fBmap\fR \fIfunction\fR \fIgenerator\fR
Apply a function to every element of a generator, returning a new generator of
the results\&. This is the classic map function from functional programming,
applied to generators\&. For example, we can generate all the square numbers using
the following code (where \fBnats\fR is defined as earlier):
.sp
.CS


    proc square x { expr {$x * $x} }
    generator foreach n [generator map square [nats]] {
        puts "n = $n"
        if {$n > 1000} { break }
    }

.CE
.TP
\fBgenerator\fR \fBfilter\fR \fIpredicate\fR \fIgenerator\fR
Another classic functional programming gem\&. This command returns a generator
that yields only those items from the argument generator that satisfy the
predicate (boolean function)\&. For example, if we had a generator \fBemployees\fR
that returned a stream of dictionaries representing people, we could filter all
those whose salaries are above 100,000 dollars (or whichever currency you prefer)
using a simple filter:
.sp
.CS


    proc salary> {amount person} { expr {[dict get $person salary] > $amount} }
    set fat-cats [generator filter {salary> 100000} $employees]

.CE
.TP
\fBgenerator\fR \fBreduce\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
This is the classic left-fold operation\&. This command takes a function, an
initial value, and a generator of values\&. For each element in the generator it
applies the function to the current accumulator value (the \fIzero\fR argument
initially) and that element, and then uses the result as the new accumulator
value\&. This process is repeated through the entire generator (eagerly) and the
final accumulator value is then returned\&. If we consider the function to be a
binary operator, and the zero argument to be the left identity element of that
operation, then we can consider the \fBreduce\fR command as \fIfolding\fR
the operator between each successive pair of values in the generator in a
left-associative fashion\&. For example, the sum of a sequence of numbers can be
calculated by folding a \fB+\fR operator between them, with 0 as the identity:
.sp
.CS


    # sum xs          = reduce + 0 xs
    # sum [range 1 5] = reduce + 0 [range 1 5]
    #                 = reduce + [+ 0 1] [range 2 5]
    #                 = reduce + [+ 1 2] [range 3 5]
    #                 = \&.\&.\&.
    #                 = reduce + [+ 10 5] <empty>
    #                 = ((((0+1)+2)+3)+4)+5
    #                 = 15
    proc + {a b} { expr {$a + $b} }
    proc sum gen { generator reduce + 0 $gen }
    puts [sum [range 1 10]]

.CE
.sp
The \fBreduce\fR operation is an extremely useful one, and a great variety of
different operations can be defined using it\&. For example, we can define a
factorial function as the product of a range using generators\&. This definition
is both very clear and also quite efficient (in both memory and running time):
.sp
.CS


    proc * {x y} { expr {$x * $y} }
    proc prod gen { generator reduce * 0 $gen }
    proc fac n { prod [range 1 $n] }

.CE
.sp
However, while the \fBreduce\fR operation is efficient for finite generators,
care should be taken not to apply it to an infinite generator, as this will
result in an infinite loop:
.sp
.CS


    sum [nats]; # Never returns

.CE
.TP
\fBgenerator\fR \fBfoldl\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
This is an alias for the \fBreduce\fR command\&.
.TP
\fBgenerator\fR \fBfoldr\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
This is the right-associative version of \fBreduce\fR\&. This operation is
generally inefficient, as the entire generator needs to be evaluated into memory
(as a list) before the reduction can commence\&. In an eagerly evaluated language
like Tcl, this operation has limited use, and should be avoided if possible\&.
.TP
\fBgenerator\fR \fBall\fR \fIpredicate\fR \fIgenerator\fR
Returns true if all elements of the generator satisfy the given predicate\&.
.TP
\fBgenerator\fR \fBand\fR \fIgenerator\fR
Returns true if all elements of the generator are true (i\&.e\&., takes the logical
conjunction of the elements)\&.
.TP
\fBgenerator\fR \fBany\fR \fIgenerator\fR
Returns true if any of the elements of the generator are true (i\&.e\&., logical
disjunction)\&.
.TP
\fBgenerator\fR \fBconcat\fR \fIgenerator\fR ?\fIgenerator\&.\&.\fR?
Returns a generator which is the concatenation of each of the argument
generators\&.
.TP
\fBgenerator\fR \fBconcatMap\fR \fIfunction\fR \fIgenerator\fR
Given a function which maps a value to a series of values, and a generator of
values of that type, returns a generator of all of the results in one flat
series\&. Equivalent to \fBconcat\fR applied to the result of \fBmap\fR\&.
.TP
\fBgenerator\fR \fBdrop\fR \fIn\fR \fIgenerator\fR
Removes the given number of elements from the front of the generator and returns
the resulting generator with those elements removed\&.
.TP
\fBgenerator\fR \fBdropWhile\fR \fIpredicate\fR \fIgenerator\fR
Removes all elements from the front of the generator that satisfy the predicate\&.
.TP
\fBgenerator\fR \fBcontains\fR \fIelement\fR \fIgenerator\fR
Returns true if the generator contains the given element\&. Note that this will
destroy the generator!
.TP
\fBgenerator\fR \fBfoldl1\fR \fIfunction\fR \fIgenerator\fR
A version of \fBfoldl\fR that takes the \fIzero\fR argument from the first
element of the generator\&. Therefore this function is only valid on non-empty
generators\&.
.TP
\fBgenerator\fR \fBfoldli\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
A version of \fBfoldl\fR that supplies the integer index of each element as
the first argument to the function\&. The first element in the generator at this
point is given index 0\&.
.TP
\fBgenerator\fR \fBfoldri\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
Right-associative version of \fBfoldli\fR\&.
.TP
\fBgenerator\fR \fBhead\fR \fIgenerator\fR
Returns the first element of the generator\&.
.TP
\fBgenerator\fR \fBtail\fR \fIgenerator\fR
Removes the first element of the generator, returning the rest\&.
.TP
\fBgenerator\fR \fBinit\fR \fIgenerator\fR
Returns a new generator consisting of all elements except the last of the
argument generator\&.
.TP
\fBgenerator\fR \fBtakeList\fR \fIn\fR \fIgenerator\fR
Returns the next \fIn\fR elements of the generator as a list\&. If not enough
elements are left in the generator, then just the remaining elements are
returned\&.
.TP
\fBgenerator\fR \fBtake\fR \fIn\fR \fIgenerator\fR
Returns the next \fIn\fR elements of the generator as a new generator\&. The old
generator is destroyed\&.
.TP
\fBgenerator\fR \fBiterate\fR \fIfunction\fR \fIinit\fR
Returns an infinite generator formed by repeatedly applying the function to the
initial argument\&. For example, the Fibonacci numbers can be defined as follows:
.sp
.CS


    proc fst pair { lindex $pair 0 }
    proc snd pair { lindex $pair 1 }
    proc nextFib ab { list [snd $ab] [expr {[fst $ab] + [snd $ab]}] }
    proc fibs {} { generator map fst [generator iterate nextFib {0 1}] }

.CE
.TP
\fBgenerator\fR \fBlast\fR \fIgenerator\fR
Returns the last element of the generator (if it exists)\&.
.TP
\fBgenerator\fR \fBlength\fR \fIgenerator\fR
Returns the length of the generator, destroying it in the process\&.
.TP
\fBgenerator\fR \fBor\fR \fIpredicate\fR \fIgenerator\fR
Returns 1 if any of the elements of the generator satisfy the predicate\&.
.TP
\fBgenerator\fR \fBproduct\fR \fIgenerator\fR
Returns the product of the numbers in a generator\&.
.TP
\fBgenerator\fR \fBrepeat\fR \fIn\fR \fIvalue\&.\&.\fR
Returns a generator that consists of \fIn\fR copies of the given elements\&. The
special value \fIInf\fR can be used to generate an infinite sequence\&.
.TP
\fBgenerator\fR \fBsum\fR \fIgenerator\fR
Returns the sum of the values in the generator\&.
.TP
\fBgenerator\fR \fBtakeWhile\fR \fIpredicate\fR \fIgenerator\fR
Returns a generator of the first elements in the argument generator that satisfy
the predicate\&.
.TP
\fBgenerator\fR \fBsplitWhen\fR \fIpredicate\fR \fIgenerator\fR
Splits the generator into lists of elements using the predicate to identify
delimiters\&. The resulting lists are returned as a generator\&. Elements matching
the delimiter predicate are discarded\&. For example, to split up a generator
using the string "|" as a delimiter:
.sp
.CS


    set xs [generator from list {a | b | c}]
    generator split {string equal "|"} $xs ;# returns a then b then c

.CE
.TP
\fBgenerator\fR \fBscanl\fR \fIfunction\fR \fIzero\fR \fIgenerator\fR
Similar to \fBfoldl\fR, but returns a generator of all of the intermediate
values for the accumulator argument\&. The final element of this generator is
equivalent to \fBfoldl\fR called on the same arguments\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Please report any errors in this document, or in the package it describes, to
\fINeil Madden\fR [mailto:nem@cs\&.nott\&.ac\&.uk]\&.
.SH KEYWORDS
control structure, coroutine, filter, foldl, foldr, foreach, generator, iterator, map, reduce, scanl
