## TFSA-2021-167: Code injection in `saved_model_cli`

### CVE Number
CVE-2021-41228

### Impact
TensorFlow's `saved_model_cli` tool is vulnerable to a code injection as it [calls `eval` on user supplied strings](https://github.com/tensorflow/tensorflow/blob/87462bfac761435a46641ff2f10ad0b6e5414a4b/tensorflow/python/tools/saved_model_cli.py#L524-L550)

```python
def preprocess_input_exprs_arg_string(input_exprs_str):
  ...
  for input_raw in filter(bool, input_exprs_str.split(';')):
    ...
    input_key, expr = input_raw.split('=', 1)
    input_dict[input_key] = eval(expr)
  ...
```

This can be used by attackers to run arbitrary code on the plaform where the CLI tool runs.

However, given that the tool is always run manually, the impact of this is not severe. We have patched this by adding a `safe` flag which defaults to `True` and an explicit warning for users.

### Patches
We have patched the issue in GitHub commit [8b202f08d52e8206af2bdb2112a62fafbc546ec7](https://github.com/tensorflow/tensorflow/commit/8b202f08d52e8206af2bdb2112a62fafbc546ec7).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Omer Kaspi from Vdoo.
