## TFSA-2022-047: Use after free in `DecodePng` kernel

### CVE Number
CVE-2022-23584

### Impact
A malicious user can cause a use after free behavior when [decoding PNG images](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/kernels/image/decode_image_op.cc#L339-L346):

```cc
if (/* ... error conditions ... */) {
  png::CommonFreeDecode(&decode);
  OP_REQUIRES(context, false,
              errors::InvalidArgument("PNG size too large for int: ",
                                      decode.width, " by ", decode.height));
}
```

After `png::CommonFreeDecode(&decode)` gets called, the values of `decode.width` and `decode.height` are in an unspecified state.

### Patches
We have patched the issue in GitHub commit [e746adbfcfee15e9cfdb391ff746c765b99bdf9b](https://github.com/tensorflow/tensorflow/commit/e746adbfcfee15e9cfdb391ff746c765b99bdf9b).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
