/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.nodes;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.piccolo2d.PCamera;
import org.piccolo2d.PLayer;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PDragEventHandler;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.nodes.PPath;

public class PLens
extends PNode {
    private static final long serialVersionUID = 1L;
    private final PPath dragBar;
    private final Rectangle2D dragBarRect = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
    private final PCamera camera;
    private final transient PDragEventHandler lensDragger;
    public static final double LENS_DRAGBAR_HEIGHT = 20.0;
    public static final Paint DEFAULT_DRAGBAR_PAINT = Color.DARK_GRAY;
    public static final Paint DEFAULT_LENS_PAINT = Color.LIGHT_GRAY;

    public PLens() {
        this.dragBar = new PPath.Float((Shape)this.dragBarRect);
        this.dragBar.setPaint(DEFAULT_DRAGBAR_PAINT);
        this.dragBar.setPickable(false);
        this.addChild((PNode)this.dragBar);
        this.camera = new PCamera();
        this.camera.setPaint(DEFAULT_LENS_PAINT);
        this.addChild((PNode)this.camera);
        this.lensDragger = new PDragEventHandler();
        this.lensDragger.getEventFilter().setMarksAcceptedEventsAsHandled(true);
        this.addInputEventListener((PInputEventListener)this.lensDragger);
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PLens.this.camera.setViewTransform((AffineTransform)PLens.this.getInverseTransform());
            }
        });
    }

    public PLens(PLayer layer) {
        this();
        this.addLayer(0, layer);
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public PPath getDragBar() {
        return this.dragBar;
    }

    public PDragEventHandler getLensDraggerHandler() {
        return this.lensDragger;
    }

    public void addLayer(int index, PLayer layer) {
        this.camera.addLayer(index, layer);
    }

    public void removeLayer(PLayer layer) {
        this.camera.removeLayer(layer);
    }

    protected void layoutChildren() {
        this.dragBar.reset();
        this.dragBarRect.setRect((float)this.getX(), (float)this.getY(), (float)this.getWidth(), 20.0);
        this.dragBar.append((Shape)this.dragBarRect, false);
        this.dragBar.closePath();
        this.camera.setBounds(this.getX(), this.getY() + 20.0, this.getWidth(), this.getHeight() - 20.0);
    }
}

