/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions.                                 */


/* defs for the svga version of tmview      */
/* will be copyed to "src/defs.h"           */
/* includes "src/defsgen.h"                 */

/* 
essential for I/O primitives and signalhandling:
don't use pure posix, use either BSD- or GNU-extensions.
*/

#define _GNU_SOURCE  

#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>  
#include <sys/fcntl.h>  
#include <sys/wait.h>  
#include <memory.h>
#include <unistd.h>
#include <signal.h>

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>


/*
***************************************************************************
  startup values, commandline default:
  here only those which tend to be deveice/platform dependant.
  see "src/defsgen.h" for more options
***************************************************************************
*/


/* set the default displaysize (option -d) */
/* only svgamodes 5, 10, 11 and 12 !       */
/* if set, $GSVGAMODE is ignored !         */

/* Example 1: ignore $GSVGAMODE, use mode 10 always as default*/
/* #define VGAXDIM 640 */
/* #define VGAYDIM 480 */

/* Example 2: use $GSVGAMODE as default . must be set to 5,10,11 or 12 therefore */
#define VGAXDIM 0
#define VGAYDIM 0


/* Portrait modus:                                        */
/* This is ment for people running a standard monitor     */
/* with a standard svga-card, but turning the monitor     */
/* physicaly to be in portrait-format. Those freaks need  */
/* the screen image shown by tmview turned by 90 degree   */
/* too. This results in portrait-format viewing without   */
/* bying expensive hardware. It results in kernel-hacking */
/* too, because the console has to be turned aswell, to   */
/* avoid getting tiered by turning the screen everey 5    */
/* minutes. Note: VGAXDIM and VGAYDIM are w.r.t. the      */
/* screen before beeing turned. Note: portrait does not   */
/* go with 10color mode.                                  */
/* All in all this results in:                            */
/* Realy nice for freaks, not usable for others.          */
/* #define PORTRAIT */


/* set defaults for the options -t, -f, -g and -n */
#define TFMDIR  "./:/usr/lib/texmf/fonts//:/usr/local/teTeX/texmf/fonts//"
#define PKDIR   "./:/usr/lib/texmf/fonts//:/usr/local/teTeX/texmf/fonts//"
#define VFDIR   "./:/usr/lib/texmf/fonts//:/usr/local/teTeX/texmf/fonts//"
#define PKNAME  "@N.@Mpk"


/* set defaults for the option -s */
/* and fallback systemwide startupfile */
#ifndef PORTRAIT
#define STARTUPFILENAME "~/.dvisvga"
#define SYSTEMSTARTUPFILENAME "/etc/dvisvga"
#else
#define STARTUPFILENAME "~/.dviport"
#define SYSTEMSTARTUPFILENAME "/etc/dviport"
#endif


/* Users kept asking about using kpathsea ... so: */
/* to use kpathsea, define KPATHSEA below. to use tmviews built in    */
/* font searching, don't define KPATHSEA.                             */
/* Since I'm not distributing KPATHSEA, you'll have to get the library*/
/* from somewhere. See CTAN. I did test with the library which comes  */
/* with dviljk-2.5. Note: it makes not much sense to use a kpathsea   */
/* different from the one of the rest of your TeX-installation. E.g.  */
/* teTeX users best use the kpathsea from the teTeX sources. After all*/
/* configuring tmview to go with kpathsea requires some knowhow ...   */
/*                                                                    */
/* I've located two different kinds of initializing kpathsea,         */
/* depending on which kpathsea is used (actually I've got this info   */
/* from the diff-file of debian/slink)  Below exactly one of          */
/* KPATHSEAOLDSTYLE and KPATHSEANEWSTYLE need to be defined to set up */
/* tmview to go with your kpathsea. To figure out the right choice,   */
/* visit your /usr//include/kpathsea/proginit.h: if it defines the    */
/* function kpse_init_prog to have 5 arguments by "P5H", then its     */
/* KPATHSEAOLDSTYLE. Probably, you will go into details and check the */
/* meaning of these arguments. See also "./tmview/src/tmview.c".      */
/* However, if kpse_init_prog is defined  to have 4 arguments ("P4H"),*/
/* its KPATHSEANEWSTYLE.                                              */ 
/*                                                                    */ 
/* Running MakeTeXPK by kpathsea within dvisvga may be enabled below, */
/* but is not recommended: console switching will pause MakeTeXPK,    */
/* you will have to wait for MakeTeXPK while viewing the empty screen.*/
/* Thus, running once in a while "./missfont.log" manualy seems  more */
/* "comfortable" to me. For svgalib>=1.3.0 and  kernel=>2.0 there     */
/* might be a solution on this topic.  See below LETSTRYBG.           */
/* #define KPATHSEA */
#ifdef KPATHSEA
#define KPATHMODE NULL    /* put f.e. "cx" here, to consist on cx fonts */
#define KPATHMAKE 0       /* put 1 here, to make kpathsea run MakeTeXPK,*/
#define KPATHDEFF "cmr10" /* fallback font                              */
#define KPATHSEANEWSTYLE    /* new=fine for teTeX from debian(see above)*/ 
/*#define KPATHSEAOLDSTYLE*//* old=fine for NTeX from Slakware          */
#endif


/* support for eps-figurs by calling ghostscript */
#define LETSTRYGS  
/* disable gs as startup-default. enable by command <o>*/
/* #define GSDEFOFF */

/*#define GSBIN "/usr/bin/gs" *//* absolute path of binary */
#define GSBIN "gs"              /* name of binary, use $PATH to locate it */

/* extra pixel to avoid clipping .. */
#define GSEXTRAPXL 3  /* plus 3 pxl on screen */   
#define GSEXTRAPT 3   /* plus 3 1/72 in epsfile */

/* greyscaling for eps-files */
/*#define GSGREY 1  *//* 1x1 pxl <> turned off */
#define GSGREY 2      /* 2x2 pxl <> cheap      */
/*#define GSGREY 4  *//* 4x4 pxl <> expensive  */

/* bufferlength for reading from gs */
#define GSBLOCKLEN 8192L 

/* arguments for calling gs */
#define GSARGLEN 40              /* max length og args */
#define GSARG0 "gs"
#define GSARG1 "-sDEVICE=bit"
#define GSARG2 "-sOutputFile=-"
#define GSARG3 "-dNOPAUSE"
#define GSARG4 "-dSAFER"
#define GSARG5 "-q"
#define GSARGPATH "-I%s"
#define GSARGSIZE "-g%dx%d"
#define GSARGRES "-r%.2fx%.2f"
#define GSARGLAST "-"
#define GSCODEINTRO  " /SDict 200 dict def SDict begin /showpage { } def "
#define GSCODESCALE  " %.5f %.5f scale "
#define GSCODETRANS  " %.2f %.2f translate "
#define GSCODEROTATE " %.2f rotate " 
#define GSCODEFILE   " (%s) run "
#define GSCODEQUIT   " end showpage quit "

/* a little support for color specials  */
#define LETSTRYCOLOR


/*
***************************************************************************
  more internal stuff, make tmview go with svgalib
***************************************************************************
*/

/* be careful with storge types !!! */
#define BMLONG32       /* for architectures where "long int" has 32bits, e.g. i386  */
/* #define BMLONG64  *//* for architectures where "long int" has 64bits, e.g. alpha */
/* #define GREYINBMU *//* waste memory. may be a bit faster    */

/* if DOSFILES is defined, a dosfilesystem is expected, */ 
/* incl. ugly naming conventions, like drive-letters and "\" instead ob "/". */
/* Dont use this with unix sytems */ 

/* #define DOSFILES */

/* yes, gnu does support the gnu-extensions to getcwd() ..*/
#define GNU_GETCWD

/* waiting for IO available: dont do polling */
/* This requires svgalib>=1.2.11 and it IS DEFINED in the MakeSVGA. */
/* To undefine, edit MakeSVGA */
/* #define VGAHASWAITIO */

/* svgalib>=1.2.11 with linux kernels>=2.0.? support running in backround.*/
/* I tested this with svgalib 1.3.0. Its fine, as using the background   */
/* option means that eps-rendering by gs and  font-generation by kpathsea */
/* will not be paused by switching virtual console. Thats what we want.  */
/* However, it may sometimes cause problems and therefore needs to be     */
/* enabled by defining LETSTRYBG. Anyway, background running is not       */
/* supported in the 16-color mode, the former MECK option.                */   
/* #define LETSTRYBG */


#define HASMOUSE      /* do this to have a little mousesoupport */
/* #define HASWINDOWS   *//* svgalib is no window system */
#define MOUSESPEED  3     /* speed of mousemotion */
/* #define TRACKBALL 1  *//* scrolling by mouse only if button pressed */


/* 
the following sets the way things go on the screen resp. window.
tmview allways keeps the screen/windows contents in an internal
buffer. You must define exactly one of the below options.
 
To provide flickering, you may define NOTHINGONSCREEN, making
tmview updating the screen from the buffer when the drawings are 
compleeted. On some Systems this will result in the best performance, 
depending on the screen driver. 

Set ALLONSCREEN, to make tmview drawing allways directly to the screen/window.
This might result in higher performance, at the cost of some flickering.

Set CURSORSNOTONSCREEEN to get a mixture of the above: when only
cursormovement is to be drawn, use the buffer. If more than that is
to be drawn, dont use the buffer.

Set SCROLLONSCREEN to get a mixture of the above: when scrolling is to
be done, use an XRequest directly. Anything else is done in the buffer.

*/

#define ALLONSCREEN         0
#define NOTHINGONSCREEN     1 
#define CURSORSNOTONSCREEN  0
#define SCROLLONSCREEN      0



/*
************************************************************************
now there will be some colorstuff. colors are changable here. but it's
the best to leave this untouched ...
*************************************************************************
*/


/*
The below definitions replace color makros by variables. They only depend on the
former MECK compile-time option, which became a runtime option in version 99.06.
So they still are sort of constants but need to be set in vgaopen() and vgagraph().
This doesnt look good, but it should work out fine.
*/
#define COLORS_PER_GREY   varColorspergrey

#define WHITECOL          varWhitecol
#define BLACKCOL          varBlackcol
#define BORDERCOL         varBordercol
#define TEXTCOL           varTextcol
#define TEXTBACKCOL       varTextbackcol
#define FRAMECOL	  varFramecol
#define TFMCOL            varTfmcol
#define RECTCOL           varRectcol

#define BACKCOLS          varBackcols
#define MARKSCOL          varMarkscol
#define MARKHCOL          varMarkhcol
#define FOUNDCOL          varFoundcol
#define HREFCOL           varHrefcol
#define MARKDCOL          varMarkdcol
#define MIXEDCOL          varMixedcol

#define NUMBER_OF_COLORS  varNumberofcolors


/* definition of some rgb triples, 6-bit-per-componente   */
/* to make green more blue, edit here.                    */

#define PALWHITE 63,63,63     /* white */
#define PALLGREY 55,55,55     /* light grey */
#define PALBLACK 0,0,0        /* black */
#define PALDRED 40,10,5       /* dark red */
#define PALDGREEN 0,40,10     /* dark green */
#define PALDBLUE 3,10,40      /* dark blue */
#define PALLRED 63,50,43      /* light red */
#define PALLGREEN 40,63,50    /* light green */
#define PALLBLUE 43,50,63     /* light blue */

/* definition of colors when in 256-color-mode              */
/* this determines the colors on the display                */
/* the following may be changed without any (?) restictions.*/
/* setting                                                  */ 
/* #define SETPALFRAMECOL FRAMECOL,0,63,0                   */
/* results in having a bright green as framecolor           */
/* BUT: this will not affect the  16-color-mode as this     */
/* is hardwired.                                            */

#define SETPALTEXTCOL     TEXTCOL,PALBLACK 
#define SETPALTEXTBACKCOL TEXTBACKCOL,PALLGREY 
#define SETPALFRAMECOL	  FRAMECOL,PALDRED
#define SETPALBORDERCOL   BORDERCOL,PALDGREEN
#define SETPALTFMCOL      TFMCOL,PALDBLUE
#define SETPALRECTCOL     RECTCOL,PALDBLUE 
#define SETPALMARKSCOL    MARKSCOL,PALLBLUE      
#define SETPALMARKHCOL    MARKHCOL,PALLGREEN
#define SETPALFOUNDCOL    FOUNDCOL,PALLGREEN    
#define SETPALHREFCOL     HREFCOL,PALLBLUE
#define SETPALMARKDCOL    MARKDCOL,PALLRED
#define SETPALMIXEDCOL    MIXEDCOL,PALLGREY




/*
***************************************************************************
  include general topics
***************************************************************************
*/

#include "defsgen.h"


