/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

int ttys_init(struct cwdaemon *cwda){
    cwda->fd = -1;
    ttys_open(cwda, 1);
	return 0;
}

int ttys_open(struct cwdaemon *cwda, int verbose){
    char errbuf[1024];
    int ret;
    
    if (cwda->fd >= 0) return 0;

    ret = fhs_lock(cfg->cwda_device, 1);
    if (ret){
        fhs_error(errbuf, sizeof(errbuf), ret, cfg->cwda_device);
        log_addf("CW keying ttys error: %s", errbuf);
        return -2;
    }
    cwda->ttys_locked = 1;
    
    cwda->fd = open(cfg->cwda_device, O_RDWR | O_NOCTTY);
    if (cwda->fd < 0){
        if (verbose) log_addf("Can't open %s %s", cfg->cwda_device, strerror_r(errno, errbuf, sizeof(errbuf)));
        ttys_reset(cwda);
        ttys_free(cwda);
        return -1;
    }
    return 0;
}

int ttys_free(struct cwdaemon *cwda){
    if (!cwda) return 0;

    if (cwda->fd>=0){
        close(cwda->fd);
        cwda->fd=-1;
    }
    if (cwda->ttys_locked) fhs_unlock(cfg->cwda_device);
	return 0;
}

int ttys_reset(struct cwdaemon *cwda){
    ttys_ptt(cwda, 0);
    ttys_cw(cwda, 0);
    ttys_ssbway(cwda, 0);
	return 0;
}

int ttys_cw(struct cwdaemon *cwda, int onoff){
    int pin, op;
    char errbuf[1024];

    pin=TIOCM_DTR;
    op=onoff?TIOCMBIS:TIOCMBIC;
    if (ioctl(cwda->fd, op, &pin)<0){
        dbg("Can't %s ttys_DTR %s\n", onoff?"set":"clear", strerror_r(errno, errbuf, sizeof(errbuf))); 
        close(cwda->fd);
        if (cwda->ttys_locked) fhs_unlock(cfg->cwda_device);
        cwda->fd=-1;
        return 1;
    }
	return 0;
}

int ttys_ptt(struct cwdaemon *cwda, int onoff){
    int pin, op;
    char errbuf[1024];

    dbg("ttys_ptt(%d)\n", onoff);
    pin=TIOCM_RTS;
    op=onoff?TIOCMBIS:TIOCMBIC;
    if (ioctl(cwda->fd, op, &pin)<0){
        dbg("Can't %s ttys_RTS %s\n", onoff?"set":"clear", strerror_r(errno, errbuf, sizeof(errbuf))); 
        close(cwda->fd);
        if (cwda->ttys_locked) fhs_unlock(cfg->cwda_device);
        cwda->fd=-1;
        return 1;
    }
	return 0;
}

int ttys_ssbway(struct cwdaemon *cwda, int onoff){
	return 0;
}

