"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Protocol Buffers - Google's data interchange format
Copyright 2008 Google Inc.  All rights reserved.
https://developers.google.com/protocol-buffers/

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

    * Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above
copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the
distribution.
    * Neither the name of Google Inc. nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""
import builtins
import sys

import google.protobuf.descriptor
import google.protobuf.internal.well_known_types
import google.protobuf.message

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Any(google.protobuf.message.Message, google.protobuf.internal.well_known_types.Any):
    """`Any` contains an arbitrary serialized protocol buffer message along with a
    URL that describes the type of the serialized message.

    Protobuf library provides support to pack/unpack Any values in the form
    of utility functions or additional generated methods of the Any type.

    Example 1: Pack and unpack a message in C++.

        Foo foo = ...;
        Any any;
        any.PackFrom(foo);
        ...
        if (any.UnpackTo(&foo)) {
          ...
        }

    Example 2: Pack and unpack a message in Java.

        Foo foo = ...;
        Any any = Any.pack(foo);
        ...
        if (any.is(Foo.class)) {
          foo = any.unpack(Foo.class);
        }

    Example 3: Pack and unpack a message in Python.

        foo = Foo(...)
        any = Any()
        any.Pack(foo)
        ...
        if any.Is(Foo.DESCRIPTOR):
          any.Unpack(foo)
          ...

    Example 4: Pack and unpack a message in Go

         foo := &pb.Foo{...}
         any, err := anypb.New(foo)
         if err != nil {
           ...
         }
         ...
         foo := &pb.Foo{}
         if err := any.UnmarshalTo(foo); err != nil {
           ...
         }

    The pack methods provided by protobuf library will by default use
    'type.googleapis.com/full.type.name' as the type URL and the unpack
    methods only use the fully qualified type name after the last '/'
    in the type URL, for example "foo.bar.com/x/y.z" will yield type
    name "y.z".


    JSON

    The JSON representation of an `Any` value uses the regular
    representation of the deserialized, embedded message, with an
    additional field `@type` which contains the type URL. Example:

        package google.profile;
        message Person {
          string first_name = 1;
          string last_name = 2;
        }

        {
          "@type": "type.googleapis.com/google.profile.Person",
          "firstName": <string>,
          "lastName": <string>
        }

    If the embedded message type is well-known and has a custom JSON
    representation, that representation will be embedded adding a field
    `value` which holds the custom JSON in addition to the `@type`
    field. Example (for message [google.protobuf.Duration][]):

        {
          "@type": "type.googleapis.com/google.protobuf.Duration",
          "value": "1.212s"
        }
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_URL_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    type_url: builtins.str
    """A URL/resource name that uniquely identifies the type of the serialized
    protocol buffer message. This string must contain at least
    one "/" character. The last segment of the URL's path must represent
    the fully qualified name of the type (as in
    `path/google.protobuf.Duration`). The name should be in a canonical form
    (e.g., leading "." is not accepted).

    In practice, teams usually precompile into the binary all types that they
    expect it to use in the context of Any. However, for URLs which use the
    scheme `http`, `https`, or no scheme, one can optionally set up a type
    server that maps type URLs to message definitions as follows:

    * If no scheme is provided, `https` is assumed.
    * An HTTP GET on the URL must yield a [google.protobuf.Type][]
      value in binary format, or produce an error.
    * Applications are allowed to cache lookup results based on the
      URL, or have them precompiled into a binary to avoid any
      lookup. Therefore, binary compatibility needs to be preserved
      on changes to types. (Use versioned type names to manage
      breaking changes.)

    Note: this functionality is not currently available in the official
    protobuf release, and it is not used for type URLs beginning with
    type.googleapis.com.

    Schemes other than `http`, `https` (or the empty scheme) might be
    used with implementation specific semantics.
    """
    value: builtins.bytes
    """Must be a valid serialized protocol buffer of the above specified type."""
    def __init__(
        self,
        *,
        type_url: builtins.str | None = ...,
        value: builtins.bytes | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["type_url", b"type_url", "value", b"value"]) -> None: ...

global___Any = Any
