class RedisError(Exception): ...
class AuthenticationError(RedisError): ...
class ConnectionError(RedisError): ...
class TimeoutError(RedisError): ...
class AuthorizationError(ConnectionError): ...
class BusyLoadingError(ConnectionError): ...
class InvalidResponse(RedisError): ...
class ResponseError(RedisError): ...
class DataError(RedisError): ...
class PubSubError(RedisError): ...
class WatchError(RedisError): ...
class NoScriptError(ResponseError): ...
class ExecAbortError(ResponseError): ...
class ReadOnlyError(ResponseError): ...
class NoPermissionError(ResponseError): ...
class ModuleError(ResponseError): ...
class LockError(RedisError, ValueError): ...
class LockNotOwnedError(LockError): ...
class ChildDeadlockedError(Exception): ...
class AuthenticationWrongNumberOfArgsError(ResponseError): ...
class RedisClusterException(Exception): ...
class ClusterError(RedisError): ...

class ClusterDownError(ClusterError, ResponseError):
    args: tuple[str]
    message: str
    def __init__(self, resp: str) -> None: ...

class AskError(ResponseError):
    args: tuple[str]
    message: str
    slot_id: int
    node_addr: tuple[str, int]
    host: str
    port: int
    def __init__(self, resp: str) -> None: ...

class TryAgainError(ResponseError): ...
class ClusterCrossSlotError(ResponseError): ...
class MovedError(AskError): ...
class MasterDownError(ClusterDownError): ...
class SlotNotCoveredError(RedisClusterException): ...
