"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2022 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================
"""
import builtins
import collections.abc
import sys

import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import tensorflow.tsl.protobuf.autotuning_pb2

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class AutotuneResults(google.protobuf.message.Message):
    """A collection of algorithms for particular dot/convs.  Usually this is "the
    best" algorithm for the particular dot/conv, although that's not strictly
    required.

    Users don't interact with this proto directly.  It's used internally to
    facilitate ahead-of-time autotuning -- The string used by
    xla::{Serialize,Load}AutotuneResults is, internally, a serialization of this
    proto.

    LINT.IfChange
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Entry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DEVICE_FIELD_NUMBER: builtins.int
        HLO_FIELD_NUMBER: builtins.int
        RESULT_FIELD_NUMBER: builtins.int
        device: builtins.str
        hlo: builtins.str
        @property
        def result(self) -> tensorflow.tsl.protobuf.autotuning_pb2.AutotuneResult:
            """nb: These results are always tied to a particular version of
            cublas/cudnn, but this is *especially* true for cublasLt results.  For
            cublasLt gemms, the result is an index into the list of candidate
            algorithms returned by cublasLt.  Different version of cublasLt ->
            different list of algos -> different interpretation of results!
            """
        def __init__(
            self,
            *,
            device: builtins.str | None = ...,
            hlo: builtins.str | None = ...,
            result: tensorflow.tsl.protobuf.autotuning_pb2.AutotuneResult | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["result", b"result"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["device", b"device", "hlo", b"hlo", "result", b"result"]) -> None: ...

    VERSION_FIELD_NUMBER: builtins.int
    DOTS_FIELD_NUMBER: builtins.int
    CONVS_FIELD_NUMBER: builtins.int
    version: builtins.int
    @property
    def dots(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AutotuneResults.Entry]: ...
    @property
    def convs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AutotuneResults.Entry]: ...
    def __init__(
        self,
        *,
        version: builtins.int | None = ...,
        dots: collections.abc.Iterable[global___AutotuneResults.Entry] | None = ...,
        convs: collections.abc.Iterable[global___AutotuneResults.Entry] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["convs", b"convs", "dots", b"dots", "version", b"version"]) -> None: ...

global___AutotuneResults = AutotuneResults
