/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "EventMessages.h"
#include <syslog.h>
#include "UNSMessageFileLinux.h"

EventMessages::EventMessages() {

	// Initializing categories
	_categories.resize(4);
	_categories[UNS_WLAN] = "WLAN";
	_categories[UNS_REMOTE_DIAGNOSTIC] = "Remote Diagnostics";
	_categories[UNS_GENERAL] = "UNS";
	_categories[UNS_CIRCUIT_BREAKER] = "System Defense";

	// Initializing events
	_events.resize(15);
	_events[NETWORK_TRAFFIC_TX_CEASED] = SingleEvent( LOG_INFO, 1001, "Security policy invoked. Some or all network traffic (TX) was stopped.");
	_events[NETWORK_CONNECTIVITY_TX_REDUCED] = SingleEvent( LOG_INFO, 1002, "Security policy invoked. TX Network connectivity was reduced.");
	_events[NETWORK_TRAFFIC_RX_CEASED] = SingleEvent( LOG_INFO, 1003, "Security policy invoked. Some or all network traffic (RX) was stopped.");
	_events[NETWORK_CONNECTIVITY_RX_REDUCED] = SingleEvent( LOG_INFO, 1004, "Security policy invoked. RX Network connectivity was reduced.");
	_events[WLAN_PROFILE_INSUFFICIENT] = SingleEvent( LOG_INFO, 1102, "WLAN Profile insufficient for management session over WLAN interface. ");
	_events[WLAN_SECURITY_INSUFFICIENT] = SingleEvent( LOG_INFO, 1103, "Security parameters insufficient for management session over WLAN interface.");
	_events[WLAN_SESSION_ESTABLISHED] = SingleEvent( LOG_INFO, 1104, "Management session was established over WLAN interface.");
	_events[WLAN_SESSION_ENDED] = SingleEvent( LOG_INFO, 1105, "Management session over WLAN interface has finished.");
	_events[REMOTE_SOL_STARTED] = SingleEvent( LOG_INFO, 1201, "A remote Serial Over LAN session was established.");
	_events[REMOTE_SOL_ENDED] = SingleEvent( LOG_INFO, 1202, "Remote Serial Over LAN session finished. User control was restored.");
	_events[REMOTE_IDER_STARTED] = SingleEvent( LOG_INFO, 1203, "A remote IDE-Redirection session was established.");
	_events[REMOTE_IDER_ENDED] = SingleEvent( LOG_INFO, 1204, "Remote IDE-Redirection session finished. User control was restored.");
	_events[TEXT_MESSAGE] = SingleEvent( LOG_INFO, 2000, "%1");
	_events[UNS_WARNING_MESSAGE] = SingleEvent( LOG_WARNING, 2001, "%1");
	_events[UNS_ERROR_MESSAGE] = SingleEvent( LOG_ERR, 2002, "%1");
}
