{ -*- buffer-read-only: t -*- }

{ Unit automatically generated by image_to_pas tool,
  to embed images in Pascal source code.
  @exclude (Exclude this unit from PasDoc documentation.) }
unit V3DSceneImages;

interface

uses CastleImages;

var
  Warning_icon: TRGBAlphaImage;

var
  Examine: TRGBAlphaImage;

var
  Walk: TRGBAlphaImage;

var
  Fly: TRGBAlphaImage;

var
  Open: TRGBAlphaImage;

var
  Screenshot: TRGBAlphaImage;

var
  Examine_tooltip: TRGBImage;

var
  Walk_fly_tooltip: TRGBImage;

implementation

uses SysUtils;

{ Actual image data is included from another file, with a deliberately
  non-Pascal file extension ".image_data". This way ohloh.net will
  not recognize this source code as (uncommented) Pascal source code. }
{$I v3dsceneimages.image_data}

initialization
  Warning_icon := TRGBAlphaImage.Create(Warning_iconWidth, Warning_iconHeight);
  Move(Warning_iconPixels, Warning_icon.RawPixels^, SizeOf(Warning_iconPixels));
  Examine := TRGBAlphaImage.Create(ExamineWidth, ExamineHeight);
  Move(ExaminePixels, Examine.RawPixels^, SizeOf(ExaminePixels));
  Walk := TRGBAlphaImage.Create(WalkWidth, WalkHeight);
  Move(WalkPixels, Walk.RawPixels^, SizeOf(WalkPixels));
  Fly := TRGBAlphaImage.Create(FlyWidth, FlyHeight);
  Move(FlyPixels, Fly.RawPixels^, SizeOf(FlyPixels));
  Open := TRGBAlphaImage.Create(OpenWidth, OpenHeight);
  Move(OpenPixels, Open.RawPixels^, SizeOf(OpenPixels));
  Screenshot := TRGBAlphaImage.Create(ScreenshotWidth, ScreenshotHeight);
  Move(ScreenshotPixels, Screenshot.RawPixels^, SizeOf(ScreenshotPixels));
  Examine_tooltip := TRGBImage.Create(Examine_tooltipWidth, Examine_tooltipHeight);
  Move(Examine_tooltipPixels, Examine_tooltip.RawPixels^, SizeOf(Examine_tooltipPixels));
  Walk_fly_tooltip := TRGBImage.Create(Walk_fly_tooltipWidth, Walk_fly_tooltipHeight);
  Move(Walk_fly_tooltipPixels, Walk_fly_tooltip.RawPixels^, SizeOf(Walk_fly_tooltipPixels));
finalization
  FreeAndNil(Warning_icon);
  FreeAndNil(Examine);
  FreeAndNil(Walk);
  FreeAndNil(Fly);
  FreeAndNil(Open);
  FreeAndNil(Screenshot);
  FreeAndNil(Examine_tooltip);
  FreeAndNil(Walk_fly_tooltip);
end.