/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.geom;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import org.j3d.geom.BoxGenerator;
import org.j3d.geom.ConeGenerator;
import org.j3d.geom.CoordinateUtils;
import org.j3d.geom.GeometryData;

public class Axis
extends Group {
    private static final float DEFAULT_AXIS_LENGTH = 5.0f;
    private static final float DEFAULT_X_SIZE = 0.05f;

    public Axis() {
        this(5.0f, 1.0f);
    }

    public Axis(float f) {
        this(f, 1.0f);
    }

    public Axis(float f, float f2) {
        Shape3D shape3D;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Axis length is not positive");
        }
        float f3 = 0.05f;
        if (f > 5.0f) {
            f3 = f * 0.04f;
        }
        BoxGenerator boxGenerator = new BoxGenerator(f3, f, f3);
        int n = 3;
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 3;
        geometryData.geometryComponents = 2;
        boxGenerator.generate(geometryData);
        TriangleStripArray triangleStripArray = new TriangleStripArray(geometryData.vertexCount, n, geometryData.stripCounts);
        triangleStripArray.setCoordinates(0, geometryData.coordinates);
        triangleStripArray.setNormals(0, geometryData.normals);
        ConeGenerator coneGenerator = new ConeGenerator(f3 * 4.0f, f3 * 2.0f, 4);
        geometryData.geometryType = 8;
        geometryData.vertexCount = 0;
        geometryData.coordinates = null;
        geometryData.normals = null;
        geometryData.stripCounts = null;
        coneGenerator.generate(geometryData);
        CoordinateUtils coordinateUtils = new CoordinateUtils();
        coordinateUtils.translate(geometryData.coordinates, geometryData.vertexCount, 0.0f, f * 0.5f + f3 * 2.0f, 0.0f);
        IndexedTriangleStripArray indexedTriangleStripArray = new IndexedTriangleStripArray(geometryData.vertexCount, n, geometryData.indexesCount, geometryData.stripCounts);
        indexedTriangleStripArray.setCoordinates(0, geometryData.coordinates);
        indexedTriangleStripArray.setNormals(0, geometryData.normals);
        indexedTriangleStripArray.setCoordinateIndices(0, geometryData.indexes);
        indexedTriangleStripArray.setNormalIndices(0, geometryData.indexes);
        Color3f color3f = new Color3f(0.0f, 0.0f, 0.8f);
        Material material = new Material();
        material.setDiffuseColor(color3f);
        material.setLightingEnable(true);
        Color3f color3f2 = new Color3f(0.8f, 0.0f, 0.0f);
        Material material2 = new Material();
        material2.setDiffuseColor(color3f2);
        material2.setLightingEnable(true);
        Color3f color3f3 = new Color3f(0.0f, 0.8f, 0.0f);
        Material material3 = new Material();
        material3.setDiffuseColor(color3f3);
        material3.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material2);
        Appearance appearance2 = new Appearance();
        appearance2.setMaterial(material3);
        Appearance appearance3 = new Appearance();
        appearance3.setMaterial(material);
        if (f2 != 1.0f) {
            shape3D = new TransparencyAttributes(0, f2);
            appearance.setTransparencyAttributes((TransparencyAttributes)shape3D);
            appearance2.setTransparencyAttributes((TransparencyAttributes)shape3D);
            appearance3.setTransparencyAttributes((TransparencyAttributes)shape3D);
        }
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.addGeometry((Geometry)triangleStripArray);
        shape3D.addGeometry((Geometry)indexedTriangleStripArray);
        Shape3D shape3D2 = new Shape3D();
        shape3D2.setAppearance(appearance2);
        shape3D2.addGeometry((Geometry)triangleStripArray);
        shape3D2.addGeometry((Geometry)indexedTriangleStripArray);
        Shape3D shape3D3 = new Shape3D();
        shape3D3.setAppearance(appearance3);
        shape3D3.addGeometry((Geometry)triangleStripArray);
        shape3D3.addGeometry((Geometry)indexedTriangleStripArray);
        Transform3D transform3D = new Transform3D();
        AxisAngle4f axisAngle4f = new AxisAngle4f();
        axisAngle4f.set(0.0f, 0.0f, 1.0f, -1.5707964f);
        transform3D.setRotation(axisAngle4f);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)shape3D);
        axisAngle4f.set(1.0f, 0.0f, 0.0f, 1.5707964f);
        transform3D.setRotation(axisAngle4f);
        TransformGroup transformGroup2 = new TransformGroup(transform3D);
        transformGroup2.addChild((Node)shape3D3);
        this.addChild((Node)transformGroup);
        this.addChild((Node)shape3D2);
        this.addChild((Node)transformGroup2);
    }
}

