/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class PlinkoBoard
extends JPanel
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener {
    double COUNT;
    double TOTAL;
    double TOTAL_SQUARES;
    long[] HIST;
    float MAX;
    double[][][] PINS;
    double DIST;
    double BALL_RAD;
    int PIN_RAD;
    int BINS;
    int W;
    int H;
    PlinkoBall FIRST_BALL;
    int BALL_COUNT;
    int BOTTOM_MARGIN = 5;
    int LEFT;
    int RIGHT;
    double PERCENT;
    int CURRENT_BIN = 0;
    int showstats = 0;
    static double[][] DYS;
    int maximum_balls;
    String start_number = "0";
    int incr = 1;
    int BIN_HEIGHT;
    static Color[] COLORS;
    Image[] IMAGES;
    Thread thread;
    boolean active;
    Image background;
    Image image;
    Graphics2D graphics;
    Plinko plinko;

    public PlinkoBoard(Plinko plinko) {
        this.plinko = plinko;
        this.setup();
        this.newHist();
        this.FIRST_BALL = null;
        this.BALL_COUNT = 0;
        this.active = false;
        DYS = new double[12][];
        for (double d = 0.0; d < 12.0; d += 1.0) {
            PlinkoBoard.DYS[(int)d] = new double[(int)d];
            for (double d2 = 0.0; d2 < d; d2 += 1.0) {
                PlinkoBoard.DYS[(int)d][(int)d2] = PlinkoBall.A * d2 * d2 / (d * d) + PlinkoBall.B * d2 / d;
            }
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.maximum_balls = plinko.total_balls - 1;
        this.BIN_HEIGHT = plinko.bin_height;
        if (!plinko.wims_exercise) {
            this.showstats = 1;
        } else {
            this.start_number = "1";
            this.incr = 2;
        }
    }

    public void setup() {
        int n;
        this.W = this.getWidth();
        this.H = this.getHeight();
        this.BINS = (Integer)Plinko.bins.getValue();
        this.CURRENT_BIN = this.BINS / 2;
        this.LEFT = this.BINS + 1;
        this.RIGHT = this.BINS;
        this.PERCENT = 0.0;
        this.DIST = this.H - this.BIN_HEIGHT - this.BOTTOM_MARGIN < this.W / 2 ? (double)(this.H - this.BIN_HEIGHT - this.BOTTOM_MARGIN) / (double)this.BINS : (double)(this.W - 10) / (double)(2 * this.BINS);
        this.PIN_RAD = (int)this.DIST / 9 + 1;
        this.BALL_RAD = Math.max(2.0 * this.DIST / 7.0, 2.0) + 1.0;
        this.IMAGES = new Image[COLORS.length];
        for (n = 0; n < COLORS.length; ++n) {
            this.IMAGES[n] = PlinkoBoard.getBall(this.BALL_RAD, COLORS[n]);
        }
        this.PINS = new double[this.BINS][][];
        for (n = 0; n < this.BINS; ++n) {
            this.PINS[n] = new double[n + 1][2];
            for (int i = 0; i <= n; ++i) {
                this.PINS[n][i][0] = this.DIST * (double)(2 * i - n) + (double)(this.W / 2);
                this.PINS[n][i][1] = this.DIST * (double)(n + 1);
            }
        }
        for (n = 0; n < this.BINS; ++n) {
            this.PINS[this.BINS - 1][n][0] = this.DIST * (double)(2 * n - this.BINS + 1) + (double)(this.W / 2);
            this.PINS[this.BINS - 1][n][1] = (double)(this.H - 30) - this.BALL_RAD;
        }
    }

    public static Image getBall(double d, Color color) {
        BufferedImage bufferedImage = new BufferedImage((int)(2.0 * d + 2.0), (int)(2.0 * d + 2.0), 2);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[]{-5.0, 5.0, 10.0};
        double d2 = Math.sqrt(150.0);
        for (int i = 0; i < (int)(2.0 * d + 2.0); ++i) {
            for (int j = 0; j < (int)(2.0 * d + 2.0); ++j) {
                int n;
                int n2;
                int n3;
                double d3;
                double d4;
                if ((d - (double)i) * (d - (double)i) + (d - (double)j) * (d - (double)j) <= (d - 1.0) * (d - 1.0)) {
                    dArray[0] = ((double)i - d) / d;
                    dArray[1] = (d - (double)j) / d;
                    dArray[2] = Math.sqrt(1.0 - dArray[0] * dArray[0] - dArray[1] * dArray[1]);
                    d4 = (dArray[0] * dArray3[0] + dArray[1] * dArray3[1] + dArray[2] * dArray3[2]) / Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1] + dArray3[2] * dArray3[2]);
                    d4 = (1.0 + d4) / 2.0;
                    d3 = Math.pow(d4, 20.0);
                    n3 = (int)((double)color.getRed() * (d4 - d3) + d3 * 255.0);
                    n2 = (int)((double)color.getGreen() * (d4 - d3) + d3 * 255.0);
                    n = (int)((double)color.getBlue() * (d4 - d3) + d3 * 255.0);
                    bufferedImage.setRGB(i, j, -16777216 + (n3 << 16) + (n2 << 8) + n);
                    continue;
                }
                if (!((d - (double)i) * (d - (double)i) + (d - (double)j) * (d - (double)j) <= (d + 1.0) * (d + 1.0))) continue;
                n3 = 0;
                n2 = 0;
                n = 0;
                for (double d5 = -0.33; d5 < 0.5; d5 += 0.33) {
                    for (double d6 = -0.33; d6 < 0.5; d6 += 0.33) {
                        if ((d - ((double)i + d5)) * (d - ((double)i + d5)) + (d - ((double)j + d6)) * (d - ((double)j + d6)) <= d * d) {
                            dArray[0] = ((double)i + d6 - d) / d;
                            dArray[1] = (d - ((double)j + d6)) / d;
                            dArray[2] = Math.sqrt(1.0 - dArray[0] * dArray[0] - dArray[1] * dArray[1]);
                            d4 = (dArray[0] * dArray3[0] + dArray[1] * dArray3[1] + dArray[2] * dArray3[2]) / d2;
                            d4 = (1.0 + d4) / 2.0;
                            d3 = Math.pow(d4, 20.0);
                        } else {
                            d4 = 1.0;
                            d3 = 1.0;
                        }
                        n3 += (int)((double)color.getRed() * (d4 - d3) + d3 * 255.0);
                        n2 += (int)((double)color.getGreen() * (d4 - d3) + d3 * 255.0);
                        n += (int)((double)color.getBlue() * (d4 - d3) + d3 * 255.0);
                    }
                }
                bufferedImage.setRGB(i, j, (255 - ((n3 /= 9) + (n2 /= 9) + (n /= 9)) / 3 << 24) + (n3 << 16) + (n2 << 8) + n);
            }
        }
        return bufferedImage;
    }

    public void newHist() {
        this.COUNT = 0.0;
        this.TOTAL = 0.0;
        this.TOTAL_SQUARES = 0.0;
        this.MAX = 0.0f;
        this.PERCENT = 0.0;
        this.HIST = new long[this.BINS];
        for (int i = 0; i < this.BINS; ++i) {
            this.HIST[i] = 0L;
        }
    }

    public String ReadData() {
        String string = "";
        for (int i = 0; i < this.HIST.length; ++i) {
            string = i != 0 ? string + "," + this.HIST[i] : "" + this.HIST[0];
        }
        return string;
    }

    public void LimitReached() {
        this.plinko.active = true;
        this.FIRST_BALL = null;
        this.plinko.toggleStart();
    }

    @Override
    public void run() {
        while (this.BALL_COUNT > 0) {
            this.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.repaint();
        this.active = false;
        this.plinko.active = false;
        Plinko.bins.setEnabled(true);
    }

    public void kill() {
        this.FIRST_BALL = null;
        if (this.plinko.start.getText().equals(this.plinko.start_text)) {
            this.active = false;
            this.plinko.active = false;
            Plinko.bins.setEnabled(true);
        }
    }

    public void dropBall(boolean bl) {
        ++this.BALL_COUNT;
        if (this.COUNT >= (double)this.maximum_balls) {
            this.LimitReached();
        }
        if (this.FIRST_BALL == null) {
            this.FIRST_BALL = new PlinkoBall();
            this.FIRST_BALL.sound = bl;
        } else {
            this.FIRST_BALL.previousBall = new PlinkoBall();
            this.FIRST_BALL.previousBall.sound = bl;
            this.FIRST_BALL.previousBall.nextBall = this.FIRST_BALL;
            this.FIRST_BALL = this.FIRST_BALL.previousBall;
        }
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.active) {
            this.active = true;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.W = this.getWidth();
        this.H = this.getHeight();
        if (this.background == null || this.background.getWidth(this) != this.W || this.background.getHeight(this) != this.H || this.image == null || this.image.getWidth(this) != this.W || this.image.getHeight(this) != this.H) {
            this.setup();
            this.background = this.createImage(this.W, this.H);
            this.drawBackground(this.W, this.H);
            this.image = this.createImage(this.W, this.H);
            this.graphics = (Graphics2D)this.image.getGraphics();
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.graphics.drawImage(this.background, 0, 0, this);
        PlinkoBall plinkoBall = this.FIRST_BALL;
        while (plinkoBall != null) {
            this.graphics.drawImage(this.IMAGES[plinkoBall.spaz], (int)(plinkoBall.X - this.BALL_RAD), (int)(plinkoBall.Y - 2.0 * this.BALL_RAD - (double)this.PIN_RAD + 1.0), this);
            this.increment(plinkoBall);
            plinkoBall = plinkoBall.nextBall;
        }
        this.drawHist(this.graphics);
        this.drawStats(this.graphics);
        graphics.drawImage(this.image, 0, 0, this);
    }

    public void drawNormal() {
    }

    public void increment(PlinkoBall plinkoBall) {
        if (plinkoBall.t == plinkoBall.C && plinkoBall.ROW < this.BINS - 2) {
            ++plinkoBall.ROW;
            plinkoBall.COL += plinkoBall.DIR;
            plinkoBall.t = 0;
            plinkoBall.DIR = 0;
            if (!this.plinko.wims_exercise) {
                if (Math.random() < (Double)Plinko.prob.getValue()) {
                    plinkoBall.DIR = 1;
                }
            } else if (Math.random() < this.plinko.chance) {
                plinkoBall.DIR = 1;
            }
            plinkoBall.C = 11 - (Integer)Plinko.rate.getValue();
            if (plinkoBall.sound) {
                Plinko.ping.play();
            }
        }
        double d = this.DIST * (double)plinkoBall.t * (double)(2 * plinkoBall.DIR - 1) / (double)plinkoBall.C;
        if (plinkoBall.ROW < 0) {
            plinkoBall.X = this.PINS[0][0][0];
            d = Math.abs(d);
            plinkoBall.Y = this.PINS[0][0][1] - this.DIST + this.DIST * (double)plinkoBall.t * (double)plinkoBall.t / (double)(plinkoBall.C * plinkoBall.C);
        } else if (plinkoBall.ROW < this.BINS - 2) {
            plinkoBall.X = this.PINS[plinkoBall.ROW][plinkoBall.COL][0] + d;
            d = Math.abs(d);
            plinkoBall.Y = this.PINS[plinkoBall.ROW][plinkoBall.COL][1] - this.DIST * DYS[plinkoBall.C][plinkoBall.t];
        } else {
            plinkoBall.X = this.PINS[plinkoBall.ROW][plinkoBall.COL][0] + d;
            plinkoBall.X = d > 0.0 ? Math.min(plinkoBall.X, this.PINS[plinkoBall.ROW][plinkoBall.COL][0] + 2.0 * this.DIST - this.BALL_RAD) : Math.max(plinkoBall.X, this.PINS[plinkoBall.ROW][plinkoBall.COL][0] - 2.0 * this.DIST + this.BALL_RAD + 1.0);
            d = Math.abs(d);
            plinkoBall.Y = this.PINS[plinkoBall.ROW][plinkoBall.COL][1] - d * (PlinkoBall.A * d / this.DIST + PlinkoBall.B);
        }
        ++plinkoBall.t;
        if (plinkoBall.Y > (double)(this.H - this.BOTTOM_MARGIN - this.PIN_RAD)) {
            if (plinkoBall.previousBall != null && plinkoBall.nextBall != null) {
                plinkoBall.previousBall.nextBall = plinkoBall.nextBall;
                plinkoBall.nextBall.previousBall = plinkoBall.previousBall;
            } else if (plinkoBall.previousBall != null && plinkoBall.nextBall == null) {
                plinkoBall.previousBall.nextBall = null;
            } else if (plinkoBall.previousBall == null && plinkoBall.nextBall != null) {
                plinkoBall.nextBall.previousBall = null;
                this.FIRST_BALL = plinkoBall.nextBall;
            } else {
                this.FIRST_BALL = null;
                Plinko.bins.setEnabled(true);
            }
            --this.BALL_COUNT;
            this.updateHist(plinkoBall.COL + plinkoBall.DIR);
            if (plinkoBall.sound) {
                Plinko.click.play();
            }
        }
    }

    public void updateHist(int n) {
        int n2 = n;
        this.HIST[n2] = this.HIST[n2] + 1L;
        this.COUNT += 1.0;
        this.TOTAL += (double)n;
        this.TOTAL_SQUARES += (double)(n * n);
        if ((float)this.HIST[n] > this.MAX) {
            this.MAX = this.HIST[n];
        }
        if (n >= this.LEFT && n <= this.RIGHT) {
            this.PERCENT += 1.0;
        }
    }

    public void drawStats(Graphics graphics) {
        if (this.showstats == 1) {
            this.plinko.count.setText(this.plinko.label_count + (int)this.COUNT);
            this.plinko.current_bin.setText(this.plinko.label_bin + this.CURRENT_BIN);
            this.plinko.current_bin_count.setText(this.plinko.label_bin_count + this.HIST[this.CURRENT_BIN]);
            if (this.COUNT > 0.0) {
                double d = this.TOTAL / this.COUNT;
                this.plinko.mean.setText(this.plinko.label_mean + (float)d);
                this.plinko.variance.setText(this.plinko.label_variance + (float)(this.TOTAL_SQUARES / this.COUNT - d * d));
                this.plinko.current_bin_prob.setText(this.plinko.label_bin_probability + (float)((double)((int)((double)(100000L * this.HIST[this.CURRENT_BIN]) / this.COUNT)) / 1000.0) + "%");
                if (this.LEFT < this.BINS) {
                    if (this.LEFT == this.RIGHT) {
                        this.plinko.confidence.setText(this.plinko.label_confidence + (float)((double)((int)(100000.0 * this.PERCENT / this.COUNT)) / 1000.0) + this.plinko.some_text + this.LEFT + ".");
                    } else {
                        this.plinko.confidence.setText(this.plinko.label_confidence + (float)((double)((int)(100000.0 * this.PERCENT / this.COUNT)) / 1000.0) + this.plinko.some_text2 + this.LEFT + this.plinko.through + this.RIGHT + ".");
                    }
                } else {
                    this.plinko.confidence.setText(this.plinko.label_confidence);
                }
            } else {
                this.plinko.mean.setText(this.plinko.label_mean);
                this.plinko.variance.setText(this.plinko.label_variance);
                this.plinko.current_bin_prob.setText(this.plinko.label_bin_probability);
                this.plinko.confidence.setText(this.plinko.label_confidence);
            }
        } else {
            this.plinko.count.setText(this.plinko.label_count + (int)this.COUNT);
            this.plinko.current_bin.setText(this.plinko.label_bin + (this.CURRENT_BIN + 1));
            this.plinko.current_bin_count.setText(this.plinko.label_bin_count + this.HIST[this.CURRENT_BIN]);
        }
    }

    public void drawHist(Graphics2D graphics2D) {
        this.W = this.getWidth();
        this.H = this.getHeight();
        for (int i = 0; i < this.BINS; ++i) {
            double d;
            double d2;
            if (i == 0) {
                d2 = this.PINS[this.BINS - 1][0][0] - this.DIST;
                d = this.PINS[this.BINS - 2][0][0];
            } else if (i == this.BINS - 1) {
                d2 = this.PINS[this.BINS - 2][this.BINS - 2][0];
                d = this.PINS[this.BINS - 1][this.BINS - 1][0] + this.DIST;
            } else {
                d2 = this.PINS[this.BINS - 2][i - 1][0];
                d = this.PINS[this.BINS - 2][i][0];
            }
            long l = this.HIST[i];
            if (this.MAX > (float)this.BIN_HEIGHT) {
                l = (int)((double)this.BIN_HEIGHT * 1.0 * (double)l / (double)this.MAX);
            }
            graphics2D.setColor(new Color(255, 0, 0, 175));
            if (i >= this.LEFT && i <= this.RIGHT) {
                graphics2D.setColor(new Color(0, 255, 0, 175));
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, (long)this.H - l - (long)this.BOTTOM_MARGIN, d - d2, l);
            graphics2D.fill(double_);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(double_);
        }
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.draw(new Line2D.Double(this.PINS[this.BINS - 1][this.CURRENT_BIN][0] - this.DIST, this.H - this.BOTTOM_MARGIN + 3, this.PINS[this.BINS - 1][this.CURRENT_BIN][0] + this.DIST, this.H - this.BOTTOM_MARGIN + 3));
    }

    public void drawBackground() {
        this.drawBackground(this.getWidth(), this.getHeight());
    }

    public void drawBackground(int n, int n2) {
        double[] dArray;
        Graphics2D graphics2D = (Graphics2D)this.background.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.black);
        Image image = PlinkoBoard.getBall(this.PIN_RAD, Color.black);
        for (int i = 0; i < this.BINS - 1; ++i) {
            for (int j = 0; j <= i; ++j) {
                dArray = this.PINS[i][j];
                graphics2D.drawImage(image, (int)(dArray[0] - (double)this.PIN_RAD), (int)(dArray[1] - (double)this.PIN_RAD), this);
            }
        }
        graphics2D.setFont(new Font("Helvetica", 1, Math.min((int)(4.0 * this.DIST) / 3, this.BIN_HEIGHT / 2)));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        dArray = this.PINS[this.BINS - 1][0];
        graphics2D.draw(new Line2D.Double(dArray[0] - this.DIST, n2 - this.BIN_HEIGHT - this.BOTTOM_MARGIN, dArray[0] - this.DIST, n2 - this.BOTTOM_MARGIN));
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawString(this.start_number, (int)(dArray[0] - (double)(fontMetrics.stringWidth("0") / 2)), n2 - this.BIN_HEIGHT - this.BOTTOM_MARGIN + Math.min((int)(4.0 * this.DIST) / 3, this.BIN_HEIGHT / 2));
        for (int i = 0; i < this.BINS - 1; ++i) {
            dArray = this.PINS[this.BINS - 2][i];
            String string = "" + (i + this.incr);
            graphics2D.setColor(Color.darkGray);
            graphics2D.drawString(string, (int)(dArray[0] + this.DIST - (double)(fontMetrics.stringWidth(string) / 2)), n2 - this.BIN_HEIGHT - this.BOTTOM_MARGIN + Math.min((int)(4.0 * this.DIST) / 3, this.BIN_HEIGHT / 2));
            graphics2D.setColor(Color.black);
            graphics2D.draw(new Line2D.Double(dArray[0], n2 - this.BIN_HEIGHT - this.BOTTOM_MARGIN, dArray[0], n2 - this.BOTTOM_MARGIN));
        }
        dArray = this.PINS[this.BINS - 1][this.BINS - 1];
        graphics2D.draw(new Line2D.Double(dArray[0] + this.DIST, n2 - this.BIN_HEIGHT - this.BOTTOM_MARGIN, dArray[0] + this.DIST, n2 - this.BOTTOM_MARGIN));
        graphics2D.draw(new Line2D.Double(0.0, n2 - this.BOTTOM_MARGIN, n, n2 - this.BOTTOM_MARGIN));
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (c >= '0' && c <= '4') {
            int n2;
            int n3 = c - 48;
            int n4 = 1;
            for (n2 = 0; n2 < n3; ++n2) {
                n4 *= 10;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                this.dropBall(n4 == 1);
            }
        } else if (n == 37) {
            --this.CURRENT_BIN;
            if (this.CURRENT_BIN < 0) {
                this.CURRENT_BIN = this.BINS - 1;
            }
            this.updatePercent();
            this.repaint();
        } else if (n == 39) {
            ++this.CURRENT_BIN;
            if (this.CURRENT_BIN > this.BINS - 1) {
                this.CURRENT_BIN = 0;
            }
            this.updatePercent();
            this.repaint();
        } else if (n != 10) {
            if (c == ' ') {
                this.plinko.toggleStart();
            } else if (c == '\u0014' || c == '\u0003' || c == '\u0018') {
                // empty if block
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void updatePercent() {
        double d = (double)(this.BINS - 1) * (Double)Plinko.prob.getValue();
        if ((double)this.CURRENT_BIN <= d) {
            this.LEFT = this.CURRENT_BIN;
            this.RIGHT = (int)(2.0 * d) - this.LEFT;
        } else {
            this.RIGHT = this.CURRENT_BIN;
            this.LEFT = (int)(2.0 * d) - this.RIGHT;
        }
        this.LEFT = Math.max(this.LEFT, 0);
        this.RIGHT = Math.min(this.RIGHT, this.BINS - 1);
        this.PERCENT = 0.0;
        for (int i = this.LEFT; i <= this.RIGHT; ++i) {
            this.PERCENT += (double)this.HIST[i];
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
        Point point = mouseEvent.getPoint();
        if ((double)point.x + this.DIST > this.PINS[this.BINS - 1][0][0] && (double)point.x - this.DIST < this.PINS[this.BINS - 1][this.BINS - 1][0] && point.y > this.H - this.BIN_HEIGHT - this.BOTTOM_MARGIN && point.y < this.H - this.BOTTOM_MARGIN) {
            int n;
            for (n = 0; n < this.BINS - 1 && !((double)point.x + this.DIST < this.PINS[this.BINS - 1][n + 1][0]); ++n) {
            }
            this.CURRENT_BIN = n;
            this.updatePercent();
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    static {
        COLORS = new Color[]{Color.red, Color.magenta, Color.orange, Color.yellow, Color.green, Color.blue, Color.cyan};
    }
}

