#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.net.conch_channels import PortForward
from winswitch.consts import LOCALHOST
from winswitch.util.simple_logger import Logger
from conch_test_common import make_factory
from winswitch.util.main_loop import loop_init, loop_run, loop_exit, callLater, connectTCP
logger = Logger("conch_tunnel_test")


def ssh_forward(host, port, local_port, remote_host, remote_port):
	factory = make_factory(host, port)
	pf = lambda connection : PortForward(local_port, remote_host, remote_port, connection)
	factory.channel_constructors.append(pf)
	loop_init(False)
	connectTCP(host, port, factory)
	callLater(20, loop_exit)
	try:
		loop_run()
	except Exception, e:
		logger.serr(None, e, host, port, local_port, remote_host, remote_port)
	logger.slog("ended", host, port, local_port, remote_host, remote_port)

def main():
	ssh_forward(LOCALHOST, 22, 8080, LOCALHOST, 10000)

if __name__ == "__main__":
	main()
