/* fieldlistviewdnd.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef FIELDLISTVIEWDND_H
#define FIELDLISTVIEWDND_H

#include "aguixdefs.h"
#include "fieldlistview.h"
#include "dndtext.h"
#include <vector>
#include <string>

class FieldListViewDND:public FieldListView
{
public:
  FieldListViewDND( AGUIX *aguix, int x, int y, int width, int height, int data );
  virtual ~FieldListViewDND();
  FieldListViewDND( const FieldListViewDND &other );
  FieldListViewDND &operator=( const FieldListViewDND &other );

  virtual const char *getType() const;
  virtual bool isType(const char *type) const;
  void removealldndtexts();
  void replacedndtext( int, const char* );
  void adddndtext( const char* );
  
  void setSizeDNDText(int);
private:
  static const char *type;
  virtual void handleSelect(Message *msg);
  std::vector<std::string> dndtexts;

  typedef enum { DND_IDLE, DND_DEACTIVE, DND_ACTIVE } dndMode_t;
  dndMode_t dndMode;
  DNDText *dndtext;
  void handleDND( Message *msg );
};

#endif
