/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_integrate_ex.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_integrate_ex.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_INTEGRATE_EX
#define XMDS_INTEGRATE_EX

#include <xmds_integrate.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsIntegrateEX
// *****************************************************************************
// *****************************************************************************

//! Class to integrate equations in explicit picture
class xmdsIntegrateEX : public virtual xmdsIntegrate {

  public :

    //! Constructor of xmdsIntegrateEX object
    xmdsIntegrateEX(
        const xmdsSimulation *const yourSimulation,
        const bool& yourVerboseMode);

  //! Destructor
  ~xmdsIntegrateEX();

  //! Processes the element
  void processElement(
                      const Element *const yourElement);

  protected :

    //! Writes the function prototypes to outfile
    void writePrototypes(
       FILE *const outfile) const;

  //! Writes the routines to outfile
  void writeRoutines(
                     FILE *const outfile) const;

  private :

    //! Writes the routine for calculating the k-operator field to file
    void writeCalculatekOperatorFieldRoutine(
               FILE *const outfile) const;

  //! Writes the routine for calculating the component terms for constant k-operators to file
  void writeCalculateCOTermsConstantKRoutine(
                                             FILE *const outfile) const;

  //! Writes the routine for calculating the component terms for time dependent k-operators to file
  void writeCalculateCOTermsTimeDepKRoutine(
                                            FILE *const outfile) const;
};


#endif // XMDS_INTEGRATE_EX
