//-----------------------------------------------------------------------------
//  Copyright (C) 2002-2010 Thomas S. Ullrich 
//
//  This file is part of "xyscan".
//
//  This file may be used under the terms of the GNU General Public License.
//  This project is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License.
//  
//  Author: Thomas S. Ullrich
//  Last update: April 26, 2010
//-----------------------------------------------------------------------------
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "xyscanStateMachine.h"
#include "xyscanUpdater.h"

class QAction;
class QListWidget;
class QMenu;
class QGraphicsView;
class QGraphicsScene;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QComboBox;
class QTableWidget;
class QGraphicsPixmapItem;
class QGraphicsLineItem;
class QGraphicsSceneDragDropEvent;
class QDoubleSpinBox;
class QLabel;
class xyscanAbout;
class xyscanHelpBrowser;
class xyscanUpdater;

class xyscanWindow : public QMainWindow
{
    Q_OBJECT

public:
    xyscanWindow();
    ~xyscanWindow();

protected:    
    bool eventFilter(QObject*, QEvent*);
    void closeEvent(QCloseEvent*);
    
private slots:
    // File menu
    void open();
    void openRecent();
    void clearHistory();
    void save();
    void print();
    void finish();
    
    // Edit
    void editCrosshairColor();
    void deleteLast();
    void deleteAll();
    void editComment();
    void pasteImage(); 
    
    // View
    void showPrecision();
    
    // Help menu
    void checkForUpdates();
    void about();
    void help();
    void showTooltips();
    
    // Set Markers
    void setLowerXButton();
    void setUpperXButton();
    void setLowerYButton();
    void setUpperYButton();
    
    // axis scale, image scale and rotation ange
    void updateWhenAxisScaleChanged();
    void rotateImage(double);
    void scaleImage(double);
    
private:
    void createMenuActions();
    void createMarkerActions();
    void createMenus();
    void createStatusBar();
    void createDockWindows();
    void createCoordinateWidget(QWidget*);
    void createSettingsWidget(QWidget*);
    void createTableWidget(QWidget*); 
    void createTransformWidget(QWidget*); 
    void createMarker();
    void createCrosshair();
    void createHelpBrowser();
    
    void loadSettings();
    void writeSettings();
    
    void openFromFile(const QString&);
    void loadPixmap(QPixmap*);
    void updatePixelDisplay();
    void updatePlotCoordinateDisplay();
    void ensureCursorVisible();
    void handleKeyEvent(QKeyEvent*);
    void handleDropEvent(QGraphicsSceneDragDropEvent*);
    bool readyForScan();
    int  numberOfMarkersSet();
    void resetMarker();
   
    QPointF scan();
    
    void addToTable(double, double, double, double, double, double);
        
private:    
    enum {mXLower, mXUpper, mYLower, mYUpper};
    enum {mNone=0, mAsymmetric, mAverage, mMax};
    enum {mMaxRecentFiles = 5};

    QGraphicsView   *mImageView;
    QGraphicsScene  *mImageScene;
    
    QMenu *mFileMenu;
    QMenu *mEditMenu;
    QMenu *mViewMenu;
    QMenu *mHelpMenu;
    QMenu *mRecentFilesMenu;
    
    QDockWidget *mCoordinateDock;
    QDockWidget *mSettingsDock;
    QDockWidget *mTableDock;
    QDockWidget *mTransformDock;
        
    QLineEdit *mPixelXDisplay;
    QLineEdit *mPixelYDisplay;
    QLineEdit *mPlotXDisplay;
    QLineEdit *mPlotYDisplay;
    
    QAction *mOpenAction;
    QAction *mSaveAction;
    QAction *mPrintAction;
    QAction *mFinishAction;
    QAction *mDeleteLastAction;
    QAction *mDeleteAllAction;
    QAction *mEditCommentAction;
    QAction *mEditCrosshairColorAction;
    QAction *mAboutAction;
    QAction *mHelpAction;
    QAction *mCheckForUpdatesAction;
    QAction *mSetLowerXAction;
    QAction *mSetUpperXAction;
    QAction *mSetLowerYAction;
    QAction *mSetUpperYAction;
    QAction *mPasteImageAction;
    QAction *mRecentFileAction[mMaxRecentFiles];
    QAction *mClearHistoryAction;
    QAction *mShowPrecisionAction;
    QAction *mShowTooltipsAction;
    
    QPushButton *mSetLowerXButton;
    QPushButton *mSetUpperXButton;
    QPushButton *mSetLowerYButton;
    QPushButton *mSetUpperYButton;
    
    QLineEdit *mUpperYValueField;
    QLineEdit *mLowerYValueField;
    QLineEdit *mUpperXValueField;
    QLineEdit *mLowerXValueField;

    QRadioButton *mLogXRadioButton;
    QRadioButton *mLogYRadioButton;

    QComboBox *mErrorXModeComboBox;
    QComboBox *mErrorYModeComboBox;

    QDoubleSpinBox *mAngleSpinBox;
    QDoubleSpinBox *mScaleSpinBox;
    
    QTableWidget *mTableWidget;

    QString mOpenFileDirectory;
    QString mSaveFileDirectory;
    QString mUserComment;
    QString mCurrentSource;
    
    QStringList mRecentFiles;
    
    QGraphicsPixmapItem* mCurrentPixmap;
    QGraphicsPixmapItem* mPointMarker;
    QGraphicsLineItem* mMarker[4];

    QGraphicsLineItem *mCrosshairH;
    QGraphicsLineItem *mCrosshairV;
    
    QLabel* mPlotInfoLabel;
    
    QColor  mCrosshairColor;
    
    xyscanStateMachine mStateMachine;
    xyscanAbout       *mAboutDialog;
    xyscanHelpBrowser *mHelpBrowser;
    xyscanUpdater     mUpdater;
    
    double  mMarkerPixel[4];
    double  mMarkerPlotCoordinate[4];
    bool    mDataSaved;
    double  mImageAngle;
    double  mImageScale;
};

#endif

